/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.mojo.license.header;

import com.google.code.mojo.license.header.HeaderDefinition;
import com.google.code.mojo.license.util.FileContent;
import com.google.code.mojo.license.util.StringUtils;

public final class HeaderParser {
    private final int beginPosition;
    private final int endPosition;
    private final boolean existingHeader;
    private final FileContent fileContent;
    private final String[] keywords;
    private HeaderDefinition headerDefinition;
    private String line;

    public HeaderParser(FileContent fileContent, HeaderDefinition headerDefinition, String[] keywords) {
        if (fileContent == null) {
            throw new IllegalArgumentException("Cannot create a header parser for null file content");
        }
        if (headerDefinition == null) {
            throw new IllegalArgumentException("Cannot work on file header if the header definition is null");
        }
        this.keywords = (String[])keywords.clone();
        this.headerDefinition = headerDefinition;
        this.fileContent = fileContent;
        this.beginPosition = this.findBeginPosition();
        this.existingHeader = this.hasHeader();
        this.endPosition = this.existingHeader ? this.findEndPosition() : -1;
    }

    public int getBeginPosition() {
        return this.beginPosition;
    }

    public int getEndPosition() {
        return this.endPosition;
    }

    public boolean gotAnyHeader() {
        return this.existingHeader;
    }

    public FileContent getFileContent() {
        return this.fileContent;
    }

    public HeaderDefinition getHeaderDefinition() {
        return this.headerDefinition;
    }

    private int findBeginPosition() {
        int beginPos = 0;
        this.line = this.fileContent.nextLine();
        if (this.headerDefinition.getSkipLinePattern() == null) {
            return beginPos;
        }
        while (this.line != null && !this.headerDefinition.isSkipLine(this.line)) {
            this.line = this.fileContent.nextLine();
        }
        if (this.line == null) {
            this.fileContent.reset();
        }
        beginPos = this.line == null ? 0 : this.fileContent.getPosition();
        this.line = this.fileContent.nextLine();
        return beginPos;
    }

    private boolean hasHeader() {
        while (this.line != null && "".equals(this.line.trim())) {
            this.line = this.fileContent.nextLine();
        }
        boolean gotHeader = false;
        if (this.headerDefinition.isFirstHeaderLine(this.line)) {
            if (this.headerDefinition.allowBlankLines()) {
                do {
                    this.line = this.fileContent.nextLine();
                } while (this.line != null && "".equals(this.line.trim()));
            }
            StringBuilder inPlaceHeader = new StringBuilder();
            String before = StringUtils.rtrim(this.headerDefinition.getBeforeEachLine());
            if ("".equals(before) && !this.headerDefinition.isMultiLine()) {
                before = this.headerDefinition.getBeforeEachLine();
            }
            boolean foundEnd = false;
            do {
                inPlaceHeader.append(this.line.toLowerCase());
                this.line = this.fileContent.nextLine();
                if (!this.headerDefinition.isMultiLine() || !this.headerDefinition.isLastHeaderLine(this.line)) continue;
                foundEnd = true;
                break;
            } while (this.line != null && this.line.startsWith(before));
            if (this.headerDefinition.allowBlankLines()) {
                do {
                    this.line = this.fileContent.nextLine();
                } while (this.line != null && "".equals(this.line.trim()));
            }
            if (this.headerDefinition.allowBlankLines() || !foundEnd) {
                this.fileContent.rewind();
            }
            if (!this.headerDefinition.isMultiLine()) {
                int pos = this.fileContent.getPosition();
                while (!(this.line == null || this.headerDefinition.isLastHeaderLine(this.line) || !this.headerDefinition.allowBlankLines() && "".equals(this.line.trim()))) {
                    this.line = this.fileContent.nextLine();
                }
                if (this.line == null) {
                    this.fileContent.resetTo(pos);
                }
            }
            gotHeader = true;
            for (String keyword : this.keywords) {
                if (inPlaceHeader.indexOf(keyword.toLowerCase()) != -1) continue;
                gotHeader = false;
                break;
            }
        }
        return gotHeader;
    }

    private int findEndPosition() {
        int end = this.fileContent.getPosition();
        this.line = this.fileContent.nextLine();
        if (this.line != null && "".equals(this.line.trim())) {
            end = this.fileContent.getPosition();
        }
        return end;
    }
}

