/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.mojo.license;

import com.google.code.mojo.license.AbstractLicenseMojo;
import com.google.code.mojo.license.Callback;
import com.google.code.mojo.license.document.Document;
import com.google.code.mojo.license.header.Header;
import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public final class LicenseRemoveMojo
extends AbstractLicenseMojo {
    protected boolean dryRun = false;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"Removing license headers...");
        this.execute(new Callback(){

            @Override
            public void onHeaderNotFound(Document document, Header header) {
                LicenseRemoveMojo.this.debug("Header was not found in: %s (But keep trying to find another header to remove)", document.getFile());
                LicenseRemoveMojo.this.remove(document);
            }

            @Override
            public void onExistingHeader(Document document, Header header) {
                LicenseRemoveMojo.this.info("Removing license header from: %s", document.getFile());
                LicenseRemoveMojo.this.remove(document);
            }
        });
    }

    private void remove(Document document) {
        document.parseHeader();
        if (document.headerDetected()) {
            document.removeHeader();
        }
        if (!this.dryRun) {
            document.save();
        } else {
            String name = document.getFile().getName() + ".licensed";
            File copy = new File(document.getFile().getParentFile(), name);
            this.info("Result saved to: %s", copy);
            document.saveTo(copy);
        }
    }
}

