/*
 * Decompiled with CFR 0.152.
 */
package org.bson.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class Bits {
    public static void readFully(InputStream in, byte[] b) throws IOException {
        Bits.readFully(in, b, b.length);
    }

    public static void readFully(InputStream in, byte[] b, int l) throws IOException {
        int temp;
        for (int x = 0; x < l; x += temp) {
            temp = in.read(b, x, l - x);
            if (temp >= 0) continue;
            throw new EOFException();
        }
    }

    public static int readInt(InputStream in) throws IOException {
        return Bits.readInt(in, new byte[4]);
    }

    public static int readInt(InputStream in, byte[] data) throws IOException {
        Bits.readFully(in, data, 4);
        return Bits.readInt(data);
    }

    public static int readInt(byte[] data) {
        int x = 0;
        x |= (0xFF & data[0]) << 0;
        x |= (0xFF & data[1]) << 8;
        x |= (0xFF & data[2]) << 16;
        return x |= (0xFF & data[3]) << 24;
    }

    public static long readLong(InputStream in) throws IOException {
        return Bits.readLong(in, new byte[8]);
    }

    public static long readLong(InputStream in, byte[] data) throws IOException {
        Bits.readFully(in, data, 8);
        return Bits.readLong(data);
    }

    public static long readLong(byte[] data) {
        long x = 0L;
        x |= (0xFFL & (long)data[0]) << 0;
        x |= (0xFFL & (long)data[1]) << 8;
        x |= (0xFFL & (long)data[2]) << 16;
        x |= (0xFFL & (long)data[3]) << 24;
        x |= (0xFFL & (long)data[4]) << 32;
        x |= (0xFFL & (long)data[5]) << 40;
        x |= (0xFFL & (long)data[6]) << 48;
        return x |= (0xFFL & (long)data[7]) << 56;
    }
}

