/*
 * Decompiled with CFR 0.152.
 */
package org.granite.generator.as3.reflect;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.persistence.IdClass;
import org.granite.generator.as3.reflect.JavaBean;
import org.granite.generator.as3.reflect.JavaFieldProperty;
import org.granite.generator.as3.reflect.JavaProperty;
import org.granite.generator.as3.reflect.JavaType;
import org.granite.generator.as3.reflect.JavaTypeFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaEntityBean
extends JavaBean {
    protected final List<JavaFieldProperty> identifiers;
    protected final JavaType idClass;
    protected JavaProperty version;
    protected final List<JavaProperty> lazyProperties;

    public JavaEntityBean(JavaTypeFactory provider, Class<?> type, URL url) {
        super(provider, type, url);
        ArrayList<JavaFieldProperty> tmpIdentifiers = new ArrayList<JavaFieldProperty>();
        ArrayList<JavaProperty> tmpLazyProperties = new ArrayList<JavaProperty>();
        for (JavaProperty property : this.properties.values()) {
            if (property instanceof JavaFieldProperty && provider.isId((JavaFieldProperty)property)) {
                tmpIdentifiers.add((JavaFieldProperty)property);
                continue;
            }
            if (provider.isVersion(property)) {
                this.version = property;
                continue;
            }
            if (!provider.isLazy(property)) continue;
            tmpLazyProperties.add(property);
        }
        this.identifiers = tmpIdentifiers.isEmpty() ? null : Collections.unmodifiableList(tmpIdentifiers);
        this.lazyProperties = tmpLazyProperties.isEmpty() ? null : Collections.unmodifiableList(tmpLazyProperties);
        JavaType javaType = this.idClass = type.isAnnotationPresent(IdClass.class) ? provider.getJavaType(type.getAnnotation(IdClass.class).value()) : null;
        if (this.idClass != null) {
            this.addToImports(provider.getJavaImport(this.idClass.getType()));
        }
    }

    public boolean hasIdentifiers() {
        return this.identifiers != null && !this.identifiers.isEmpty();
    }

    public List<JavaFieldProperty> getIdentifiers() {
        return this.identifiers;
    }

    public JavaFieldProperty getFirstIdentifier() {
        return this.identifiers != null ? this.identifiers.get(0) : null;
    }

    public boolean hasIdClass() {
        return this.idClass != null;
    }

    public JavaType getIdClass() {
        return this.idClass;
    }

    public boolean hasVersion() {
        return this.version != null;
    }

    public JavaProperty getVersion() {
        return this.version;
    }

    public boolean isLazy(JavaProperty property) {
        return this.lazyProperties != null && this.lazyProperties.contains(property);
    }
}

