/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritePendingException;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import org.eclipse.jetty.http.HttpContent;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.util.BlockingCallback;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.IteratingCallback;
import org.eclipse.jetty.util.IteratingNestedCallback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class HttpOutput
extends ServletOutputStream
implements Runnable {
    private static Logger LOG = Log.getLogger(HttpOutput.class);
    private final HttpChannel<?> _channel;
    private long _written;
    private ByteBuffer _aggregate;
    private int _bufferSize;
    private int _commitSize;
    private WriteListener _writeListener;
    private volatile Throwable _onError;
    private final AtomicReference<State> _state = new AtomicReference<State>(State.OPEN);

    public HttpOutput(HttpChannel<?> channel) {
        this._channel = channel;
        this._bufferSize = this._channel.getHttpConfiguration().getOutputBufferSize();
        this._commitSize = this._bufferSize / 4;
    }

    public boolean isWritten() {
        return this._written > 0L;
    }

    public long getWritten() {
        return this._written;
    }

    public void reset() {
        this._written = 0L;
        this.reopen();
    }

    public void reopen() {
        this._state.set(State.OPEN);
    }

    public boolean isAllContentWritten() {
        return this._channel.getResponse().isAllContentWritten(this._written);
    }

    public void close() {
        State state = this._state.get();
        while (state != State.CLOSED) {
            if (this._state.compareAndSet(state, State.CLOSED)) {
                try {
                    if (BufferUtil.hasContent((ByteBuffer)this._aggregate)) {
                        this._channel.write(this._aggregate, !this._channel.getResponse().isIncluding());
                    } else {
                        this._channel.write(BufferUtil.EMPTY_BUFFER, !this._channel.getResponse().isIncluding());
                    }
                }
                catch (IOException e) {
                    LOG.debug((Throwable)e);
                    this._channel.failed();
                }
                this.releaseBuffer();
                return;
            }
            state = this._state.get();
        }
    }

    void closed() {
        State state = this._state.get();
        while (state != State.CLOSED) {
            if (this._state.compareAndSet(state, State.CLOSED)) {
                try {
                    this._channel.getResponse().closeOutput();
                }
                catch (IOException e) {
                    LOG.debug((Throwable)e);
                    this._channel.failed();
                }
                this.releaseBuffer();
                return;
            }
            state = this._state.get();
        }
    }

    private void releaseBuffer() {
        if (this._aggregate != null) {
            this._channel.getConnector().getByteBufferPool().release(this._aggregate);
            this._aggregate = null;
        }
    }

    public boolean isClosed() {
        return this._state.get() == State.CLOSED;
    }

    public void flush() throws IOException {
        block7: while (true) {
            switch (this._state.get()) {
                case OPEN: {
                    if (BufferUtil.hasContent((ByteBuffer)this._aggregate)) {
                        this._channel.write(this._aggregate, false);
                    } else {
                        this._channel.write(BufferUtil.EMPTY_BUFFER, false);
                    }
                    return;
                }
                case ASYNC: {
                    throw new IllegalStateException("isReady() not called");
                }
                case READY: {
                    if (!this._state.compareAndSet(State.READY, State.PENDING)) continue block7;
                    new AsyncFlush().process();
                    return;
                }
                case PENDING: 
                case UNREADY: {
                    throw new WritePendingException();
                }
                case CLOSED: {
                    return;
                }
            }
            break;
        }
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this._written += (long)len;
        boolean complete = this._channel.getResponse().isAllContentWritten(this._written);
        block7: while (true) {
            switch (this._state.get()) {
                case OPEN: {
                    break block7;
                }
                case ASYNC: {
                    throw new IllegalStateException("isReady() not called");
                }
                case READY: {
                    if (!this._state.compareAndSet(State.READY, State.PENDING)) continue block7;
                    int capacity = this.getBufferSize();
                    if (!complete && len <= this._commitSize) {
                        int filled;
                        if (this._aggregate == null) {
                            this._aggregate = this._channel.getByteBufferPool().acquire(capacity, false);
                        }
                        if ((filled = BufferUtil.fill((ByteBuffer)this._aggregate, (byte[])b, (int)off, (int)len)) == len && !BufferUtil.isFull((ByteBuffer)this._aggregate)) {
                            if (!this._state.compareAndSet(State.PENDING, State.ASYNC)) {
                                throw new IllegalStateException();
                            }
                            return;
                        }
                        off += filled;
                        len -= filled;
                    }
                    new AsyncWrite(b, off, len, complete).process();
                    return;
                }
                case PENDING: 
                case UNREADY: {
                    throw new WritePendingException();
                }
                case CLOSED: {
                    throw new EofException("Closed");
                }
            }
            break;
        }
        int capacity = this.getBufferSize();
        if (!complete && len <= this._commitSize) {
            int filled;
            if (this._aggregate == null) {
                this._aggregate = this._channel.getByteBufferPool().acquire(capacity, false);
            }
            if ((filled = BufferUtil.fill((ByteBuffer)this._aggregate, (byte[])b, (int)off, (int)len)) == len && !BufferUtil.isFull((ByteBuffer)this._aggregate)) {
                return;
            }
            off += filled;
            len -= filled;
        }
        if (BufferUtil.hasContent((ByteBuffer)this._aggregate)) {
            this._channel.write(this._aggregate, complete && len == 0);
            if (len > 0 && !complete && len <= this._commitSize) {
                BufferUtil.append((ByteBuffer)this._aggregate, (byte[])b, (int)off, (int)len);
                return;
            }
        }
        if (len > 0) {
            this._channel.write(ByteBuffer.wrap(b, off, len).asReadOnlyBuffer(), complete);
        } else if (complete) {
            this._channel.write(BufferUtil.EMPTY_BUFFER, complete);
        }
        if (complete) {
            this.closed();
        }
    }

    public void write(ByteBuffer buffer) throws IOException {
        this._written += (long)buffer.remaining();
        boolean complete = this._channel.getResponse().isAllContentWritten(this._written);
        block7: while (true) {
            switch (this._state.get()) {
                case OPEN: {
                    break block7;
                }
                case ASYNC: {
                    throw new IllegalStateException("isReady() not called");
                }
                case READY: {
                    if (!this._state.compareAndSet(State.READY, State.PENDING)) continue block7;
                    new AsyncWrite(buffer, complete).process();
                    return;
                }
                case PENDING: 
                case UNREADY: {
                    throw new WritePendingException();
                }
                case CLOSED: {
                    throw new EofException("Closed");
                }
            }
            break;
        }
        int len = BufferUtil.length((ByteBuffer)buffer);
        if (BufferUtil.hasContent((ByteBuffer)this._aggregate)) {
            this._channel.write(this._aggregate, complete && len == 0);
        }
        if (len > 0) {
            this._channel.write(buffer, complete);
        } else if (complete) {
            this._channel.write(BufferUtil.EMPTY_BUFFER, complete);
        }
        if (complete) {
            this.closed();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void write(int b) throws IOException {
        ++this._written;
        boolean complete = this._channel.getResponse().isAllContentWritten(this._written);
        block7: while (true) {
            switch (this._state.get()) {
                case OPEN: {
                    if (this._aggregate == null) {
                        this._aggregate = this._channel.getByteBufferPool().acquire(this.getBufferSize(), false);
                    }
                    BufferUtil.append((ByteBuffer)this._aggregate, (byte)((byte)b));
                    if (!complete && !BufferUtil.isFull((ByteBuffer)this._aggregate)) return;
                    BlockingCallback callback = this._channel.getWriteBlockingCallback();
                    this._channel.write(this._aggregate, complete, (Callback)callback);
                    callback.block();
                    if (!complete) return;
                    this.closed();
                    return;
                }
                case ASYNC: {
                    throw new IllegalStateException("isReady() not called");
                }
                case READY: {
                    if (!this._state.compareAndSet(State.READY, State.PENDING)) continue block7;
                    if (this._aggregate == null) {
                        this._aggregate = this._channel.getByteBufferPool().acquire(this.getBufferSize(), false);
                    }
                    BufferUtil.append((ByteBuffer)this._aggregate, (byte)((byte)b));
                    if (!complete && !BufferUtil.isFull((ByteBuffer)this._aggregate)) {
                        if (this._state.compareAndSet(State.PENDING, State.ASYNC)) return;
                        throw new IllegalStateException();
                    }
                    new AsyncFlush().process();
                    return;
                }
                case PENDING: 
                case UNREADY: {
                    throw new WritePendingException();
                }
                case CLOSED: {
                    throw new EofException("Closed");
                }
            }
            break;
        }
    }

    public void print(String s) throws IOException {
        if (this.isClosed()) {
            throw new IOException("Closed");
        }
        this.write(s.getBytes(this._channel.getResponse().getCharacterEncoding()));
    }

    public void sendContent(ByteBuffer content) throws IOException {
        BlockingCallback callback = this._channel.getWriteBlockingCallback();
        if (content.hasArray() && content.limit() < content.capacity()) {
            content = content.asReadOnlyBuffer();
        }
        this._channel.write(content, true, (Callback)callback);
        callback.block();
    }

    public void sendContent(InputStream in) throws IOException {
        BlockingCallback callback = this._channel.getWriteBlockingCallback();
        new InputStreamWritingCB(in, (Callback)callback).iterate();
        callback.block();
    }

    public void sendContent(ReadableByteChannel in) throws IOException {
        BlockingCallback callback = this._channel.getWriteBlockingCallback();
        new ReadableByteChannelWritingCB(in, (Callback)callback).iterate();
        callback.block();
    }

    public void sendContent(HttpContent content) throws IOException {
        BlockingCallback callback = this._channel.getWriteBlockingCallback();
        this.sendContent(content, (Callback)callback);
        callback.block();
    }

    public void sendContent(ByteBuffer content, final Callback callback) {
        if (content.hasArray() && content.limit() < content.capacity()) {
            content = content.asReadOnlyBuffer();
        }
        this._channel.write(content, true, new Callback(){

            public void succeeded() {
                HttpOutput.this.closed();
                callback.succeeded();
            }

            public void failed(Throwable x) {
                callback.failed(x);
            }
        });
    }

    public void sendContent(InputStream in, Callback callback) {
        new InputStreamWritingCB(in, callback).iterate();
    }

    public void sendContent(ReadableByteChannel in, Callback callback) {
        new ReadableByteChannelWritingCB(in, callback).iterate();
    }

    public void sendContent(HttpContent httpContent, Callback callback) throws IOException {
        ByteBuffer buffer;
        if (BufferUtil.hasContent((ByteBuffer)this._aggregate)) {
            throw new IOException("written");
        }
        if (this._channel.isCommitted()) {
            throw new IOException("committed");
        }
        block4: while (true) {
            switch (this._state.get()) {
                case OPEN: {
                    if (this._state.compareAndSet(State.OPEN, State.PENDING)) break block4;
                    continue block4;
                }
                case CLOSED: {
                    throw new EofException("Closed");
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            break;
        }
        ByteBuffer byteBuffer = buffer = this._channel.useDirectBuffers() ? httpContent.getDirectBuffer() : null;
        if (buffer == null) {
            buffer = httpContent.getIndirectBuffer();
        }
        if (buffer != null) {
            this.sendContent(buffer, callback);
            return;
        }
        ReadableByteChannel rbc = httpContent.getReadableByteChannel();
        if (rbc != null) {
            this.sendContent(rbc, callback);
            return;
        }
        InputStream in = httpContent.getInputStream();
        if (in != null) {
            this.sendContent(in, callback);
            return;
        }
        callback.failed((Throwable)new IllegalArgumentException("unknown content for " + httpContent));
    }

    public int getBufferSize() {
        return this._bufferSize;
    }

    public void setBufferSize(int size) {
        this._bufferSize = size;
        this._commitSize = size;
    }

    public void resetBuffer() {
        if (BufferUtil.hasContent((ByteBuffer)this._aggregate)) {
            BufferUtil.clear((ByteBuffer)this._aggregate);
        }
    }

    public void setWriteListener(WriteListener writeListener) {
        if (!this._channel.getState().isAsync()) {
            throw new IllegalStateException("!ASYNC");
        }
        if (!this._state.compareAndSet(State.OPEN, State.READY)) {
            throw new IllegalStateException();
        }
        this._writeListener = writeListener;
        this._channel.getState().onWritePossible();
    }

    public boolean isReady() {
        block8: while (true) {
            switch (this._state.get()) {
                case OPEN: {
                    return true;
                }
                case ASYNC: {
                    if (!this._state.compareAndSet(State.ASYNC, State.READY)) continue block8;
                    return true;
                }
                case READY: {
                    return true;
                }
                case PENDING: {
                    if (!this._state.compareAndSet(State.PENDING, State.UNREADY)) continue block8;
                    return false;
                }
                case UNREADY: {
                    return false;
                }
                case CLOSED: {
                    return false;
                }
            }
        }
    }

    @Override
    public void run() {
        if (this._onError != null) {
            Throwable th = this._onError;
            this._onError = null;
            this._writeListener.onError(th);
            this.close();
        }
        if (this._state.get() == State.READY) {
            try {
                this._writeListener.onWritePossible();
            }
            catch (Throwable e) {
                this._writeListener.onError(e);
                this.close();
            }
        }
    }

    static /* synthetic */ AtomicReference access$300(HttpOutput x0) {
        return x0._state;
    }

    private class ReadableByteChannelWritingCB
    extends IteratingNestedCallback {
        private final ReadableByteChannel _in;
        private final ByteBuffer _buffer;
        private boolean _eof;

        public ReadableByteChannelWritingCB(ReadableByteChannel in, Callback callback) {
            super(callback);
            this._in = in;
            this._buffer = HttpOutput.this._channel.getByteBufferPool().acquire(HttpOutput.this.getBufferSize(), HttpOutput.this._channel.useDirectBuffers());
        }

        protected boolean process() throws Exception {
            if (this._eof) {
                this._in.close();
                HttpOutput.this.closed();
                HttpOutput.this._channel.getByteBufferPool().release(this._buffer);
                return true;
            }
            this._buffer.clear();
            while (this._buffer.hasRemaining() && !this._eof) {
                this._eof = this._in.read(this._buffer) < 0;
            }
            this._buffer.flip();
            HttpOutput.this._channel.write(this._buffer, this._eof, (Callback)this);
            return false;
        }

        public void failed(Throwable x) {
            super.failed(x);
            HttpOutput.this._channel.getByteBufferPool().release(this._buffer);
            try {
                this._in.close();
            }
            catch (IOException e) {
                LOG.ignore((Throwable)e);
            }
        }
    }

    private class InputStreamWritingCB
    extends IteratingNestedCallback {
        private final InputStream _in;
        private final ByteBuffer _buffer;
        private boolean _eof;

        public InputStreamWritingCB(InputStream in, Callback callback) {
            super(callback);
            this._in = in;
            this._buffer = HttpOutput.this._channel.getByteBufferPool().acquire(HttpOutput.this.getBufferSize(), false);
        }

        protected boolean process() throws Exception {
            if (this._eof) {
                this._in.close();
                HttpOutput.this.closed();
                HttpOutput.this._channel.getByteBufferPool().release(this._buffer);
                return true;
            }
            int len = 0;
            while (len < this._buffer.capacity() && !this._eof) {
                int r = this._in.read(this._buffer.array(), this._buffer.arrayOffset() + len, this._buffer.capacity() - len);
                if (r < 0) {
                    this._eof = true;
                    continue;
                }
                len += r;
            }
            this._buffer.position(0);
            this._buffer.limit(len);
            HttpOutput.this._channel.write(this._buffer, this._eof, (Callback)this);
            return false;
        }

        public void failed(Throwable x) {
            super.failed(x);
            HttpOutput.this._channel.getByteBufferPool().release(this._buffer);
            try {
                this._in.close();
            }
            catch (IOException e) {
                LOG.ignore((Throwable)e);
            }
        }
    }

    private class AsyncFlush
    extends IteratingCallback {
        protected boolean _flushed;

        protected boolean process() {
            if (BufferUtil.hasContent((ByteBuffer)HttpOutput.this._aggregate)) {
                this._flushed = true;
                HttpOutput.this._channel.write(HttpOutput.this._aggregate, false, (Callback)this);
                return false;
            }
            if (!this._flushed) {
                this._flushed = true;
                HttpOutput.this._channel.write(BufferUtil.EMPTY_BUFFER, false, (Callback)this);
                return false;
            }
            return true;
        }

        /*
         * Unable to fully structure code
         */
        protected void completed() {
            block9: {
                try {
                    block7: while (true) {
                        last = (State)HttpOutput.access$300(HttpOutput.this).get();
                        switch (2.$SwitchMap$org$eclipse$jetty$server$HttpOutput$State[last.ordinal()]) {
                            case 4: {
                                if (!HttpOutput.access$300(HttpOutput.this).compareAndSet(State.PENDING, State.ASYNC)) {
                                    continue block7;
                                }
                                break block9;
                            }
                            case 5: {
                                if (HttpOutput.access$300(HttpOutput.this).compareAndSet(State.UNREADY, State.READY)) ** break;
                                continue block7;
                                HttpOutput.access$100(HttpOutput.this).getState().onWritePossible();
                                break block7;
                            }
                            case 6: {
                                HttpOutput.access$402(HttpOutput.this, (Throwable)new EofException("Closed"));
                                break block7;
                            }
                            default: {
                                throw new IllegalStateException();
                            }
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    HttpOutput.access$402(HttpOutput.this, e);
                    HttpOutput.access$100(HttpOutput.this).getState().onWritePossible();
                }
            }
        }

        public void failed(Throwable e) {
            super.failed(e);
            HttpOutput.this._onError = e;
            HttpOutput.this._channel.getState().onWritePossible();
        }
    }

    private class AsyncWrite
    extends AsyncFlush {
        private final ByteBuffer _buffer;
        private final boolean _complete;
        private final int _len;

        public AsyncWrite(byte[] b, int off, int len, boolean complete) {
            this._buffer = ByteBuffer.wrap(b, off, len);
            this._complete = complete;
            this._len = len;
        }

        public AsyncWrite(ByteBuffer buffer, boolean complete) {
            this._buffer = buffer;
            this._complete = complete;
            this._len = buffer.remaining();
        }

        @Override
        protected boolean process() {
            if (BufferUtil.hasContent((ByteBuffer)HttpOutput.this._aggregate)) {
                HttpOutput.this._channel.write(HttpOutput.this._aggregate, this._complete && this._len == 0, (Callback)this);
                return false;
            }
            if (!this._complete && this._len < BufferUtil.space((ByteBuffer)HttpOutput.this._aggregate) && this._len < HttpOutput.this._commitSize) {
                BufferUtil.put((ByteBuffer)this._buffer, (ByteBuffer)HttpOutput.this._aggregate);
            } else {
                if (this._len > 0 && !this._flushed) {
                    this._flushed = true;
                    HttpOutput.this._channel.write(this._buffer, this._complete, (Callback)this);
                    return false;
                }
                if (this._len == 0 && !this._flushed) {
                    this._flushed = true;
                    HttpOutput.this._channel.write(BufferUtil.EMPTY_BUFFER, this._complete, (Callback)this);
                    return false;
                }
            }
            if (this._complete) {
                HttpOutput.this.closed();
            }
            return true;
        }
    }

    static enum State {
        OPEN,
        ASYNC,
        READY,
        PENDING,
        UNREADY,
        CLOSED;

    }
}

