/*
 * Decompiled with CFR 0.152.
 */
package org.compass.needle.gigaspaces.service;

import org.compass.core.Compass;
import org.compass.core.CompassCallback;
import org.compass.core.CompassException;
import org.compass.core.CompassHits;
import org.compass.core.CompassSession;
import org.compass.core.CompassTemplate;
import org.compass.needle.gigaspaces.service.CompassSearchService;
import org.compass.needle.gigaspaces.service.SearchResourceResult;
import org.compass.needle.gigaspaces.service.SearchResourceResults;
import org.compass.needle.gigaspaces.service.SearchResult;
import org.compass.needle.gigaspaces.service.SearchResults;
import org.openspaces.core.GigaSpace;

public class ServerCompassSearchService
implements CompassSearchService {
    private CompassTemplate compassTemplate;
    private GigaSpace gigaSpace;

    public void setCompass(Compass compass) {
        this.compassTemplate = new CompassTemplate(compass);
    }

    public void setGigaSpace(GigaSpace gigaSpace) {
        this.gigaSpace = gigaSpace;
    }

    public SearchResourceResults searchResource(String query) {
        return this.searchResource(query, -1);
    }

    public SearchResourceResults searchResource(String query, int maxResults) {
        return this.searchResource(query, maxResults, -1.0f);
    }

    public SearchResourceResults searchResource(final String query, final int maxResults, final float fromScore) {
        return this.compassTemplate.execute(new CompassCallback<SearchResourceResults>(){

            @Override
            public SearchResourceResults doInCompass(CompassSession session) throws CompassException {
                int startFrom;
                CompassHits hits = session.find(query);
                if (fromScore != -1.0f) {
                    for (startFrom = 0; startFrom < hits.length() && !(hits.score(startFrom) < fromScore); ++startFrom) {
                    }
                }
                int endWith = hits.length();
                if (maxResults != -1 && (endWith = startFrom + maxResults) > hits.length()) {
                    endWith = hits.length();
                }
                SearchResourceResult[] results = new SearchResourceResult[endWith - startFrom];
                for (int i = startFrom; i < endWith; ++i) {
                    results[i - startFrom] = new SearchResourceResult(hits.score(i), hits.resource(i));
                }
                return new SearchResourceResults(results, hits.length());
            }
        });
    }

    public SearchResults search(String query) {
        return this.search(query, -1);
    }

    public SearchResults search(String query, int maxResults) {
        return this.search(query, maxResults, -1.0f);
    }

    public SearchResults search(final String query, final int maxResults, final float fromScore) {
        return this.compassTemplate.execute(new CompassCallback<SearchResults>(){

            @Override
            public SearchResults doInCompass(CompassSession session) throws CompassException {
                int startFrom;
                CompassHits hits = session.find(query);
                if (fromScore != -1.0f) {
                    for (startFrom = 0; startFrom < hits.length() && !(hits.score(startFrom) < fromScore); ++startFrom) {
                    }
                }
                int endWith = hits.length();
                if (maxResults != -1 && (endWith = startFrom + maxResults) > hits.length()) {
                    endWith = hits.length();
                }
                SearchResult[] results = new SearchResult[endWith - startFrom];
                for (int i = startFrom; i < endWith; ++i) {
                    Object data = ServerCompassSearchService.this.gigaSpace.read(hits.data(i), 0L, 16384);
                    results[i - startFrom] = new SearchResult(hits.score(i), data);
                }
                return new SearchResults(results, hits.length());
            }
        });
    }
}

