/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.xml.javax;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.compass.core.util.DomUtils;
import org.compass.core.xml.XmlObject;
import org.compass.core.xml.XmlXPathExpression;
import org.compass.core.xml.javax.XPathXmlXPathExpression;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeXmlObject
implements XmlObject {
    private Node node;
    private Map<String, String> namespaces;

    public NodeXmlObject(Node node) {
        this.node = node;
    }

    public NodeXmlObject(Node node, Map<String, String> namespaces) {
        this.node = node;
        this.namespaces = namespaces;
    }

    @Override
    public void setNamespaces(Map<String, String> namespaces) {
        this.namespaces = namespaces;
    }

    @Override
    public Map<String, String> getNamespaces() {
        return this.namespaces;
    }

    @Override
    public String getName() {
        if (this.node.getLocalName() != null) {
            return this.node.getLocalName();
        }
        return this.node.getNodeName();
    }

    @Override
    public String getValue() {
        if (this.node.getNodeType() == 1) {
            return DomUtils.getTextValue((Element)this.node);
        }
        return this.node.getNodeValue();
    }

    @Override
    public XmlObject[] selectPath(String path) throws Exception {
        return this.compile(path).select(this);
    }

    @Override
    public boolean canCompileXpath() {
        return true;
    }

    @Override
    public XmlXPathExpression compile(String path) throws Exception {
        XPath xpath = XPathFactory.newInstance().newXPath();
        if (this.namespaces != null) {
            xpath.setNamespaceContext(new InternalNamespaceContext(this.namespaces));
        }
        XPathExpression xPathExpression = xpath.compile(path);
        return new XPathXmlXPathExpression(xPathExpression);
    }

    public Node getNode() {
        return this.node;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InternalNamespaceContext
    implements NamespaceContext {
        private Map<String, String> namespaces;

        private InternalNamespaceContext(Map<String, String> namespaces) {
            this.namespaces = namespaces;
        }

        @Override
        public String getNamespaceURI(String prefix) {
            return this.namespaces.get(prefix);
        }

        @Override
        public String getPrefix(String namespaceURI) {
            for (Map.Entry<String, String> entry : this.namespaces.entrySet()) {
                if (!namespaceURI.equals(entry.getValue())) continue;
                return entry.getKey();
            }
            return null;
        }

        public Iterator getPrefixes(String namespaceURI) {
            ArrayList<String> prefixes = new ArrayList<String>();
            for (Map.Entry<String, String> entry : this.namespaces.entrySet()) {
                if (!namespaceURI.equals(entry.getValue())) continue;
                prefixes.add(entry.getKey());
            }
            return prefixes.iterator();
        }
    }
}

