/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.transaction;

import java.util.HashMap;
import java.util.Map;
import org.compass.core.Compass;
import org.compass.core.CompassException;
import org.compass.core.CompassSession;
import org.compass.core.CompassTransaction;
import org.compass.core.config.CompassSettings;
import org.compass.core.spi.InternalCompassSession;
import org.compass.core.transaction.AbstractTransactionFactory;
import org.compass.core.transaction.InternalCompassTransaction;
import org.compass.core.transaction.LocalTransaction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalTransactionFactory
extends AbstractTransactionFactory {
    private static final ThreadLocal<Map<Compass, CompassSession>> context = new ThreadLocal();
    private boolean disableThreadBoundTx = false;

    @Override
    protected void doConfigure(CompassSettings settings) {
        this.disableThreadBoundTx = settings.getSettingAsBoolean("compass.transaction.disableThreadBoundLocalTransaction", false);
    }

    @Override
    protected boolean isWithinExistingTransaction(InternalCompassSession session) throws CompassException {
        return this.getTransactionBoundSession() == session;
    }

    @Override
    protected InternalCompassTransaction doBeginTransaction(InternalCompassSession session) throws CompassException {
        LocalTransaction tx = new LocalTransaction(session, this);
        tx.begin();
        return tx;
    }

    @Override
    protected InternalCompassTransaction doContinueTransaction(InternalCompassSession session) throws CompassException {
        LocalTransaction tx = new LocalTransaction(session, this);
        tx.join(session);
        return tx;
    }

    @Override
    public CompassSession getTransactionBoundSession() throws CompassException {
        if (this.disableThreadBoundTx) {
            return null;
        }
        Map<Compass, CompassSession> sessionMap = LocalTransactionFactory.sessionMap();
        if (sessionMap == null) {
            return null;
        }
        return sessionMap.get(this.compass);
    }

    public void unbindSessionFromTransaction(LocalTransaction tr, CompassSession session) {
        ((InternalCompassSession)session).unbindTransaction();
        if (this.disableThreadBoundTx) {
            return;
        }
        Map<Compass, CompassSession> sessionMap = LocalTransactionFactory.sessionMap();
        if (sessionMap != null) {
            sessionMap.remove(this.compass);
            if (sessionMap.isEmpty()) {
                context.set(null);
            }
        }
    }

    @Override
    protected void doBindSessionToTransaction(CompassTransaction tr, CompassSession session) throws CompassException {
        if (this.disableThreadBoundTx) {
            return;
        }
        Map<Compass, CompassSession> sessionMap = LocalTransactionFactory.sessionMap();
        if (sessionMap == null) {
            sessionMap = new HashMap<Compass, CompassSession>();
            context.set(sessionMap);
        }
        sessionMap.put(this.compass, session);
    }

    private static Map<Compass, CompassSession> sessionMap() {
        return context.get();
    }
}

