/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.transaction;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.compass.core.Compass;
import org.compass.core.CompassException;
import org.compass.core.CompassSession;
import org.compass.core.CompassTransaction;
import org.compass.core.config.CompassSettings;
import org.compass.core.spi.InternalCompassSession;
import org.compass.core.transaction.InternalCompassTransaction;
import org.compass.core.transaction.TransactionFactory;

public abstract class AbstractTransactionFactory
implements TransactionFactory {
    protected final Log log = LogFactory.getLog(this.getClass());
    protected Compass compass;
    protected boolean commitBeforeCompletion;
    private boolean disableAutoJoinSession = false;

    public void configure(Compass compass, CompassSettings settings) throws CompassException {
        this.compass = compass;
        this.commitBeforeCompletion = settings.getSettingAsBoolean("compass.transaction.commitBeforeCompletion", false);
        this.disableAutoJoinSession = settings.getSettingAsBoolean("compass.transaction.disableAutoJoinSession", false);
        this.doConfigure(settings);
    }

    protected void doConfigure(CompassSettings settings) {
    }

    public CompassTransaction tryJoinExistingTransaction(InternalCompassSession session) throws CompassException {
        if (this.disableAutoJoinSession) {
            return null;
        }
        if (!this.isWithinExistingTransaction(session)) {
            return null;
        }
        return this.beginTransaction(session);
    }

    protected abstract boolean isWithinExistingTransaction(InternalCompassSession var1) throws CompassException;

    public CompassTransaction beginTransaction(InternalCompassSession session) throws CompassException {
        InternalCompassTransaction tr;
        CompassSession boundSession = this.getTransactionBoundSession();
        if (boundSession == null || boundSession != session) {
            tr = this.doBeginTransaction(session);
            this.doBindSessionToTransaction(tr, session);
        } else {
            tr = this.doContinueTransaction(session);
        }
        tr.setBegun(true);
        return tr;
    }

    protected abstract InternalCompassTransaction doBeginTransaction(InternalCompassSession var1) throws CompassException;

    protected abstract InternalCompassTransaction doContinueTransaction(InternalCompassSession var1) throws CompassException;

    protected abstract void doBindSessionToTransaction(CompassTransaction var1, CompassSession var2) throws CompassException;
}

