/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.mapping.xsem.builder;

import org.compass.core.converter.Converter;
import org.compass.core.converter.mapping.ResourcePropertyConverter;
import org.compass.core.converter.mapping.support.FormatDelegateConverter;
import org.compass.core.engine.naming.StaticPropertyPath;
import org.compass.core.mapping.ExcludeFromAll;
import org.compass.core.mapping.SpellCheck;
import org.compass.core.mapping.xsem.XmlIdMapping;

public class XmlIdMappingBuilder {
    final XmlIdMapping mapping = new XmlIdMapping();

    public XmlIdMappingBuilder(String xpath) {
        this.mapping.setXPath(xpath);
        this.mapping.setOmitNorms(true);
        this.mapping.setOmitTf(true);
    }

    public XmlIdMappingBuilder indexName(String name) {
        this.mapping.setName(name);
        this.mapping.setPath(new StaticPropertyPath(name));
        return this;
    }

    public XmlIdMappingBuilder analyzer(String analyzer) {
        this.mapping.setAnalyzer(analyzer);
        return this;
    }

    public XmlIdMappingBuilder omitNorms(boolean omitNorms) {
        this.mapping.setOmitNorms(omitNorms);
        return this;
    }

    public XmlIdMappingBuilder omitTf(boolean omitTf) {
        this.mapping.setOmitTf(omitTf);
        return this;
    }

    public XmlIdMappingBuilder boost(float boost) {
        this.mapping.setBoost(boost);
        return this;
    }

    public XmlIdMappingBuilder format(String format) {
        this.mapping.setValueConverter(new FormatDelegateConverter(format));
        this.mapping.setFormat(format);
        return this;
    }

    public XmlIdMappingBuilder mappingConverter(String converterName) {
        this.mapping.setConverterName(converterName);
        return this;
    }

    public XmlIdMappingBuilder mappingConverter(Converter converter) {
        this.mapping.setConverter(converter);
        return this;
    }

    public XmlIdMappingBuilder valueConverter(String converterName) {
        this.mapping.setValueConverterName(converterName);
        return this;
    }

    public XmlIdMappingBuilder valueConverter(Converter converter) {
        this.mapping.setValueConverter(converter);
        return this;
    }

    public XmlIdMappingBuilder valueConverter(ResourcePropertyConverter converter) {
        this.mapping.setValueConverter(converter);
        return this;
    }

    public XmlIdMappingBuilder excludeFromAll(ExcludeFromAll excludeFromAll) {
        this.mapping.setExcludeFromAll(excludeFromAll);
        return this;
    }

    public XmlIdMappingBuilder spellCheck(SpellCheck spellCheck) {
        this.mapping.setSpellCheck(spellCheck);
        return this;
    }
}

