/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.support;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.compass.core.Resource;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.lucene.LuceneResource;
import org.compass.core.lucene.engine.LuceneSearchEngine;
import org.compass.core.spi.ResourceKey;

public abstract class ResourceHelper {
    public static Query buildResourceLoadQuery(ResourceKey resourceKey) {
        return new TermQuery(new Term(resourceKey.getUIDPath(), resourceKey.buildUID()));
    }

    public static Resource[] hitsToResourceArray(TermDocs termDocs, IndexReader indexReader, LuceneSearchEngine searchEngine) throws IOException {
        ArrayList<LuceneResource> list = new ArrayList<LuceneResource>();
        while (termDocs.next()) {
            list.add(new LuceneResource(indexReader.document(termDocs.doc()), termDocs.doc(), searchEngine.getSearchEngineFactory()));
        }
        return list.toArray(new Resource[list.size()]);
    }

    public static Resource[] hitsToResourceArray(Hits hits, LuceneSearchEngine searchEngine) throws SearchEngineException {
        int length = hits.length();
        Resource[] result = new Resource[length];
        for (int i = 0; i < length; ++i) {
            try {
                result[i] = new LuceneResource(hits.doc(i), hits.id(i), searchEngine.getSearchEngineFactory());
                continue;
            }
            catch (IOException e) {
                throw new SearchEngineException("Failed to fetch document from hits.", e);
            }
        }
        return result;
    }
}

