/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.transaction.support;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.lucene.store.Lock;
import org.compass.core.Resource;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.lucene.engine.LuceneSearchEngine;
import org.compass.core.lucene.engine.LuceneSearchEngineHits;
import org.compass.core.lucene.engine.LuceneSearchEngineInternalSearch;
import org.compass.core.lucene.engine.LuceneSearchEngineQuery;
import org.compass.core.lucene.engine.transaction.support.AbstractSearchTransactionProcessor;
import org.compass.core.lucene.engine.transaction.support.job.CreateTransactionJob;
import org.compass.core.lucene.engine.transaction.support.job.DeleteByQueryTransactionJob;
import org.compass.core.lucene.engine.transaction.support.job.DeleteTransactionJob;
import org.compass.core.lucene.engine.transaction.support.job.TransactionJob;
import org.compass.core.lucene.engine.transaction.support.job.TransactionJobs;
import org.compass.core.lucene.engine.transaction.support.job.UpdateTransactionJob;
import org.compass.core.spi.InternalResource;
import org.compass.core.spi.ResourceKey;

public abstract class AbstractJobBasedTransactionProcessor
extends AbstractSearchTransactionProcessor {
    private TransactionJobs jobs;
    private final boolean maintainOrder;
    private final Map<String, Lock> orderLocks;

    public AbstractJobBasedTransactionProcessor(Log logger, LuceneSearchEngine searchEngine, boolean defaultMaintainOrderLock) {
        super(logger, searchEngine);
        this.maintainOrder = searchEngine.getSettings().getSettingAsBoolean(this.getSettingName("maintainOrder"), defaultMaintainOrderLock);
        this.orderLocks = this.maintainOrder ? new HashMap<String, Lock>() : null;
    }

    public void begin() throws SearchEngineException {
    }

    public void prepare() throws SearchEngineException {
        if (this.jobs == null) {
            return;
        }
        this.doPrepare(this.jobs);
    }

    protected abstract void doPrepare(TransactionJobs var1) throws SearchEngineException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(boolean onePhase) throws SearchEngineException {
        if (this.jobs == null) {
            return;
        }
        try {
            this.doCommit(onePhase, this.jobs);
        }
        finally {
            this.clearLocksIfNeeded();
        }
    }

    protected abstract void doCommit(boolean var1, TransactionJobs var2) throws SearchEngineException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws SearchEngineException {
        if (this.jobs == null) {
            return;
        }
        try {
            this.doRollback(this.jobs);
        }
        finally {
            this.clearLocksIfNeeded();
        }
    }

    protected abstract void doRollback(TransactionJobs var1) throws SearchEngineException;

    public void create(InternalResource resource) throws SearchEngineException {
        this.obtainOrderLockIfNeeded(resource.getSubIndex());
        this.getTransactionJobs().add(new CreateTransactionJob(resource));
    }

    public void update(InternalResource resource) throws SearchEngineException {
        this.obtainOrderLockIfNeeded(resource.getSubIndex());
        this.getTransactionJobs().add(new UpdateTransactionJob(resource));
    }

    public void delete(ResourceKey resourceKey) throws SearchEngineException {
        this.obtainOrderLockIfNeeded(resourceKey.getSubIndex());
        this.getTransactionJobs().add(new DeleteTransactionJob(resourceKey));
    }

    public void delete(LuceneSearchEngineQuery query) throws SearchEngineException {
        String[] calcSubIndexes;
        this.flush();
        for (String subIndex : calcSubIndexes = this.indexManager.getStore().calcSubIndexes(query.getSubIndexes(), query.getAliases())) {
            this.obtainOrderLockIfNeeded(subIndex);
            this.getTransactionJobs().add(new DeleteByQueryTransactionJob(query.getQuery(), subIndex));
        }
    }

    public void flush() throws SearchEngineException {
    }

    public void flushCommit(String ... aliases) throws SearchEngineException {
        this.flush();
        if (aliases == null || aliases.length == 0) {
            this.doFlushCommit(this.jobs);
            this.jobs = null;
        } else {
            HashSet<String> subIndexes = new HashSet<String>(Arrays.asList(this.indexManager.polyCalcSubIndexes(null, aliases, null)));
            TransactionJobs flushJobs = new TransactionJobs();
            TransactionJobs leftoverJobs = new TransactionJobs();
            for (TransactionJob job : this.jobs.getJobs()) {
                if (subIndexes.contains(job.getSubIndex())) {
                    flushJobs.add(job);
                    continue;
                }
                leftoverJobs.add(job);
            }
            this.doFlushCommit(flushJobs);
            this.jobs = leftoverJobs;
        }
    }

    protected abstract void doFlushCommit(TransactionJobs var1);

    public LuceneSearchEngineHits find(LuceneSearchEngineQuery query) throws SearchEngineException {
        return this.performFind(query);
    }

    public LuceneSearchEngineInternalSearch internalSearch(String[] subIndexes, String[] aliases) throws SearchEngineException {
        return this.performInternalSearch(subIndexes, aliases);
    }

    public Resource[] get(ResourceKey resourceKey) throws SearchEngineException {
        return this.performGet(resourceKey);
    }

    private TransactionJobs getTransactionJobs() {
        if (this.jobs == null) {
            this.jobs = new TransactionJobs();
        }
        return this.jobs;
    }

    private void obtainOrderLockIfNeeded(String subIndex) throws SearchEngineException {
        if (!this.maintainOrder) {
            return;
        }
        Lock lock = this.orderLocks.get(subIndex);
        if (lock == null) {
            lock = this.searchEngine.getSearchEngineFactory().getLuceneIndexManager().getStore().openDirectory(subIndex).makeLock("order.lock");
            try {
                lock.obtain(this.searchEngine.getSearchEngineFactory().getLuceneSettings().getTransactionLockTimout());
            }
            catch (IOException e) {
                this.clearLocksIfNeeded();
                throw new SearchEngineException("Failed to obtain order lock on sub index [" + subIndex + "]", e);
            }
            this.orderLocks.put(subIndex, lock);
        }
    }

    private void clearLocksIfNeeded() {
        if (!this.maintainOrder) {
            return;
        }
        for (Map.Entry<String, Lock> entry : this.orderLocks.entrySet()) {
            try {
                entry.getValue().release();
            }
            catch (IOException e) {
                this.logger.warn((Object)("Failed to release lock for sub index [" + entry.getKey() + "]"), (Throwable)e);
            }
        }
        this.orderLocks.clear();
    }
}

