/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.query;

import java.util.ArrayList;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.queryParser.QueryParser;
import org.compass.core.engine.SearchEngineQuery;
import org.compass.core.engine.SearchEngineQueryBuilder;
import org.compass.core.lucene.engine.LuceneSearchEngineFactory;
import org.compass.core.lucene.engine.LuceneSearchEngineQuery;
import org.compass.core.lucene.engine.queryparser.LuceneQueryParser;
import org.compass.core.lucene.engine.queryparser.QueryHolder;

public class LuceneSearchEngineMultiPropertyQueryStringBuilder
implements SearchEngineQueryBuilder.SearchEngineMultiPropertyQueryStringBuilder {
    private LuceneSearchEngineFactory searchEngineFactory;
    private Analyzer analyzer;
    private boolean forceAnalyzer;
    private String queryString;
    private QueryParser.Operator operator;
    private ArrayList<String> propertyNames = new ArrayList();
    private LuceneQueryParser queryParser;

    public LuceneSearchEngineMultiPropertyQueryStringBuilder(LuceneSearchEngineFactory searchEngineFactory, String queryString) {
        this.searchEngineFactory = searchEngineFactory;
        this.queryString = queryString;
        this.analyzer = searchEngineFactory.getAnalyzerManager().getSearchAnalyzer();
        this.queryParser = searchEngineFactory.getQueryParserManager().getDefaultQueryParser();
    }

    public SearchEngineQueryBuilder.SearchEngineMultiPropertyQueryStringBuilder setAnalyzer(String analyzer) {
        this.analyzer = this.searchEngineFactory.getAnalyzerManager().getAnalyzerMustExist(analyzer);
        return this;
    }

    public SearchEngineQueryBuilder.SearchEngineMultiPropertyQueryStringBuilder setAnalyzerByAlias(String alias) {
        this.analyzer = this.searchEngineFactory.getAnalyzerManager().getAnalyzerByAliasMustExists(alias);
        return this;
    }

    public SearchEngineQueryBuilder.SearchEngineMultiPropertyQueryStringBuilder add(String resourcePropertyName) {
        this.propertyNames.add(resourcePropertyName);
        return this;
    }

    public SearchEngineQueryBuilder.SearchEngineMultiPropertyQueryStringBuilder useAndDefaultOperator() {
        this.operator = QueryParser.Operator.AND;
        return this;
    }

    public SearchEngineQueryBuilder.SearchEngineMultiPropertyQueryStringBuilder useOrDefaultOperator() {
        this.operator = QueryParser.Operator.OR;
        return this;
    }

    public SearchEngineQueryBuilder.SearchEngineMultiPropertyQueryStringBuilder forceAnalyzer() {
        this.forceAnalyzer = true;
        return this;
    }

    public SearchEngineQueryBuilder.SearchEngineMultiPropertyQueryStringBuilder setQueryParser(String queryParser) {
        this.queryParser = this.searchEngineFactory.getQueryParserManager().getQueryParser(queryParser);
        return this;
    }

    public SearchEngineQueryBuilder.SearchEngineMultiPropertyQueryStringBuilder useSpellCheck() {
        return this.setQueryParser("spellcheck");
    }

    public SearchEngineQuery toQuery() {
        QueryHolder qQuery = this.queryParser.parse(this.propertyNames.toArray(new String[this.propertyNames.size()]), this.operator, this.analyzer, this.forceAnalyzer, this.queryString);
        return new LuceneSearchEngineQuery(this.searchEngineFactory, qQuery);
    }
}

