/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.optimizer;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.LuceneSubIndexInfo;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.LockObtainFailedException;
import org.compass.core.CompassException;
import org.compass.core.config.CompassConfigurable;
import org.compass.core.config.CompassSettings;
import org.compass.core.config.SearchEngineFactoryAware;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.engine.SearchEngineFactory;
import org.compass.core.lucene.engine.LuceneSearchEngineFactory;
import org.compass.core.lucene.engine.optimizer.LuceneSearchEngineOptimizer;
import org.compass.core.transaction.context.TransactionContextCallback;

public class DefaultLuceneSearchEngineOptimizer
implements LuceneSearchEngineOptimizer,
CompassConfigurable,
SearchEngineFactoryAware {
    private static final Log logger = LogFactory.getLog(DefaultLuceneSearchEngineOptimizer.class);
    private LuceneSearchEngineFactory searchEngineFactory;
    private int maxNumberOfSegments;
    private CompassSettings settings;

    public void setSearchEngineFactory(SearchEngineFactory searchEngineFactory) {
        this.searchEngineFactory = (LuceneSearchEngineFactory)searchEngineFactory;
    }

    public void configure(CompassSettings settings) throws CompassException {
        this.settings = settings;
        this.maxNumberOfSegments = settings.getSettingAsInt("compass.engine.optimizer.maxNumberOfSegments", 10);
    }

    public boolean canBeScheduled() {
        return true;
    }

    public void optimize() throws SearchEngineException {
        this.optimize(this.maxNumberOfSegments);
    }

    public void optimize(int maxNumberOfSegments) {
        for (String subIndex : this.searchEngineFactory.getLuceneIndexManager().getSubIndexes()) {
            this.optimize(subIndex, maxNumberOfSegments);
        }
    }

    public void optimize(String subIndex) throws SearchEngineException {
        this.optimize(subIndex, this.maxNumberOfSegments);
    }

    public void optimize(final String subIndex, final int maxNumberOfSegments) {
        this.searchEngineFactory.getTransactionContext().execute(new TransactionContextCallback<Object>(){

            @Override
            public Object doInTransaction() throws CompassException {
                DefaultLuceneSearchEngineOptimizer.this.doOptimize(subIndex, maxNumberOfSegments);
                DefaultLuceneSearchEngineOptimizer.this.searchEngineFactory.getLuceneIndexManager().getIndexHoldersCache().refreshCache(subIndex);
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doOptimize(String subIndex, int maxNumberOfSegments) throws SearchEngineException {
        IndexWriter indexWriter;
        LuceneSubIndexInfo indexInfo = this.doGetIndexInfo(subIndex);
        if (indexInfo.size() < maxNumberOfSegments) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Optimizing sub-index [" + subIndex + "] with maxNumberOfSegments [" + maxNumberOfSegments + "] and currentNumberOfSegments[" + indexInfo.size() + "]"));
        }
        long time = System.currentTimeMillis();
        try {
            indexWriter = this.searchEngineFactory.getLuceneIndexManager().getIndexWritersManager().openIndexWriter(this.settings, subIndex);
            this.searchEngineFactory.getLuceneIndexManager().getIndexWritersManager().trackOpenIndexWriter(subIndex, indexWriter);
        }
        catch (LockObtainFailedException e) {
            logger.debug((Object)"Failed to obtain lock in order to optimizer, will try next time...");
            return;
        }
        catch (IOException e) {
            throw new SearchEngineException("Failed to open index writer for optimization for sub index [" + subIndex + "]", e);
        }
        try {
            indexWriter.optimize(maxNumberOfSegments);
        }
        catch (Exception e) {
            try {
                Directory dir = this.searchEngineFactory.getLuceneIndexManager().getDirectory(subIndex);
                if (IndexWriter.isLocked((Directory)dir)) {
                    IndexWriter.unlock((Directory)dir);
                }
            }
            catch (Exception e1) {
                // empty catch block
            }
        }
        finally {
            try {
                indexWriter.close();
            }
            catch (Exception e) {
            }
            finally {
                this.searchEngineFactory.getLuceneIndexManager().getIndexWritersManager().trackCloseIndexWriter(subIndex, indexWriter);
            }
        }
        long optimizeTime = System.currentTimeMillis() - time;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Optimization of sub-index [" + subIndex + "] took [" + optimizeTime + "ms]"));
        }
    }

    protected LuceneSubIndexInfo doGetIndexInfo(String subIndex) throws SearchEngineException {
        try {
            return LuceneSubIndexInfo.getIndexInfo(subIndex, this.searchEngineFactory.getLuceneIndexManager());
        }
        catch (IOException e) {
            throw new SearchEngineException("Failed to read index info for sub index [" + subIndex + "]", e);
        }
    }
}

