/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine;

import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Hits;
import org.compass.core.Resource;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.engine.SearchEngineHighlighter;
import org.compass.core.lucene.engine.LuceneSearchEngine;
import org.compass.core.lucene.engine.LuceneSearchEngineHits;
import org.compass.core.lucene.engine.LuceneSearchEngineInternalSearch;

public class EmptyLuceneSearchEngineHits
implements LuceneSearchEngineHits {
    private final LuceneSearchEngine searchEngine;
    private LuceneSearchEngineInternalSearch internalSearch;

    public EmptyLuceneSearchEngineHits(LuceneSearchEngine searchEngine, LuceneSearchEngineInternalSearch internalSearch) {
        this.searchEngine = searchEngine;
        this.internalSearch = internalSearch;
    }

    public Resource getResource(int n) throws SearchEngineException {
        throw new IndexOutOfBoundsException("No resource for hit [" + n + "], length is [0]");
    }

    public int getLength() {
        return 0;
    }

    public SearchEngineHighlighter getHighlighter() throws SearchEngineException {
        throw new IndexOutOfBoundsException("No highlighter for empty hits");
    }

    public void closeDelegate() throws SearchEngineException {
        this.close(false);
    }

    public void close() throws SearchEngineException {
        this.close(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close(boolean removeDelegate) throws SearchEngineException {
        if (this.internalSearch != null) {
            try {
                this.internalSearch.close();
            }
            finally {
                this.internalSearch = null;
                if (removeDelegate) {
                    this.searchEngine.removeDelegatedClose(this);
                }
            }
        }
    }

    public float score(int i) throws SearchEngineException {
        throw new IndexOutOfBoundsException("No score for hit [" + i + "], length is [0]");
    }

    public Hits getHits() {
        throw new IndexOutOfBoundsException("No Lucenen hits for empty hits");
    }

    public Explanation explain(int i) throws SearchEngineException {
        throw new IndexOutOfBoundsException("No explanation for hit [" + i + "], length is [0]");
    }
}

