/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.json.jackson.converter;

import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.map.BaseMapper;
import org.codehaus.jackson.map.JsonMappingException;
import org.compass.core.converter.ConversionException;
import org.compass.core.converter.json.JsonContentConverter;
import org.compass.core.json.AliasedJsonObject;
import org.compass.core.json.JsonArray;
import org.compass.core.json.JsonObject;
import org.compass.core.json.jackson.JacksonAliasedJsonObject;
import org.compass.core.json.jackson.JacksonJsonArray;
import org.compass.core.json.jackson.JacksonJsonObject;
import org.compass.core.util.StringBuilderWriter;

public class JacksonContentConverter
implements JsonContentConverter {
    private static JsonFactory jsonFactory = new JsonFactory();
    private static ContentMapper mapper = new ContentMapper(jsonFactory);

    public String toJSON(JsonObject jsonObject) throws ConversionException {
        StringBuilderWriter sbWriter = StringBuilderWriter.Cached.cached();
        try {
            JsonGenerator generator = jsonFactory.createJsonGenerator((Writer)sbWriter);
            this.generateJsonObject(jsonObject, generator);
        }
        catch (IOException e) {
            throw new ConversionException("Failed to convert json to string", e);
        }
        return sbWriter.getBuilder().toString();
    }

    public AliasedJsonObject fromJSON(String alias, String json) throws ConversionException {
        try {
            JacksonJsonObject jsonObject = mapper.readTree(json);
            return new JacksonAliasedJsonObject(alias, jsonObject.getNodes());
        }
        catch (Exception e) {
            throw new ConversionException("Failed to convert json: " + json + " with alias [" + alias + "]", e);
        }
    }

    private void generateJsonObject(JsonObject jsonObject, JsonGenerator generator) throws IOException {
        generator.writeStartObject();
        Iterator<String> keyIt = jsonObject.keys();
        while (keyIt.hasNext()) {
            String key = keyIt.next();
            Object value = jsonObject.opt(key);
            if (value == null) {
                generator.writeNullField(key);
                continue;
            }
            if (value instanceof String) {
                generator.writeStringField(key, (String)value);
                continue;
            }
            if (value instanceof Integer) {
                generator.writeNumberField(key, ((Integer)value).intValue());
                continue;
            }
            if (value instanceof Long) {
                generator.writeNumberField(key, ((Long)value).longValue());
                continue;
            }
            if (value instanceof Double) {
                generator.writeNumberField(key, ((Double)value).doubleValue());
                continue;
            }
            if (value instanceof Float) {
                generator.writeNumberField(key, ((Float)value).floatValue());
                continue;
            }
            if (value instanceof BigDecimal) {
                generator.writeNumberField(key, (BigDecimal)value);
                continue;
            }
            if (value instanceof JsonObject) {
                this.generateJsonObject((JsonObject)value, generator);
                continue;
            }
            if (!(value instanceof JsonArray)) continue;
            this.generateJsonArray((JsonArray)value, generator);
        }
        generator.writeEndObject();
    }

    private void generateJsonArray(JsonArray jsonArray, JsonGenerator generator) throws IOException {
        generator.writeStartArray();
        for (int i = 0; i < jsonArray.length(); ++i) {
            Object value;
            if (jsonArray.isNull(i)) {
                generator.writeNull();
            }
            if ((value = jsonArray.opt(i)) == null) {
                generator.writeNull();
                continue;
            }
            if (value instanceof String) {
                generator.writeString((String)value);
                continue;
            }
            if (value instanceof Integer) {
                generator.writeNumber(((Integer)value).intValue());
                continue;
            }
            if (value instanceof Long) {
                generator.writeNumber(((Long)value).longValue());
                continue;
            }
            if (value instanceof Double) {
                generator.writeNumber(((Double)value).doubleValue());
                continue;
            }
            if (value instanceof Float) {
                generator.writeNumber(((Float)value).floatValue());
                continue;
            }
            if (value instanceof BigDecimal) {
                generator.writeNumber((BigDecimal)value);
                continue;
            }
            if (value instanceof JsonObject) {
                this.generateJsonObject((JsonObject)value, generator);
                continue;
            }
            if (!(value instanceof JsonArray)) continue;
            this.generateJsonArray((JsonArray)value, generator);
        }
        generator.writeEndArray();
    }

    public static class ContentMapper
    extends BaseMapper {
        public ContentMapper(JsonFactory jsonFactory) {
            super(jsonFactory);
        }

        public JacksonJsonObject readTree(String jsonContent) throws IOException, JsonParseException {
            return this._readMapAndClose(this._jsonFactory.createJsonParser(jsonContent));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected JacksonJsonObject _readMapAndClose(JsonParser jp) throws IOException, JsonParseException {
            try {
                JacksonJsonObject jacksonJsonObject = this.readTree(jp);
                return jacksonJsonObject;
            }
            finally {
                try {
                    jp.close();
                }
                catch (IOException iOException) {}
            }
        }

        public JacksonJsonObject readTree(JsonParser jp) throws IOException, JsonParseException, JsonMappingException {
            JsonToken curr = jp.getCurrentToken();
            if (curr == null && (curr = jp.nextToken()) == null) {
                return null;
            }
            JacksonJsonObject result = (JacksonJsonObject)this.readAndMap(jp, curr);
            jp.nextToken();
            return result;
        }

        protected Object readAndMap(JsonParser jp, JsonToken currToken) throws IOException, JsonParseException {
            switch (currToken) {
                case START_OBJECT: {
                    HashMap<String, Object> nodes = new HashMap<String, Object>();
                    while ((currToken = jp.nextToken()) != JsonToken.END_OBJECT) {
                        if (currToken != JsonToken.FIELD_NAME) {
                            this._reportProblem(jp, "Unexpected token (" + currToken + "), expected FIELD_NAME");
                        }
                        String fieldName = jp.getText();
                        Object value = this.readAndMap(jp, jp.nextToken());
                        if (this._cfgDupFields == BaseMapper.DupFields.ERROR) {
                            Object old = nodes.put(fieldName, value);
                            if (old == null) continue;
                            this._reportProblem(jp, "Duplicate value for field '" + fieldName + "', when dup fields mode is " + this._cfgDupFields);
                            continue;
                        }
                        if (this._cfgDupFields == BaseMapper.DupFields.USE_LAST) {
                            nodes.put(fieldName, value);
                            continue;
                        }
                        if (nodes.get(fieldName) != null) continue;
                        nodes.put(fieldName, value);
                    }
                    return new JacksonJsonObject(nodes);
                }
                case START_ARRAY: {
                    ArrayList<Object> values = new ArrayList<Object>();
                    while ((currToken = jp.nextToken()) != JsonToken.END_ARRAY) {
                        Object value = this.readAndMap(jp, currToken);
                        values.add(value);
                    }
                    return new JacksonJsonArray(values);
                }
                case VALUE_STRING: {
                    return jp.getText();
                }
                case VALUE_NUMBER_INT: 
                case VALUE_NUMBER_FLOAT: {
                    return jp.getNumberValue();
                }
                case VALUE_TRUE: {
                    return Boolean.TRUE;
                }
                case VALUE_FALSE: {
                    return Boolean.FALSE;
                }
                case VALUE_NULL: {
                    return null;
                }
                case FIELD_NAME: 
                case END_OBJECT: 
                case END_ARRAY: {
                    this._reportProblem(jp, "Can not map token " + currToken + ": stream off by a token or two?");
                }
            }
            this._throwInternal("Unrecognized event type: " + currToken);
            return null;
        }
    }
}

