/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.executor.concurrent;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.compass.core.CompassException;
import org.compass.core.config.CompassConfigurable;
import org.compass.core.config.CompassSettings;
import org.compass.core.executor.spi.InternalExecutorManager;
import org.compass.core.util.concurrent.NamedThreadFactory;
import org.compass.core.util.concurrent.ScalingExecutros;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcurrentExecutorManager
implements InternalExecutorManager,
CompassConfigurable {
    private static final Log log = LogFactory.getLog(ConcurrentExecutorManager.class);
    private ExecutorService executorService;
    private ScheduledExecutorService scheduledExecutorService;

    @Override
    public void configure(CompassSettings settings) throws CompassException {
        int corePoolSize = settings.getSettingAsInt("compass.executorManager.concurrent.corePoolSize", 10);
        int maximumPoolSize = settings.getSettingAsInt("compass.executorManager.concurrent.maximumPoolSize", 50);
        long keepAliveTime = settings.getSettingAsTimeInMillis("compass.executorManager.concurrent.keepAliveTime", 60000L);
        this.executorService = ScalingExecutros.newScalingThreadPool(corePoolSize, maximumPoolSize, keepAliveTime, new NamedThreadFactory("Compass Executor Thread", true));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Using concurrent executor manager with core size [" + corePoolSize + "], max size [" + maximumPoolSize + "], and keep alive time [" + keepAliveTime + "ms]"));
        }
        int scheduledCorePoolSize = settings.getSettingAsInt("compass.executorManager.concurrent.scheduledCorePoolSize", 1);
        this.scheduledExecutorService = Executors.newScheduledThreadPool(scheduledCorePoolSize, new NamedThreadFactory("Compass Scheduled Executor Thread", true));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Using concurrent executor manager scheduler with size [" + scheduledCorePoolSize + "]"));
        }
    }

    @Override
    public void submit(Runnable task) {
        this.executorService.submit(task);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.executorService.submit(task);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<Callable<T>> tasks) throws InterruptedException {
        return this.executorService.invokeAll(tasks);
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        return this.scheduledExecutorService.schedule(callable, delay, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.scheduledExecutorService.scheduleAtFixedRate(command, initialDelay, period, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return this.scheduledExecutorService.scheduleWithFixedDelay(command, initialDelay, delay, unit);
    }

    @Override
    public void close() {
        this.executorService.shutdown();
        this.scheduledExecutorService.shutdown();
    }
}

