/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.executor.commonj;

import commonj.work.WorkException;
import commonj.work.WorkManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.compass.core.executor.commonj.WorkCallableFutureAdapter;

public class WorkSubmitterRunnable
implements Runnable {
    private static final Log logger = LogFactory.getLog(WorkSubmitterRunnable.class);
    private final WorkManager workManager;
    private final Runnable runnable;

    public WorkSubmitterRunnable(WorkManager workManager, Runnable runnable) {
        this.workManager = workManager;
        this.runnable = runnable;
    }

    public void run() {
        WorkCallableFutureAdapter work = new WorkCallableFutureAdapter(this.runnable);
        try {
            this.workManager.schedule(work);
        }
        catch (WorkException e) {
            logger.warn((Object)("Failed to schedule work [" + this.runnable + "] on work manager"), (Throwable)e);
        }
        try {
            work.get();
        }
        catch (Exception e) {
            logger.warn((Object)("Failed to wait for work [" + this.runnable + "] on work manager"), (Throwable)e);
        }
    }
}

