/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.converter.basic.atomic;

import java.text.ParseException;
import java.util.concurrent.atomic.AtomicLong;
import org.compass.core.converter.basic.AbstractNumberConverter;
import org.compass.core.converter.basic.format.Formatter;
import org.compass.core.converter.basic.format.NumberUtils;
import org.compass.core.mapping.ResourcePropertyMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AtomicLongConverter
extends AbstractNumberConverter<AtomicLong> {
    @Override
    protected AtomicLong defaultFromString(String str, ResourcePropertyMapping resourcePropertyMapping) {
        return new AtomicLong(Long.valueOf(str));
    }

    @Override
    protected AtomicLong fromNumber(Number number) {
        return new AtomicLong(number.longValue());
    }

    @Override
    protected Formatter createSortableFormatter() {
        return new Formatter(){

            public String format(Object obj) {
                long val = ((Number)obj).longValue();
                return NumberUtils.long2sortableStr(val);
            }

            public Object parse(String str) throws ParseException {
                return NumberUtils.SortableStr2long(str);
            }

            public boolean isThreadSafe() {
                return true;
            }
        };
    }
}

