/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.config.builder;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.compass.core.config.CompassConfiguration;
import org.compass.core.config.CompassEnvironment;
import org.compass.core.config.ConfigurationException;
import org.compass.core.config.builder.ConfigurationBuilder;
import org.compass.core.util.StringUtils;

public abstract class AbstractInputStreamConfigurationBuilder
implements ConfigurationBuilder {
    protected Log log = LogFactory.getLog(this.getClass());

    public void configure(String resource, CompassConfiguration config) throws ConfigurationException {
        String pathToUse;
        resource = StringUtils.cleanPath(resource);
        InputStream stream = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null && (stream = classLoader.getResourceAsStream(resource)) == null) {
            pathToUse = resource;
            if (pathToUse.startsWith("/")) {
                pathToUse = pathToUse.substring(1);
            }
            stream = classLoader.getResourceAsStream(pathToUse);
        }
        if (stream == null && (stream = CompassEnvironment.class.getResourceAsStream(resource)) == null) {
            pathToUse = resource;
            if (pathToUse.startsWith("/")) {
                pathToUse = pathToUse.substring(1);
            }
            stream = CompassEnvironment.class.getResourceAsStream(pathToUse);
        }
        if (stream == null) {
            throw new ConfigurationException("Resource [" + resource + "] not found in class path");
        }
        this.configure(stream, resource, config);
    }

    public void configure(URL url, CompassConfiguration config) throws ConfigurationException {
        try {
            this.configure(url.openStream(), url.toExternalForm(), config);
        }
        catch (IOException e) {
            throw new ConfigurationException("Failed to open url [" + url.toExternalForm() + "]", e);
        }
    }

    public void configure(File file, CompassConfiguration config) throws ConfigurationException {
        try {
            this.configure(new FileInputStream(file), file.getAbsolutePath(), config);
        }
        catch (FileNotFoundException fnfe) {
            throw new ConfigurationException("Could not find configuration file [" + file.getAbsolutePath() + "]", fnfe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configure(InputStream is, String resourceName, CompassConfiguration config) {
        try {
            this.doConfigure(is, resourceName, config);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                this.log.warn((Object)("Failed to close input stream for [" + resourceName + "]"), (Throwable)e);
            }
        }
    }

    protected abstract void doConfigure(InputStream var1, String var2, CompassConfiguration var3) throws ConfigurationException;
}

