/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store.jdbc.support;

import org.apache.lucene.store.jdbc.JdbcDirectorySettings;
import org.apache.lucene.store.jdbc.dialect.Dialect;
import org.apache.lucene.store.jdbc.support.JdbcColumn;

public class JdbcTable {
    private Dialect dialect;
    private JdbcDirectorySettings settings;
    private String name;
    private String schema;
    private String catalog;
    private boolean quoted;
    private boolean schemaQuoted;
    private String sqlCreate;
    private String sqlDrop;
    private String sqlSelectNames;
    private String sqlSelectNameExists;
    private String sqlSelecltLastModifiedByName;
    private String sqlUpdateLastModifiedByName;
    private String sqlDeleteByName;
    private String sqlMarkDeleteByName;
    private String sqlUpdateNameByName;
    private String sqlSelectSizeByName;
    private String sqlInsert;
    private String sqlUpdateSizeLastModifiedByName;
    private String sqlSelectSizeValueByName;
    private String sqlDeletaAll;
    private String sqlDeletaMarkDeleteByDelta;
    private String sqlSelectNameForUpdateNoWait;
    private JdbcColumn nameColumn;
    private JdbcColumn valueColumn;
    private JdbcColumn sizeColumn;
    private JdbcColumn lastModifiedColumn;
    private JdbcColumn deletedColumn;

    public JdbcTable(JdbcDirectorySettings settings, Dialect dialect, String name) {
        this(settings, dialect, name, null, null);
    }

    public JdbcTable(JdbcDirectorySettings settings, Dialect dialect, String name, String catalog, String schema) {
        this.dialect = dialect;
        this.settings = settings;
        this.setName(name);
        this.setSchema(schema);
        this.setCatalog(catalog);
        this.nameColumn = new JdbcColumn(dialect, settings.getNameColumnName(), 1, dialect.getVarcharType(settings.getNameColumnLength()));
        this.valueColumn = new JdbcColumn(dialect, settings.getValueColumnName(), 2, dialect.getBlobType(settings.getValueColumnLengthInK()));
        this.sizeColumn = new JdbcColumn(dialect, settings.getSizeColumnName(), 3, dialect.getNumberType());
        this.lastModifiedColumn = new JdbcColumn(dialect, settings.getLastModifiedColumnName(), 4, dialect.getTimestampType());
        this.deletedColumn = new JdbcColumn(dialect, settings.getDeletedColumnName(), 5, dialect.getBitType());
        StringBuffer sb = new StringBuffer();
        this.sqlCreate = sb.append("create table ").append(this.getQualifiedName()).append(" (").append(this.nameColumn.getName()).append(' ').append(this.nameColumn.getType()).append(" not null, ").append(this.valueColumn.getName()).append(' ').append(this.valueColumn.getType()).append(" , ").append(this.sizeColumn.getName()).append(' ').append(this.sizeColumn.getType()).append(" , ").append(this.lastModifiedColumn.getName()).append(' ').append(this.lastModifiedColumn.getType()).append(" , ").append(this.deletedColumn.getName()).append(' ').append(this.deletedColumn.getType()).append(", primary key (").append(this.nameColumn.getName()).append(") ) ").append(dialect.getTableTypeString()).toString();
        sb.setLength(0);
        sb.append("drop table ");
        if (dialect.supportsIfExistsBeforeTableName()) {
            sb.append("if exists ");
        }
        sb.append(this.getQualifiedName()).append(dialect.getCascadeConstraintsString());
        if (dialect.supportsIfExistsAfterTableName()) {
            sb.append(" if exists");
        }
        this.sqlDrop = sb.toString();
        sb.setLength(0);
        this.sqlSelectNames = sb.append("select ").append(this.nameColumn.getQuotedName()).append(" from ").append(this.getQualifiedName()).append(" where ").append(this.deletedColumn.getQuotedName()).append(" = ?").toString();
        sb.setLength(0);
        this.sqlSelectNameExists = sb.append("select ").append(this.deletedColumn.getQuotedName()).append(" from ").append(this.getQualifiedName()).append(" where ").append(this.nameColumn.getQuotedName()).append(" = ?").toString();
        sb.setLength(0);
        this.sqlSelecltLastModifiedByName = sb.append("select ").append(this.lastModifiedColumn.getQuotedName()).append(" from ").append(this.getQualifiedName()).append(" where ").append(this.nameColumn.getQuotedName()).append(" = ?").toString();
        sb.setLength(0);
        this.sqlUpdateLastModifiedByName = sb.append("update ").append(this.getQualifiedName()).append(" set ").append(this.lastModifiedColumn.getQuotedName()).append(" = ").append(dialect.getCurrentTimestampFunction()).append(" where ").append(this.nameColumn.getQuotedName()).append(" = ?").toString();
        sb.setLength(0);
        this.sqlDeleteByName = sb.append("delete from ").append(this.getQualifiedName()).append(" where ").append(this.nameColumn.getQuotedName()).append(" = ?").toString();
        sb.setLength(0);
        this.sqlDeletaMarkDeleteByDelta = sb.append("delete from ").append(this.getQualifiedName()).append(" where ").append(this.deletedColumn.getQuotedName()).append(" = ?").append(" and ").append(this.lastModifiedColumn.getQuotedName()).append(" < ?").toString();
        sb.setLength(0);
        this.sqlUpdateNameByName = sb.append("update ").append(this.getQualifiedName()).append(" set ").append(this.nameColumn.getQuotedName()).append(" = ? where ").append(this.nameColumn.getQuotedName()).append(" = ?").toString();
        sb.setLength(0);
        this.sqlSelectNameForUpdateNoWait = sb.append("select ").append(this.nameColumn.getQuotedName()).append(" from ").append(this.getQualifiedName()).append(" where ").append(this.nameColumn.getQuotedName()).append(" = ?").append(dialect.getForUpdateNowaitString()).toString();
        sb.setLength(0);
        this.sqlSelectSizeByName = sb.append("select ").append(this.sizeColumn.getQuotedName()).append(" from ").append(this.getQualifiedName()).append(" where ").append(this.nameColumn.getQuotedName()).append(" = ?").toString();
        sb.setLength(0);
        this.sqlInsert = sb.append("insert into ").append(this.getQualifiedName()).append(" (").append(this.nameColumn.getQuotedName()).append(", ").append(this.valueColumn.getQuotedName()).append(", ").append(this.sizeColumn.getQuotedName()).append(", ").append(this.lastModifiedColumn.getQuotedName()).append(", ").append(this.deletedColumn.getQuotedName()).append(") values ( ?, ?, ?, ").append(dialect.getCurrentTimestampFunction()).append(", ?").append(" )").toString();
        sb.setLength(0);
        this.sqlUpdateSizeLastModifiedByName = sb.append("update ").append(this.getQualifiedName()).append(" set ").append(this.sizeColumn.getQuotedName()).append(" = ? , ").append(this.lastModifiedColumn.getQuotedName()).append(" = ").append(dialect.getCurrentTimestampFunction()).append(" where ").append(this.nameColumn.getQuotedName()).append(" = ?").toString();
        sb.setLength(0);
        this.sqlMarkDeleteByName = sb.append("update ").append(this.getQualifiedName()).append(" set ").append(this.deletedColumn.getQuotedName()).append(" = ? , ").append(this.lastModifiedColumn.getQuotedName()).append(" = ").append(dialect.getCurrentTimestampFunction()).append(" where ").append(this.nameColumn.getQuotedName()).append(" = ?").toString();
        sb.setLength(0);
        this.sqlSelectSizeValueByName = sb.append("select ").append(this.nameColumn.getQuotedName()).append(", ").append(dialect.openBlobSelectQuote()).append(this.valueColumn.getQuotedName()).append(dialect.closeBlobSelectQuote()).append(" as x").append(", ").append(this.sizeColumn.getQuotedName()).append(" from ").append(this.getQualifiedName()).append(" where ").append(this.nameColumn.getQuotedName()).append(" = ?").toString();
        sb.setLength(0);
        this.sqlDeletaAll = sb.append("delete from ").append(this.getQualifiedName()).append(" where ").append(this.nameColumn.getQuotedName()).append(" <> '").append("write.lock").append("'").toString();
    }

    public void setName(String name) {
        if (name.charAt(0) == this.dialect.openQuote()) {
            this.quoted = true;
            this.name = name.substring(1, name.length() - 1).replace('-', '_');
        } else {
            this.name = name.replace('-', '_');
        }
    }

    public String getName() {
        return this.name;
    }

    public void setSchema(String schema) {
        if (schema != null && schema.charAt(0) == this.dialect.openQuote()) {
            this.schemaQuoted = true;
            this.schema = schema.substring(1, schema.length() - 1);
        } else {
            this.schema = schema;
        }
    }

    public String getSchema() {
        return this.schema;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public JdbcColumn getNameColumn() {
        return this.nameColumn;
    }

    public JdbcColumn getSizeColumn() {
        return this.sizeColumn;
    }

    public JdbcColumn getValueColumn() {
        return this.valueColumn;
    }

    public JdbcColumn getLastModifiedColumn() {
        return this.lastModifiedColumn;
    }

    public JdbcColumn getDeletedColumn() {
        return this.deletedColumn;
    }

    public String sqlSelectNames() {
        return this.sqlSelectNames;
    }

    public String sqlSelectNameExists() {
        return this.sqlSelectNameExists;
    }

    public String sqlSelecltLastModifiedByName() {
        return this.sqlSelecltLastModifiedByName;
    }

    public String sqlUpdateLastModifiedByName() {
        return this.sqlUpdateLastModifiedByName;
    }

    public String sqlDeleteByName() {
        return this.sqlDeleteByName;
    }

    public String sqlUpdateNameByName() {
        return this.sqlUpdateNameByName;
    }

    public String sqlSelectSizeByName() {
        return this.sqlSelectSizeByName;
    }

    public String sqlDeletaMarkDeleteByDelta() {
        return this.sqlDeletaMarkDeleteByDelta;
    }

    public String sqlInsert() {
        return this.sqlInsert;
    }

    public String sqlUpdateSizeLastModifiedByName() {
        return this.sqlUpdateSizeLastModifiedByName;
    }

    public String sqlSelectSizeValueByName() {
        return this.sqlSelectSizeValueByName;
    }

    public String sqlSelectNameForUpdateNoWait() {
        return this.sqlSelectNameForUpdateNoWait;
    }

    public String sqlMarkDeleteByName() {
        return this.sqlMarkDeleteByName;
    }

    public String sqlDeletaAll() {
        return this.sqlDeletaAll;
    }

    public String sqlCreate() {
        return this.sqlCreate;
    }

    public String sqlDrop() {
        return this.sqlDrop;
    }

    public String getQualifiedName() {
        String quotedName = this.getQuotedName();
        return JdbcTable.qualify(this.catalog, this.getQuotedSchema(), quotedName);
    }

    public String getQuotedName() {
        return this.quoted ? this.dialect.openQuote() + this.name + this.dialect.closeQuote() : this.name;
    }

    public String getQuotedSchema() {
        if (this.schema == null) {
            return null;
        }
        return this.schemaQuoted ? this.dialect.openQuote() + this.schema + this.dialect.closeQuote() : this.schema;
    }

    public static String qualify(String catalog, String schema, String table) {
        StringBuffer qualifiedName = new StringBuffer();
        if (catalog != null) {
            qualifiedName.append(catalog).append('.');
        }
        if (schema != null) {
            qualifiedName.append(schema).append('.');
        }
        return qualifiedName.append(table).toString();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.getCatalog() != null) {
            buf.append(this.getCatalog()).append(".");
        }
        if (this.getSchema() != null) {
            buf.append(this.getSchema()).append(".");
        }
        buf.append(this.getName());
        return buf.toString();
    }

    public JdbcDirectorySettings getSettings() {
        return this.settings;
    }

    public Dialect getDialect() {
        return this.dialect;
    }
}

