/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.artifact.filter.PatternExcludesArtifactFilter;
import org.apache.maven.shared.artifact.filter.PatternIncludesArtifactFilter;
import org.codehaus.mojo.versions.AbstractVersionsUpdaterMojo;

public abstract class AbstractVersionsDependencyUpdaterMojo
extends AbstractVersionsUpdaterMojo {
    private static final String END_RANGE_CHARS = "])";
    private static final String START_RANGE_CHARS = "[(";
    private String includesList = null;
    private String excludesList = null;
    private String[] includes = null;
    private String[] excludes = null;
    private Boolean processDependencies;
    private Boolean processDependencyManagement;
    private PatternIncludesArtifactFilter includesFilter;
    private PatternExcludesArtifactFilter excludesFilter;
    private Boolean excludeReactor;

    public boolean isProcessingDependencies() {
        return !Boolean.FALSE.equals(this.processDependencies);
    }

    public boolean isProcessingDependencyManagement() {
        return !Boolean.FALSE.equals(this.processDependencyManagement);
    }

    public boolean isExcludeReactor() {
        return !Boolean.FALSE.equals(this.excludeReactor);
    }

    protected Artifact findArtifact(Dependency dependency) {
        if (this.getProject().getDependencyArtifacts() == null) {
            return null;
        }
        Iterator iter = this.getProject().getDependencyArtifacts().iterator();
        while (iter.hasNext()) {
            Artifact artifact = (Artifact)iter.next();
            if (!this.compare(artifact, dependency)) continue;
            return artifact;
        }
        return null;
    }

    protected Artifact toArtifact(Dependency dependency) throws MojoExecutionException {
        Artifact artifact = this.findArtifact(dependency);
        if (artifact == null) {
            try {
                return this.getHelper().createDependencyArtifact(dependency);
            }
            catch (InvalidVersionSpecificationException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
            }
        }
        return artifact;
    }

    protected String toString(Dependency d) {
        StringBuffer buf = new StringBuffer();
        buf.append(d.getGroupId());
        buf.append(':');
        buf.append(d.getArtifactId());
        if (d.getType() != null && d.getType().length() > 0) {
            buf.append(':');
            buf.append(d.getType());
        } else {
            buf.append(":jar");
        }
        if (d.getClassifier() != null && d.getClassifier().length() > 0) {
            buf.append(':');
            buf.append(d.getClassifier());
        }
        if (d.getVersion() != null && d.getVersion().length() > 0) {
            buf.append(":");
            buf.append(d.getVersion());
        }
        return buf.toString();
    }

    protected boolean isProducedByReactor(Dependency dependency) {
        Iterator iter = this.reactorProjects.iterator();
        while (iter.hasNext()) {
            MavenProject project = (MavenProject)iter.next();
            if (!this.compare(project, dependency)) continue;
            return true;
        }
        return false;
    }

    private boolean compare(MavenProject project, Dependency dep) {
        if (!StringUtils.equals((String)project.getGroupId(), (String)dep.getGroupId())) {
            return false;
        }
        return StringUtils.equals((String)project.getArtifactId(), (String)dep.getArtifactId());
    }

    private boolean compare(Artifact artifact, Dependency dep) {
        if (!StringUtils.equals((String)artifact.getGroupId(), (String)dep.getGroupId())) {
            return false;
        }
        if (!StringUtils.equals((String)artifact.getArtifactId(), (String)dep.getArtifactId())) {
            return false;
        }
        if (!StringUtils.equals((String)artifact.getType(), (String)dep.getType())) {
            return false;
        }
        return StringUtils.equals((String)artifact.getClassifier(), (String)dep.getClassifier());
    }

    protected boolean isIncluded(Artifact artifact) {
        ArtifactFilter excludesFilter;
        boolean result = true;
        ArtifactFilter includesFilter = this.getIncludesArtifactFilter();
        if (includesFilter != null) {
            result = includesFilter.include(artifact);
        }
        if ((excludesFilter = this.getExcludesArtifactFilter()) != null) {
            result = result && excludesFilter.include(artifact);
        }
        return result;
    }

    private ArtifactFilter getIncludesArtifactFilter() {
        if (this.includesFilter == null && (this.includes != null || this.includesList != null)) {
            ArrayList<String> patterns = new ArrayList<String>();
            if (this.includesList != null) {
                patterns.addAll(this.separatePatterns(this.includesList));
            } else if (this.includes != null) {
                patterns.addAll(Arrays.asList(this.includes));
            }
            this.includesFilter = new PatternIncludesArtifactFilter(patterns);
        }
        return this.includesFilter;
    }

    private ArtifactFilter getExcludesArtifactFilter() {
        if (this.excludesFilter == null && (this.excludes != null || this.excludesList != null)) {
            ArrayList<String> patterns = new ArrayList<String>();
            if (this.excludesList != null) {
                patterns.addAll(this.separatePatterns(this.excludesList));
            } else if (this.excludes != null) {
                patterns.addAll(Arrays.asList(this.excludes));
            }
            this.excludesFilter = new PatternExcludesArtifactFilter(patterns);
        }
        return this.excludesFilter;
    }

    protected List separatePatterns(String includeString) {
        if (includeString == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> patterns = new ArrayList<String>();
        int indexOf = this.nextCommaIndex(includeString);
        while (indexOf >= 0) {
            patterns.add(includeString.substring(0, indexOf));
            includeString = includeString.substring(indexOf + 1);
            indexOf = this.nextCommaIndex(includeString);
        }
        patterns.add(includeString);
        return patterns;
    }

    private int nextCommaIndex(String includeString) {
        int indexOfComma = includeString.indexOf(44);
        int nextRangeStartDelimiterIndex = this.findFirstChar(includeString, START_RANGE_CHARS);
        if (nextRangeStartDelimiterIndex >= 0 && (indexOfComma < 0 || indexOfComma >= nextRangeStartDelimiterIndex)) {
            int nextStopDelimiterIndex = this.findFirstChar(includeString, END_RANGE_CHARS);
            int tmp = this.nextCommaIndex(includeString.substring(nextStopDelimiterIndex + 1));
            indexOfComma = tmp >= 0 ? nextStopDelimiterIndex + 1 + tmp : -1;
        }
        return indexOfComma;
    }

    private int findFirstChar(String includeString, String chars) {
        int nextRangeStartDelimiterIndex = -1;
        char[] delimiters = chars.toCharArray();
        for (int i = 0; i < delimiters.length; ++i) {
            int index = includeString.indexOf(delimiters[i]);
            if (index >= 0 && nextRangeStartDelimiterIndex >= 0) {
                nextRangeStartDelimiterIndex = Math.min(index, nextRangeStartDelimiterIndex);
                continue;
            }
            if (index < 0) continue;
            nextRangeStartDelimiterIndex = index;
        }
        return nextRangeStartDelimiterIndex;
    }
}

