/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.js.pattern;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.ws.jaxme.js.JavaConstructor;
import org.apache.ws.jaxme.js.JavaField;
import org.apache.ws.jaxme.js.JavaMethod;
import org.apache.ws.jaxme.js.JavaQName;
import org.apache.ws.jaxme.js.JavaQNameImpl;
import org.apache.ws.jaxme.js.JavaSource;
import org.apache.ws.jaxme.js.JavaSourceFactory;
import org.apache.ws.jaxme.js.Parameter;
import org.apache.ws.jaxme.js.pattern.CompiledClassReflector;
import org.apache.ws.jaxme.js.pattern.InterfaceDescription;
import org.apache.ws.jaxme.js.pattern.ProxyGenerator;
import org.apache.ws.jaxme.js.pattern.SourceReflector;

public class ChainGenerator {
    private String controllerInterfaceName;
    private JavaSource controllerInterface;
    private JavaQName chainInterface;
    private JavaQName proxyClass;
    private JavaQName implClass;
    static /* synthetic */ Class class$java$lang$NullPointerException;

    public void setControllerInterfaceName(String pInterfaceName) throws ClassNotFoundException {
        this.controllerInterfaceName = pInterfaceName;
    }

    public JavaSource getControllerInterface() {
        return this.controllerInterface;
    }

    private JavaSource loadSource(ClassLoader pClassLoader, String pName, JavaSourceFactory pFactory) throws RecognitionException, TokenStreamException, IOException {
        URL url = pClassLoader.getResource(pName.replace('.', '/') + ".java");
        if (url == null) {
            return null;
        }
        return new SourceReflector(url).getJavaSource(pFactory);
    }

    private void loadSources(ClassLoader pClassLoader, JavaQName pQName, JavaSourceFactory pFactory, List pSources, Set pNames) throws RecognitionException, TokenStreamException, IOException {
        if (pNames.contains(pQName)) {
            return;
        }
        pNames.add(pQName);
        JavaSource js = this.loadSource(Thread.currentThread().getContextClassLoader(), pQName.toString(), pFactory);
        if (js == null) {
            return;
        }
        pSources.add(js);
        JavaQName[] superInterfaces = js.getExtends();
        for (int i = 0; i < superInterfaces.length; ++i) {
            this.loadSources(pClassLoader, superInterfaces[i], pFactory, pSources, pNames);
        }
    }

    private JavaSource[] loadSources(ClassLoader pClassLoader, String pName) throws RecognitionException, TokenStreamException, IOException {
        JavaSourceFactory jsf = new JavaSourceFactory();
        ArrayList sources = new ArrayList();
        HashSet names = new HashSet();
        this.loadSources(pClassLoader, JavaQNameImpl.getInstance(pName), jsf, sources, names);
        if (sources.isEmpty()) {
            return null;
        }
        return sources.toArray(new JavaSource[sources.size()]);
    }

    protected JavaSource[] initControllerInterface() throws ClassNotFoundException, RecognitionException, TokenStreamException, IOException {
        JavaSource[] result;
        block4: {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            try {
                if (cl == null) {
                    throw new ClassNotFoundException(this.controllerInterfaceName);
                }
                CompiledClassReflector r = new CompiledClassReflector(this.controllerInterfaceName, cl);
                result = new JavaSource[]{r.getJavaSource(new JavaSourceFactory())};
            }
            catch (ClassNotFoundException e) {
                result = this.loadSources(Thread.currentThread().getContextClassLoader(), this.controllerInterfaceName);
                if (result != null) break block4;
                throw e;
            }
        }
        if (!result[0].isInterface()) {
            throw new ClassCastException("The controller must be an interface");
        }
        return result;
    }

    public void setChainInterfaceName(String pInterfaceName) {
        JavaQName qName = JavaQNameImpl.getInstance(pInterfaceName);
        this.setChainInterface(qName);
    }

    public void setChainInterface(JavaQName pInterface) {
        this.chainInterface = pInterface;
    }

    public JavaQName getChainInterface() {
        return this.chainInterface;
    }

    public void setProxyClassName(String pClassName) {
        JavaQName qName = JavaQNameImpl.getInstance(pClassName);
        this.setProxyClass(qName);
    }

    public void setProxyClass(JavaQName pClassName) {
        this.proxyClass = pClassName;
    }

    public JavaQName getProxyClass() {
        if (this.proxyClass == null) {
            JavaQName chainClass = this.getChainInterface();
            if (chainClass == null) {
                return null;
            }
            return JavaQNameImpl.getInstance(chainClass.getPackageName(), chainClass.getClassName() + "Impl");
        }
        return this.proxyClass;
    }

    public void setImplementationClassName(String pClassName) {
        this.setImplementationClass(JavaQNameImpl.getInstance(pClassName));
    }

    public void setImplementationClass(JavaQName pClassName) {
        this.implClass = pClassName;
    }

    public JavaQName getImplementationClass() {
        if (this.implClass == null) {
            if (this.controllerInterface == null) {
                return null;
            }
            JavaQName controllerClass = this.controllerInterface.getQName();
            return JavaQNameImpl.getInstance(controllerClass.getPackageName(), controllerClass.getClassName() + "Impl");
        }
        return this.implClass;
    }

    public void finish() {
        if (this.controllerInterface == null) {
            throw new NullPointerException("A controller interface must be given.");
        }
        if (this.chainInterface == null) {
            throw new NullPointerException("A chain interface must be given.");
        }
    }

    public JavaSource[] generate(JavaSourceFactory pFactory) throws Exception {
        JavaSource[] sources = this.initControllerInterface();
        this.controllerInterface = sources[0];
        InterfaceDescription[] interfaces = new InterfaceDescription[sources.length];
        for (int i = 0; i < interfaces.length; ++i) {
            InterfaceDescription controllerDescription = new InterfaceDescription();
            controllerDescription.setInterface(sources[i].getQName().toString());
            controllerDescription.setMandatory(true);
            interfaces[i] = controllerDescription;
        }
        ProxyInterfaceGenerator proxyInterfaceGenerator = new ProxyInterfaceGenerator();
        JavaSource proxyInterface = ((ProxyGenerator)proxyInterfaceGenerator).generate(pFactory, this.getChainInterface(), interfaces);
        proxyInterface.setType(JavaSource.INTERFACE);
        ProxyImplementationGenerator proxyImpGenerator = new ProxyImplementationGenerator();
        JavaSource proxyImplementation = ((ProxyGenerator)proxyImpGenerator).generate(pFactory, this.getProxyClass(), interfaces);
        ControllerImplementationGenerator controllerImplementationGenerator = new ControllerImplementationGenerator();
        JavaSource controllerImplementation = ((ProxyGenerator)controllerImplementationGenerator).generate(pFactory, this.getImplementationClass(), interfaces);
        return new JavaSource[]{controllerImplementation, proxyInterface, proxyImplementation};
    }

    public static void main(String[] args) throws Exception {
        ChainGenerator cg = new ChainGenerator();
        cg.setChainInterfaceName("org.apache.ws.jaxme.generator.sg.ComplexTypeSGChain");
        cg.setControllerInterfaceName("org.apache.ws.jaxme.generator.sg.ComplexTypeSG");
        cg.setImplementationClassName("org.apache.ws.jaxme.generator.sg.ComplexTypeSGImpl");
        cg.setProxyClassName("org.apache.ws.jaxme.generator.sg.ComplexTypeSGChainImpl");
        JavaSourceFactory f = new JavaSourceFactory();
        cg.generate(f);
        f.write(new File("/tmp/qName"));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ControllerImplementationGenerator
    extends ProxyGenerator {
        private ControllerImplementationGenerator() {
        }

        protected JavaField getBackingObjectField(JavaSource pJs, InterfaceDescription[] pInterfaces) {
            return pJs.newJavaField("backingObject", ChainGenerator.this.getChainInterface(), JavaSource.PRIVATE);
        }

        protected JavaConstructor getConstructor(JavaSource pJs, InterfaceDescription[] pInterfaces) {
            JavaConstructor jcon = pJs.newJavaConstructor(JavaSource.PUBLIC);
            jcon.addParam(ChainGenerator.this.getChainInterface(), "o");
            jcon.addIf("o == null");
            jcon.addThrowNew(class$java$lang$NullPointerException == null ? (class$java$lang$NullPointerException = ChainGenerator.class$("java.lang.NullPointerException")) : class$java$lang$NullPointerException, (Object)JavaSource.getQuoted("The supplied object must not be null."));
            jcon.addEndIf();
            jcon.addLine("backingObject = o;");
            return jcon;
        }

        public JavaMethod getInterfaceMethod(JavaSource pSource, JavaMethod pMethod) {
            JavaMethod jm = pSource.newJavaMethod(pMethod);
            Parameter[] parameters = jm.getParams();
            ArrayList<String> callParameters = new ArrayList<String>();
            callParameters.add("this");
            for (int i = 0; i < parameters.length; ++i) {
                Parameter parameter = parameters[i];
                callParameters.add(", ");
                callParameters.add(parameter.getName());
            }
            jm.addLine(JavaQNameImpl.VOID.equals(pMethod.getType()) ? "" : "return ", "backingObject.", pMethod.getName(), "(", callParameters, ");");
            return jm;
        }

        protected JavaMethod getGetHeadOfChainMethod(JavaSource pSource) {
            JavaMethod jm = pSource.newJavaMethod("getHeadOfChain", ChainGenerator.this.getChainInterface(), JavaSource.PUBLIC);
            jm.addLine("return backingObject;");
            return jm;
        }

        public JavaSource generate(JavaSourceFactory pImplementationFactory, JavaQName pTargetClass, InterfaceDescription[] pDescription) throws Exception {
            JavaSource result = super.generate(pImplementationFactory, pTargetClass, pDescription);
            this.getGetHeadOfChainMethod(result);
            return result;
        }
    }

    private class ProxyImplementationGenerator
    extends ProxyGenerator {
        private ProxyImplementationGenerator() {
        }

        protected JavaField getBackingObjectField(JavaSource pJs, InterfaceDescription[] pInterfaces) {
            return pJs.newJavaField("backingObject", ChainGenerator.this.getChainInterface(), JavaSource.PRIVATE);
        }

        protected JavaConstructor getConstructor(JavaSource pJs, InterfaceDescription[] pInterfaces) {
            JavaConstructor jcon = pJs.newJavaConstructor(JavaSource.PROTECTED);
            jcon.addParam(ChainGenerator.this.getChainInterface(), "o");
            jcon.addIf("o == null");
            jcon.addThrowNew(class$java$lang$NullPointerException == null ? (class$java$lang$NullPointerException = ChainGenerator.class$("java.lang.NullPointerException")) : class$java$lang$NullPointerException, (Object)JavaSource.getQuoted("The supplied object must not be null."));
            jcon.addEndIf();
            jcon.addLine("backingObject = o;");
            return jcon;
        }

        public JavaMethod getInterfaceMethod(JavaSource pSource, JavaMethod pMethod) {
            JavaMethod jm = pSource.newJavaMethod(pMethod);
            Parameter[] parameters = jm.getParams();
            JavaQName controllerInterfaceQName = ChainGenerator.this.getControllerInterface().getQName();
            jm.clearParams();
            jm.addParam(controllerInterfaceQName, "pController");
            for (int i = 0; i < parameters.length; ++i) {
                jm.addParam(parameters[i]);
            }
            ArrayList<String> callParameters = new ArrayList<String>();
            callParameters.add("pController");
            for (int i = 0; i < parameters.length; ++i) {
                Parameter parameter = parameters[i];
                callParameters.add(", ");
                callParameters.add(parameter.getName());
            }
            jm.addLine(JavaQNameImpl.VOID.equals(pMethod.getType()) ? "" : "return ", "backingObject.", pMethod.getName(), "(", callParameters, ");");
            return jm;
        }

        public JavaSource generate(JavaSourceFactory pImplementationFactory, JavaQName pTargetClass, InterfaceDescription[] pDescription) throws Exception {
            JavaSource result = super.generate(pImplementationFactory, pTargetClass, pDescription);
            result.clearImplements();
            result.addImplements(ChainGenerator.this.getChainInterface());
            return result;
        }
    }

    private class ProxyInterfaceGenerator
    extends ProxyGenerator {
        private ProxyInterfaceGenerator() {
        }

        public JavaMethod getInterfaceMethod(JavaSource pSource, JavaMethod pMethod) {
            JavaMethod jm = pSource.newJavaMethod(pMethod);
            Parameter[] parameters = jm.getParams();
            JavaQName controllerInterfaceQName = ChainGenerator.this.getControllerInterface().getQName();
            jm.clearParams();
            jm.addParam(controllerInterfaceQName, "pController");
            for (int i = 0; i < parameters.length; ++i) {
                jm.addParam(parameters[i]);
            }
            return jm;
        }

        public JavaSource generate(JavaSourceFactory pInterfaceFactory, JavaQName pTargetClass, InterfaceDescription[] pDescription) throws Exception {
            JavaSource result = super.generate(pInterfaceFactory, pTargetClass, pDescription);
            result.clearImplements();
            return result;
        }
    }
}

