/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.dstream;

import org.apache.spark.rdd.BlockRDD;
import org.apache.spark.rdd.RDD;
import org.apache.spark.storage.BlockId;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.dstream.InputDStream;
import org.apache.spark.streaming.rdd.WriteAheadLogBackedBlockRDD;
import org.apache.spark.streaming.rdd.WriteAheadLogBackedBlockRDD$;
import org.apache.spark.streaming.receiver.Receiver;
import org.apache.spark.streaming.scheduler.RateController;
import org.apache.spark.streaming.scheduler.RateController$;
import org.apache.spark.streaming.scheduler.ReceivedBlockInfo;
import org.apache.spark.streaming.scheduler.ReceiverTracker;
import org.apache.spark.streaming.scheduler.StreamInputInfo;
import org.apache.spark.streaming.scheduler.StreamInputInfo$;
import org.apache.spark.streaming.scheduler.rate.RateEstimator;
import org.apache.spark.streaming.scheduler.rate.RateEstimator$;
import org.apache.spark.streaming.util.WriteAheadLogRecordHandle;
import org.apache.spark.streaming.util.WriteAheadLogUtils$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.math.Numeric;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\u0005Mb!B\u0001\u0003\u0003\u0003i!\u0001\u0006*fG\u0016Lg/\u001a:J]B,H\u000fR*ue\u0016\fWN\u0003\u0002\u0004\t\u00059Am\u001d;sK\u0006l'BA\u0003\u0007\u0003%\u0019HO]3b[&twM\u0003\u0002\b\u0011\u0005)1\u000f]1sW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h\u0007\u0001)\"AD\u000b\u0014\u0005\u0001y\u0001c\u0001\t\u0012'5\t!!\u0003\u0002\u0013\u0005\ta\u0011J\u001c9vi\u0012\u001bFO]3b[B\u0011A#\u0006\u0007\u0001\t\u00151\u0002A1\u0001\u0018\u0005\u0005!\u0016C\u0001\r\u001f!\tIB$D\u0001\u001b\u0015\u0005Y\u0012!B:dC2\f\u0017BA\u000f\u001b\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"!G\u0010\n\u0005\u0001R\"aA!os\"A!\u0005\u0001B\u0001B\u0003%1%\u0001\u0003tg\u000e|\u0006C\u0001\u0013&\u001b\u0005!\u0011B\u0001\u0014\u0005\u0005A\u0019FO]3b[&twmQ8oi\u0016DH\u000f\u0003\u0005)\u0001\t\r\t\u0015a\u0003*\u0003))g/\u001b3f]\u000e,G%\r\t\u0004U5\u001aR\"A\u0016\u000b\u00051R\u0012a\u0002:fM2,7\r^\u0005\u0003]-\u0012\u0001b\u00117bgN$\u0016m\u001a\u0005\u0006a\u0001!\t!M\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005I*DCA\u001a5!\r\u0001\u0002a\u0005\u0005\u0006Q=\u0002\u001d!\u000b\u0005\u0006E=\u0002\ra\t\u0005\to\u0001\u0011\r\u0011\"\u0015\u0005q\u0005q!/\u0019;f\u0007>tGO]8mY\u0016\u0014X#A\u001d\u0011\u0007eQD(\u0003\u0002<5\t1q\n\u001d;j_:\u0004\"!\u0010!\u000e\u0003yR!a\u0010\u0003\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014\u0018BA!?\u00059\u0011\u0016\r^3D_:$(o\u001c7mKJDaa\u0011\u0001!\u0002\u0013I\u0014a\u0004:bi\u0016\u001cuN\u001c;s_2dWM\u001d\u0011\t\u000b\u0015\u0003a\u0011\u0001$\u0002\u0017\u001d,GOU3dK&4XM\u001d\u000b\u0002\u000fB\u0019\u0001jS\n\u000e\u0003%S!A\u0013\u0003\u0002\u0011I,7-Z5wKJL!\u0001T%\u0003\u0011I+7-Z5wKJDQA\u0014\u0001\u0005\u0002=\u000bQa\u001d;beR$\u0012\u0001\u0015\t\u00033EK!A\u0015\u000e\u0003\tUs\u0017\u000e\u001e\u0005\u0006)\u0002!\taT\u0001\u0005gR|\u0007\u000fC\u0003W\u0001\u0011\u0005s+A\u0004d_6\u0004X\u000f^3\u0015\u0005a{\u0006cA\r;3B\u0019!,X\n\u000e\u0003mS!\u0001\u0018\u0004\u0002\u0007I$G-\u0003\u0002_7\n\u0019!\u000b\u0012#\t\u000b\u0001,\u0006\u0019A1\u0002\u0013Y\fG.\u001b3US6,\u0007C\u0001\u0013c\u0013\t\u0019GA\u0001\u0003US6,\u0007BB3\u0001\t\u0003!a-\u0001\bde\u0016\fG/\u001a\"m_\u000e\\'\u000b\u0012#\u0015\u0007e;\u0017\u000eC\u0003iI\u0002\u0007\u0011-\u0001\u0003uS6,\u0007\"\u00026e\u0001\u0004Y\u0017A\u00032m_\u000e\\\u0017J\u001c4pgB\u0019A\u000e^<\u000f\u00055\u0014hB\u00018r\u001b\u0005y'B\u00019\r\u0003\u0019a$o\\8u}%\t1$\u0003\u0002t5\u00059\u0001/Y2lC\u001e,\u0017BA;w\u0005\r\u0019V-\u001d\u0006\u0003gj\u0001\"!\u0010=\n\u0005et$!\u0005*fG\u0016Lg/\u001a3CY>\u001c7.\u00138g_\u001a)1\u0010\u0001\u0001\u0005y\n1\"+Z2fSZ,'OU1uK\u000e{g\u000e\u001e:pY2,'o\u0005\u0002{y!QaP\u001fB\u0001B\u0003%q0!\u0002\u0002\u0005%$\u0007cA\r\u0002\u0002%\u0019\u00111\u0001\u000e\u0003\u0007%sG/C\u0002\u0002\b\u0001\u000b\u0011b\u001d;sK\u0006lW+\u0013#\t\u0015\u0005-!P!A!\u0002\u0013\ti!A\u0005fgRLW.\u0019;peB!\u0011qBA\u000b\u001b\t\t\tBC\u0002\u0002\u0014y\nAA]1uK&!\u0011qCA\t\u00055\u0011\u0016\r^3FgRLW.\u0019;pe\"1\u0001G\u001fC\u0001\u00037!b!!\b\u0002\"\u0005\r\u0002cAA\u0010u6\t\u0001\u0001\u0003\u0004\u007f\u00033\u0001\ra \u0005\t\u0003\u0017\tI\u00021\u0001\u0002\u000e!9\u0011q\u0005>\u0005B\u0005%\u0012a\u00029vE2L7\u000f\u001b\u000b\u0004!\u0006-\u0002\u0002CA\n\u0003K\u0001\r!!\f\u0011\u0007e\ty#C\u0002\u00022i\u0011A\u0001T8oO\u0002")
public abstract class ReceiverInputDStream<T>
extends InputDStream<T> {
    private final ClassTag<T> evidence$1;
    private final Option<RateController> rateController;

    @Override
    public Option<RateController> rateController() {
        return this.rateController;
    }

    public abstract Receiver<T> getReceiver();

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public Option<RDD<T>> compute(Time validTime) {
        RDD<T> rDD;
        if (validTime.$less(this.graph().startTime())) {
            rDD = new RDD<T>(this.ssc().sc(), (BlockId[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(BlockId.class)), this.evidence$1);
        } else {
            ReceiverTracker receiverTracker = this.ssc().scheduler().receiverTracker();
            Seq blockInfos = (Seq)receiverTracker.getBlocksOfBatch(validTime).getOrElse((Object)BoxesRunTime.boxToInteger((int)this.id()), (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Seq<Nothing$> apply() {
                    return (Seq)Seq$.MODULE$.empty();
                }
            });
            StreamInputInfo inputInfo = new StreamInputInfo(this.id(), BoxesRunTime.unboxToLong((Object)((TraversableOnce)blockInfos.flatMap((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Iterable<Object> apply(ReceivedBlockInfo x$1) {
                    return Option$.MODULE$.option2Iterable(x$1.numRecords());
                }
            }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)), StreamInputInfo$.MODULE$.apply$default$3());
            this.ssc().scheduler().inputInfoTracker().reportInfo(validTime, inputInfo);
            rDD = this.createBlockRDD(validTime, (Seq<ReceivedBlockInfo>)blockInfos);
        }
        RDD<T> blockRDD = rDD;
        return new Some((Object)blockRDD);
    }

    public RDD<T> createBlockRDD(Time time, Seq<ReceivedBlockInfo> blockInfos) {
        WriteAheadLogBackedBlockRDD<T> writeAheadLogBackedBlockRDD;
        if (blockInfos.nonEmpty()) {
            BlockId[] blockIds = (BlockId[])((TraversableOnce)blockInfos.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final BlockId apply(ReceivedBlockInfo x$2) {
                    return x$2.blockId();
                }
            }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(BlockId.class));
            boolean areWALRecordHandlesPresent = blockInfos.forall((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(ReceivedBlockInfo x$3) {
                    return x$3.walRecordHandleOption().nonEmpty();
                }
            });
            if (areWALRecordHandlesPresent) {
                boolean[] isBlockIdValid = (boolean[])((TraversableOnce)blockInfos.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(ReceivedBlockInfo x$4) {
                        return x$4.isBlockIdValid();
                    }
                }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Boolean());
                WriteAheadLogRecordHandle[] walRecordHandles = (WriteAheadLogRecordHandle[])((TraversableOnce)blockInfos.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final WriteAheadLogRecordHandle apply(ReceivedBlockInfo x$5) {
                        return (WriteAheadLogRecordHandle)x$5.walRecordHandleOption().get();
                    }
                }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(WriteAheadLogRecordHandle.class));
                writeAheadLogBackedBlockRDD = new WriteAheadLogBackedBlockRDD<T>(this.ssc().sparkContext(), blockIds, walRecordHandles, isBlockIdValid, WriteAheadLogBackedBlockRDD$.MODULE$.$lessinit$greater$default$5(), WriteAheadLogBackedBlockRDD$.MODULE$.$lessinit$greater$default$6(), this.evidence$1);
            } else {
                BlockId[] validBlockIds;
                if (blockInfos.find((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(ReceivedBlockInfo x$6) {
                        return x$6.walRecordHandleOption().nonEmpty();
                    }
                }).nonEmpty()) {
                    if (WriteAheadLogUtils$.MODULE$.enableReceiverLog(this.ssc().conf())) {
                        this.logError((Function0<String>)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "Some blocks do not have Write Ahead Log information; this is unexpected and data may not be recoverable after driver failures";
                            }
                        });
                    } else {
                        this.logWarning((Function0<String>)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "Some blocks have Write Ahead Log information; this is unexpected";
                            }
                        });
                    }
                }
                if (Predef$.MODULE$.refArrayOps((Object[])(validBlockIds = (BlockId[])Predef$.MODULE$.refArrayOps((Object[])blockIds).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ReceiverInputDStream $outer;

                    public final boolean apply(BlockId id) {
                        return this.$outer.ssc().sparkContext().env().blockManager().master().contains(id);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }))).size() != Predef$.MODULE$.refArrayOps((Object[])blockIds).size()) {
                    this.logWarning((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Some blocks could not be recovered as they were not found in memory. To prevent such data loss, enabled Write Ahead Log (see programming guide for more details.";
                        }
                    });
                }
                writeAheadLogBackedBlockRDD = new BlockRDD(this.ssc().sc(), validBlockIds, this.evidence$1);
            }
        } else {
            writeAheadLogBackedBlockRDD = WriteAheadLogUtils$.MODULE$.enableReceiverLog(this.ssc().conf()) ? new WriteAheadLogBackedBlockRDD<T>(this.ssc().sparkContext(), (BlockId[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(BlockId.class)), (WriteAheadLogRecordHandle[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(WriteAheadLogRecordHandle.class)), (boolean[])Array$.MODULE$.empty(ClassTag$.MODULE$.Boolean()), WriteAheadLogBackedBlockRDD$.MODULE$.$lessinit$greater$default$5(), WriteAheadLogBackedBlockRDD$.MODULE$.$lessinit$greater$default$6(), this.evidence$1) : new BlockRDD(this.ssc().sc(), (BlockId[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(BlockId.class)), this.evidence$1);
        }
        return writeAheadLogBackedBlockRDD;
    }

    public ReceiverInputDStream(StreamingContext ssc_, ClassTag<T> evidence$1) {
        this.evidence$1 = evidence$1;
        super(ssc_, evidence$1);
        this.rateController = RateController$.MODULE$.isBackPressureEnabled(this.ssc().conf()) ? new Some((Object)new ReceiverRateController(this.id(), RateEstimator$.MODULE$.create(this.ssc().conf(), this.ssc().graph().batchDuration()))) : None$.MODULE$;
    }

    public class ReceiverRateController
    extends RateController {
        @Override
        public void publish(long rate) {
            this.org$apache$spark$streaming$dstream$ReceiverInputDStream$ReceiverRateController$$$outer().ssc().scheduler().receiverTracker().sendRateUpdate(super.streamUID(), rate);
        }

        public /* synthetic */ ReceiverInputDStream org$apache$spark$streaming$dstream$ReceiverInputDStream$ReceiverRateController$$$outer() {
            return ReceiverInputDStream.this;
        }

        public ReceiverRateController(int id, RateEstimator estimator) {
            if (ReceiverInputDStream.this == null) {
                throw null;
            }
            super(id, estimator);
        }
    }
}

