/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.bkdtree;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.apache.lucene.bkdtree.BKDTreeWriter;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.DocIdSetBuilder;

final class BKDTreeReader
implements Accountable {
    private final int[] splitValues;
    private final int leafNodeOffset;
    private final long[] leafBlockFPs;
    final int maxDoc;
    final IndexInput in;

    public BKDTreeReader(IndexInput in, int maxDoc) throws IOException {
        int i;
        int numLeaves;
        this.leafNodeOffset = numLeaves = in.readVInt();
        this.splitValues = new int[numLeaves];
        for (i = 0; i < numLeaves; ++i) {
            this.splitValues[i] = in.readInt();
        }
        this.leafBlockFPs = new long[numLeaves];
        for (i = 0; i < numLeaves; ++i) {
            this.leafBlockFPs[i] = in.readVLong();
        }
        this.maxDoc = maxDoc;
        this.in = in;
    }

    public DocIdSet intersect(double latMin, double latMax, double lonMin, double lonMax, SortedNumericDocValues sndv) throws IOException {
        return this.intersect(latMin, latMax, lonMin, lonMax, null, sndv);
    }

    public DocIdSet intersect(double latMin, double latMax, double lonMin, double lonMax, LatLonFilter filter, SortedNumericDocValues sndv) throws IOException {
        if (!BKDTreeWriter.validLat(latMin)) {
            throw new IllegalArgumentException("invalid latMin: " + latMin);
        }
        if (!BKDTreeWriter.validLat(latMax)) {
            throw new IllegalArgumentException("invalid latMax: " + latMax);
        }
        if (!BKDTreeWriter.validLon(lonMin)) {
            throw new IllegalArgumentException("invalid lonMin: " + lonMin);
        }
        if (!BKDTreeWriter.validLon(lonMax)) {
            throw new IllegalArgumentException("invalid lonMax: " + lonMax);
        }
        int latMinEnc = BKDTreeWriter.encodeLat(latMin);
        int latMaxEnc = BKDTreeWriter.encodeLat(latMax);
        int lonMinEnc = BKDTreeWriter.encodeLon(lonMin);
        int lonMaxEnc = BKDTreeWriter.encodeLon(lonMax);
        QueryState state = new QueryState(this.in.clone(), this.maxDoc, latMinEnc, latMaxEnc, lonMinEnc, lonMaxEnc, filter, sndv);
        int hitCount = this.intersect(state, 1, BKDTreeWriter.encodeLat(-90.0), BKDTreeWriter.encodeLat(Math.nextAfter(90.0, Double.POSITIVE_INFINITY)), BKDTreeWriter.encodeLon(-180.0), BKDTreeWriter.encodeLon(Math.nextAfter(180.0, Double.POSITIVE_INFINITY)));
        return state.docs.build((long)hitCount);
    }

    private int addAll(QueryState state, int nodeID) throws IOException {
        if (nodeID >= this.leafNodeOffset) {
            long fp = this.leafBlockFPs[nodeID - this.leafNodeOffset];
            if (fp == 0L) {
                return 0;
            }
            state.in.seek(fp);
            int count = state.in.readVInt();
            state.docs.grow(count);
            for (int i = 0; i < count; ++i) {
                int docID = state.in.readInt();
                state.docs.add(docID);
            }
            return count;
        }
        int splitValue = this.splitValues[nodeID];
        if (splitValue == Integer.MAX_VALUE) {
            return 0;
        }
        int count = this.addAll(state, 2 * nodeID);
        return count += this.addAll(state, 2 * nodeID + 1);
    }

    private int intersect(QueryState state, int nodeID, int cellLatMinEnc, int cellLatMaxEnc, int cellLonMinEnc, int cellLonMaxEnc) throws IOException {
        long lonRange;
        long latRange;
        if (state.latLonFilter != null) {
            if (cellLatMinEnc > state.latMinEnc || cellLatMaxEnc < state.latMaxEnc || cellLonMinEnc > state.lonMinEnc || cellLonMaxEnc < state.lonMaxEnc) {
                Relation r = state.latLonFilter.compare(BKDTreeWriter.decodeLat(cellLatMinEnc), BKDTreeWriter.decodeLat(cellLatMaxEnc), BKDTreeWriter.decodeLon(cellLonMinEnc), BKDTreeWriter.decodeLon(cellLonMaxEnc));
                if (r == Relation.OUTSIDE) {
                    return 0;
                }
                if (r == Relation.INSIDE) {
                    return this.addAll(state, nodeID);
                }
            }
        } else if (state.latMinEnc <= cellLatMinEnc && state.latMaxEnc >= cellLatMaxEnc && state.lonMinEnc <= cellLonMinEnc && state.lonMaxEnc >= cellLonMaxEnc) {
            return this.addAll(state, nodeID);
        }
        boolean dim = (latRange = (long)cellLatMaxEnc - (long)cellLatMinEnc) < (lonRange = (long)cellLonMaxEnc - (long)cellLonMinEnc);
        if (nodeID >= this.leafNodeOffset) {
            int hitCount = 0;
            long fp = this.leafBlockFPs[nodeID - this.leafNodeOffset];
            if (fp == 0L) {
                return 0;
            }
            state.in.seek(fp);
            int count = state.in.readVInt();
            state.docs.grow(count);
            block0: for (int i = 0; i < count; ++i) {
                int docID = state.in.readInt();
                state.sndv.setDocument(docID);
                int docValueCount = state.sndv.count();
                for (int j = 0; j < docValueCount; ++j) {
                    long enc = state.sndv.valueAt(j);
                    int latEnc = (int)(enc >> 32 & 0xFFFFFFFFL);
                    int lonEnc = (int)(enc & 0xFFFFFFFFL);
                    if (latEnc < state.latMinEnc || latEnc >= state.latMaxEnc || lonEnc < state.lonMinEnc || lonEnc >= state.lonMaxEnc || state.latLonFilter != null && !state.latLonFilter.accept(BKDTreeWriter.decodeLat(latEnc), BKDTreeWriter.decodeLon(lonEnc))) continue;
                    state.docs.add(docID);
                    ++hitCount;
                    continue block0;
                }
            }
            return hitCount;
        }
        int splitValue = this.splitValues[nodeID];
        if (splitValue == Integer.MAX_VALUE) {
            return 0;
        }
        int count = 0;
        if (!dim) {
            if (state.latMinEnc < splitValue) {
                count += this.intersect(state, 2 * nodeID, cellLatMinEnc, splitValue, cellLonMinEnc, cellLonMaxEnc);
            }
            if (state.latMaxEnc >= splitValue) {
                count += this.intersect(state, 2 * nodeID + 1, splitValue, cellLatMaxEnc, cellLonMinEnc, cellLonMaxEnc);
            }
        } else {
            assert (dim);
            if (state.lonMinEnc < splitValue) {
                count += this.intersect(state, 2 * nodeID, cellLatMinEnc, cellLatMaxEnc, cellLonMinEnc, splitValue);
            }
            if (state.lonMaxEnc >= splitValue) {
                count += this.intersect(state, 2 * nodeID + 1, cellLatMinEnc, cellLatMaxEnc, splitValue, cellLonMaxEnc);
            }
        }
        return count;
    }

    public long ramBytesUsed() {
        return this.splitValues.length * 4 + this.leafBlockFPs.length * 8;
    }

    public Collection<Accountable> getChildResources() {
        return Collections.emptyList();
    }

    private static final class QueryState {
        final IndexInput in;
        byte[] scratch = new byte[16];
        final ByteArrayDataInput scratchReader = new ByteArrayDataInput(this.scratch);
        final DocIdSetBuilder docs;
        final int latMinEnc;
        final int latMaxEnc;
        final int lonMinEnc;
        final int lonMaxEnc;
        final LatLonFilter latLonFilter;
        final SortedNumericDocValues sndv;

        public QueryState(IndexInput in, int maxDoc, int latMinEnc, int latMaxEnc, int lonMinEnc, int lonMaxEnc, LatLonFilter latLonFilter, SortedNumericDocValues sndv) {
            this.in = in;
            this.docs = new DocIdSetBuilder(maxDoc);
            this.latMinEnc = latMinEnc;
            this.latMaxEnc = latMaxEnc;
            this.lonMinEnc = lonMinEnc;
            this.lonMaxEnc = lonMaxEnc;
            this.latLonFilter = latLonFilter;
            this.sndv = sndv;
        }
    }

    static interface LatLonFilter {
        public boolean accept(double var1, double var3);

        public Relation compare(double var1, double var3, double var5, double var7);
    }

    static enum Relation {
        INSIDE,
        CROSSES,
        OUTSIDE;

    }
}

