/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.tools.ant.beautifier;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import jodd.jerry.Jerry;
import org.apache.ignite.tools.ant.beautifier.GridJavadocCharArrayLexReader;
import org.apache.ignite.tools.ant.beautifier.GridJavadocToken;
import org.apache.ignite.tools.ant.beautifier.GridJavadocTokenType;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;

public class GridJavadocAntTask
extends MatchingTask {
    private static final String SH_URL = "http://agorbatchev.typepad.com/pub/sh/3_0_83";
    private File dir;
    private String css;
    private boolean verify = true;

    public void setDir(File dir) {
        assert (dir != null);
        this.dir = dir;
    }

    public void setCss(String css) {
        assert (css != null);
        this.css = css;
    }

    public void setVerify(Boolean verify) {
        assert (verify != null);
        this.verify = verify;
    }

    private void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                this.log("Failed closing [resource=" + closeable + ", message=" + e.getLocalizedMessage() + ']', 1);
            }
        }
    }

    public void execute() {
        if (this.dir == null) {
            throw new BuildException("'dir' attribute must be specified.");
        }
        if (this.css == null) {
            throw new BuildException("'css' attribute must be specified.");
        }
        this.log("dir=" + this.dir, 4);
        this.log("css=" + this.css, 4);
        DirectoryScanner scanner = this.getDirectoryScanner(this.dir);
        boolean fail = false;
        for (String fileName : scanner.getIncludedFiles()) {
            String file = this.dir.getAbsolutePath() + '/' + fileName;
            try {
                this.processFile(file);
            }
            catch (IOException e) {
                throw new BuildException("IO error while processing: " + file, (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                System.err.println("JavaDoc error: " + e.getMessage());
                fail = true;
            }
        }
        if (fail) {
            throw new BuildException("Execution failed due to previous errors.");
        }
    }

    private void processFile(String file) throws IOException {
        int ch;
        assert (file != null);
        String fileContent = GridJavadocAntTask.readFileToString(file, Charset.forName("UTF-8"));
        if (this.verify) {
            Jerry descBlock;
            Jerry doc = Jerry.jerry((CharSequence)fileContent);
            if (file.endsWith("overview-summary.html")) {
                Jerry otherPackages = doc.find("div.contentContainer table.overviewSummary caption span:contains('Other Packages')");
                if (otherPackages.size() > 0) {
                    throw new IllegalArgumentException("'Other Packages' section should not be present, all packages should have corresponding documentation groups: " + file);
                }
            } else if (!this.isViewHtml(file) && (descBlock = doc.find("div.contentContainer div.description ul.blockList li.blockList div.block")).size() == 0) {
                throw new IllegalArgumentException("Class doesn't have description in file: " + file);
            }
        }
        GridJavadocCharArrayLexReader lexer = new GridJavadocCharArrayLexReader(fileContent.toCharArray());
        ArrayList<GridJavadocToken> toks = new ArrayList<GridJavadocToken>();
        StringBuilder tokBuf = new StringBuilder();
        while ((ch = lexer.read()) != 65535) {
            if (ch == 60) {
                String val;
                if (tokBuf.length() > 0) {
                    toks.add(new GridJavadocToken(GridJavadocTokenType.TOKEN_TEXT, tokBuf.toString()));
                    tokBuf.setLength(0);
                }
                tokBuf.append('<');
                ch = lexer.read();
                if (ch == 65535) {
                    throw new IOException("Unexpected EOF: " + file);
                }
                if (ch == 33) {
                    while (ch != 65535 && ch != 62) {
                        tokBuf.append((char)ch);
                        ch = lexer.read();
                    }
                    if (ch == 65535) {
                        throw new IOException("Unexpected EOF: " + file);
                    }
                    assert (ch == 62);
                    tokBuf.append('>');
                    val = tokBuf.toString();
                    toks.add(new GridJavadocToken(val.startsWith("<!--") ? GridJavadocTokenType.TOKEN_COMM : GridJavadocTokenType.TOKEN_INSTR, val));
                    tokBuf.setLength(0);
                    continue;
                }
                while (ch != 65535 && ch != 62) {
                    tokBuf.append((char)ch);
                    ch = lexer.read();
                }
                if (ch == 65535) {
                    throw new IOException("Unexpected EOF: " + file);
                }
                assert (ch == 62);
                tokBuf.append('>');
                if (tokBuf.length() <= 2) {
                    throw new IOException("Invalid HTML in [file=" + file + ", html=" + tokBuf + ']');
                }
                val = tokBuf.toString();
                toks.add(new GridJavadocToken(val.startsWith("</") ? GridJavadocTokenType.TOKEN_CLOSE_TAG : GridJavadocTokenType.TOKEN_OPEN_TAG, val));
                tokBuf.setLength(0);
                continue;
            }
            tokBuf.append((char)ch);
        }
        if (tokBuf.length() > 0) {
            toks.add(new GridJavadocToken(GridJavadocTokenType.TOKEN_TEXT, tokBuf.toString()));
        }
        block15: for (GridJavadocToken tok : toks) {
            String val = tok.value();
            switch (tok.type()) {
                case TOKEN_COMM: {
                    continue block15;
                }
                case TOKEN_OPEN_TAG: {
                    tok.update(this.fixColors(tok.value()));
                    continue block15;
                }
                case TOKEN_CLOSE_TAG: {
                    if ("</head>".equalsIgnoreCase(val)) {
                        tok.update("<link rel='shortcut icon' href='https://ignite.apache.org/favicon.ico'/>\n<link type='text/css' rel='stylesheet' href='http://agorbatchev.typepad.com/pub/sh/3_0_83/styles/shCore.css'/>\n<link type='text/css' rel='stylesheet' href='http://agorbatchev.typepad.com/pub/sh/3_0_83/styles/shThemeDefault.css'/>\n<script type='text/javascript' src='http://agorbatchev.typepad.com/pub/sh/3_0_83/scripts/shCore.js'></script>\n<script type='text/javascript' src='http://agorbatchev.typepad.com/pub/sh/3_0_83/scripts/shLegacy.js'></script>\n<script type='text/javascript' src='http://agorbatchev.typepad.com/pub/sh/3_0_83/scripts/shBrushJava.js'></script>\n<script type='text/javascript' src='http://agorbatchev.typepad.com/pub/sh/3_0_83/scripts/shBrushPlain.js'></script>\n<script type='text/javascript' src='http://agorbatchev.typepad.com/pub/sh/3_0_83/scripts/shBrushJScript.js'></script>\n<script type='text/javascript' src='http://agorbatchev.typepad.com/pub/sh/3_0_83/scripts/shBrushBash.js'></script>\n<script type='text/javascript' src='http://agorbatchev.typepad.com/pub/sh/3_0_83/scripts/shBrushXml.js'></script>\n<script type='text/javascript' src='http://agorbatchev.typepad.com/pub/sh/3_0_83/scripts/shBrushScala.js'></script>\n<script type='text/javascript' src='http://agorbatchev.typepad.com/pub/sh/3_0_83/scripts/shBrushGroovy.js'></script>\n</head>\n");
                        continue block15;
                    }
                    if (!"</body>".equalsIgnoreCase(val)) continue block15;
                    tok.update("<!--FOOTER--><script type='text/javascript'>SyntaxHighlighter.all();dp.SyntaxHighlighter.HighlightAll('code');</script>\n</body>\n");
                    continue block15;
                }
                case TOKEN_INSTR: {
                    continue block15;
                }
                case TOKEN_TEXT: {
                    tok.update(this.fixColors(val));
                    continue block15;
                }
            }
            assert (false);
        }
        StringBuilder buf = new StringBuilder();
        StringBuilder tmp = new StringBuilder();
        boolean inPre = false;
        block16: for (GridJavadocToken tok : toks) {
            String val = tok.value();
            switch (tok.type()) {
                case TOKEN_COMM: 
                case TOKEN_INSTR: 
                case TOKEN_TEXT: {
                    tmp.append(val);
                    continue block16;
                }
                case TOKEN_OPEN_TAG: {
                    if (val.toLowerCase().startsWith("<pre name=")) {
                        inPre = true;
                        buf.append(this.fixBrackets(tmp.toString()));
                        tmp.setLength(0);
                    }
                    tmp.append(val);
                    continue block16;
                }
                case TOKEN_CLOSE_TAG: {
                    if (val.toLowerCase().startsWith("</pre") && inPre) {
                        inPre = false;
                        buf.append(tmp.toString());
                        tmp.setLength(0);
                    }
                    tmp.append(val);
                    continue block16;
                }
            }
            assert (false);
        }
        String s = buf.append(this.fixBrackets(tmp.toString())).toString();
        s = this.fixExternalLinks(s);
        s = this.fixDeprecated(s);
        s = this.fixNullable(s);
        s = this.fixTodo(s);
        this.replaceFile(file, s);
    }

    private boolean isViewHtml(String fileName) {
        String baseName = new File(fileName).getName();
        return "index.html".equals(baseName) || baseName.contains("-");
    }

    private String fixColors(String s) {
        return s.replace("0000c0", "000000").replace("000000", "333333").replace("c00000", "333333").replace("008000", "999999").replace("990000", "336699").replace("font color=\"#808080\"", "font size=-2 color=\"#aaaaaa\"");
    }

    private String fixBrackets(String s) {
        return s.replace("&lt;", "<span class='angle_bracket'>&lt;</span>").replace("&gt;", "<span class='angle_bracket'>&gt;</span>");
    }

    private String fixTodo(String s) {
        return s.replace("TODO", "<span class='todo'>TODO</span>");
    }

    private String fixNullable(String s) {
        return s.replace("<FONT SIZE=\"-1\">@Nullable", "<FONT SIZE=\"-1\" class='nullable'>@Nullable");
    }

    private String fixDeprecated(String s) {
        return s.replace("<B>Deprecated.</B>", "<span class='deprecated'>Deprecated.</span>");
    }

    private String fixExternalLinks(String s) {
        return s.replace("A HREF=\"http://java.sun.com/j2se/1.6.0", "A target='jse5javadoc' HREF=\"http://java.sun.com/j2se/1.6.0");
    }

    private void replaceFile(String file, String body) throws IOException {
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));){
            ((OutputStream)out).write(body.getBytes());
        }
    }

    public static String readFileToString(String fileName, Charset charset) throws IOException {
        int n;
        InputStreamReader input = new InputStreamReader((InputStream)new FileInputStream(fileName), charset);
        StringWriter output = new StringWriter();
        char[] buf = new char[4096];
        while ((n = input.read(buf)) != -1) {
            output.write(buf, 0, n);
        }
        return output.toString();
    }
}

