/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.nodestart;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.ChannelShell;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterStartNodeResult;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.cluster.ClusterStartNodeResultImpl;
import org.apache.ignite.internal.util.nodestart.IgniteRemoteStartSpecification;
import org.apache.ignite.internal.util.nodestart.StartNodeCallable;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.resources.LoggerResource;

public class StartNodeCallableImpl
implements StartNodeCallable {
    private static final String DFLT_IGNITE_HOME_WIN = "%IGNITE_HOME%";
    private static final String DFLT_IGNITE_HOME_LINUX = "$IGNITE_HOME";
    private static final String DFLT_SCRIPT_LINUX = "bin/ignite.sh -v";
    private static final SimpleDateFormat FILE_NAME_DATE_FORMAT = new SimpleDateFormat("MM-dd-yyyy--HH-mm-ss");
    private final IgniteRemoteStartSpecification spec;
    private final int timeout;
    @LoggerResource
    private IgniteLogger log;

    public StartNodeCallableImpl() {
        this.spec = null;
        this.timeout = 0;
        assert (false);
    }

    public StartNodeCallableImpl(IgniteRemoteStartSpecification spec, int timeout) {
        assert (spec != null);
        this.spec = spec;
        this.timeout = timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusterStartNodeResult call() {
        JSch ssh = new JSch();
        Session ses = null;
        try {
            String cfg;
            String script;
            if (this.spec.key() != null) {
                ssh.addIdentity(this.spec.key().getAbsolutePath());
            }
            ses = ssh.getSession(this.spec.username(), this.spec.host(), this.spec.port());
            if (this.spec.password() != null) {
                ses.setPassword(this.spec.password());
            }
            ses.setConfig("StrictHostKeyChecking", "no");
            ses.connect(this.timeout);
            boolean win = this.isWindows(ses);
            char separator = win ? (char)'\\' : '/';
            this.spec.fixPaths(separator);
            String igniteHome = this.spec.igniteHome();
            if (igniteHome == null) {
                String string = igniteHome = win ? DFLT_IGNITE_HOME_WIN : DFLT_IGNITE_HOME_LINUX;
            }
            if ((script = this.spec.script()) == null) {
                script = DFLT_SCRIPT_LINUX;
            }
            if ((cfg = this.spec.configuration()) == null) {
                cfg = "";
            }
            String scriptOutputFileName = FILE_NAME_DATE_FORMAT.format(new Date()) + '-' + UUID.randomUUID().toString().substring(0, 8) + ".log";
            if (win) {
                throw new UnsupportedOperationException("Apache Ignite cannot be auto-started on Windows from IgniteCluster.startNodes(\u2026) API.");
            }
            int spaceIdx = script.indexOf(32);
            String scriptPath = spaceIdx > -1 ? script.substring(0, spaceIdx) : script;
            String scriptArgs = spaceIdx > -1 ? script.substring(spaceIdx + 1) : "";
            String rmtLogArgs = this.buildRemoteLogArguments(this.spec.username(), this.spec.host());
            String tmpDir = this.env(ses, "$TMPDIR", "/tmp/");
            String scriptOutputDir = tmpDir + "ignite-startNodes";
            this.shell(ses, "mkdir " + scriptOutputDir);
            if (igniteHome.startsWith("~")) {
                String homeDir = this.env(ses, "$HOME", "~");
                igniteHome = igniteHome.replaceFirst("~", homeDir);
            }
            String startNodeCmd = new SB().a("nohup ").a("\"").a(igniteHome).a('/').a(scriptPath).a("\"").a(" ").a(scriptArgs).a(!cfg.isEmpty() ? " \"" : "").a(cfg).a(!cfg.isEmpty() ? "\"" : "").a(rmtLogArgs).a(" > ").a(scriptOutputDir).a("/").a(scriptOutputFileName).a(" 2>& 1 &").toString();
            this.info("Starting remote node with SSH command: " + startNodeCmd, this.spec.logger(), this.log);
            this.shell(ses, startNodeCmd);
            ClusterStartNodeResultImpl clusterStartNodeResultImpl = new ClusterStartNodeResultImpl(this.spec.host(), true, null);
            return clusterStartNodeResultImpl;
        }
        catch (IgniteInterruptedCheckedException e) {
            ClusterStartNodeResultImpl clusterStartNodeResultImpl = new ClusterStartNodeResultImpl(this.spec.host(), false, e.getMessage());
            return clusterStartNodeResultImpl;
        }
        catch (Exception e) {
            ClusterStartNodeResultImpl clusterStartNodeResultImpl = new ClusterStartNodeResultImpl(this.spec.host(), false, X.getFullStackTrace((Throwable)e));
            return clusterStartNodeResultImpl;
        }
        finally {
            if (ses != null && ses.isConnected()) {
                ses.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shell(Session ses, String cmd) throws JSchException, IOException, IgniteInterruptedCheckedException {
        ChannelShell ch = null;
        try {
            ch = (ChannelShell)ses.openChannel("shell");
            ch.connect();
            try (PrintStream out = new PrintStream(ch.getOutputStream(), true);){
                out.println(cmd);
                U.sleep((long)1000L);
            }
        }
        finally {
            if (ch != null && ch.isConnected()) {
                ch.disconnect();
            }
        }
    }

    private boolean isWindows(Session ses) throws JSchException {
        try {
            return this.exec(ses, "cmd.exe") != null;
        }
        catch (IOException ignored) {
            return false;
        }
    }

    private String env(Session ses, String name, String dflt) throws JSchException {
        try {
            return this.exec(ses, "echo " + name);
        }
        catch (IOException ignored) {
            return dflt;
        }
    }

    /*
     * Loose catch block
     */
    private String exec(Session ses, String cmd) throws JSchException, IOException {
        ChannelExec ch = null;
        try {
            ch = (ChannelExec)ses.openChannel("exec");
            ch.setCommand(cmd);
            ch.connect();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(ch.getInputStream()));){
                String string = reader.readLine();
                return string;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (ch != null && ch.isConnected()) {
                ch.disconnect();
            }
        }
    }

    private String buildRemoteLogArguments(String username, String host) {
        assert (username != null);
        assert (host != null);
        SB sb = new SB();
        sb.a(" -J-D").a("IGNITE_SSH_HOST").a("=\"").a(host).a("\"").a(" -J-D").a("IGNITE_SSH_USER_NAME").a("=\"").a(username).a("\"");
        return sb.toString();
    }

    public StartNodeCallable setLogger(IgniteLogger log) {
        this.log = log;
        return this;
    }

    private void info(String msg, IgniteLogger ... loggers) {
        for (IgniteLogger logger : loggers) {
            if (logger == null || !logger.isInfoEnabled()) continue;
            logger.info(msg);
        }
    }
}

