/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.twostep.msg;

import java.util.Collection;
import java.util.Iterator;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2ValueCacheObject;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2Array;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2Boolean;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2Byte;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2Bytes;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2CacheObject;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2Date;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2Decimal;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2Double;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2Float;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2Geometry;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2Integer;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2JavaObject;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2Long;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2Null;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2Short;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2String;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2Time;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2Timestamp;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2Uuid;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2ValueMessage;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageFactory;
import org.h2.value.Value;
import org.jetbrains.annotations.Nullable;

public class GridH2ValueMessageFactory
implements MessageFactory {
    @Nullable
    public Message create(byte type) {
        switch (type) {
            case -4: {
                return GridH2Null.INSTANCE;
            }
            case -5: {
                return new GridH2Boolean();
            }
            case -6: {
                return new GridH2Byte();
            }
            case -7: {
                return new GridH2Short();
            }
            case -8: {
                return new GridH2Integer();
            }
            case -9: {
                return new GridH2Long();
            }
            case -10: {
                return new GridH2Decimal();
            }
            case -11: {
                return new GridH2Double();
            }
            case -12: {
                return new GridH2Float();
            }
            case -13: {
                return new GridH2Time();
            }
            case -14: {
                return new GridH2Date();
            }
            case -15: {
                return new GridH2Timestamp();
            }
            case -16: {
                return new GridH2Bytes();
            }
            case -17: {
                return new GridH2String();
            }
            case -18: {
                return new GridH2Array();
            }
            case -19: {
                return new GridH2JavaObject();
            }
            case -20: {
                return new GridH2Uuid();
            }
            case -21: {
                return new GridH2Geometry();
            }
            case -22: {
                return new GridH2CacheObject();
            }
        }
        return null;
    }

    public static Collection<Message> toMessages(Collection<Value[]> src, Collection<Message> dst) throws IgniteCheckedException {
        for (Value[] row : src) {
            for (Value val : row) {
                dst.add(GridH2ValueMessageFactory.toMessage(val));
            }
        }
        return dst;
    }

    public static Value[] fillArray(Iterator<Message> src, Value[] dst, GridKernalContext ctx) throws IgniteCheckedException {
        for (int i = 0; i < dst.length; ++i) {
            Message msg = src.next();
            dst[i] = ((GridH2ValueMessage)msg).value(ctx);
        }
        return dst;
    }

    public static Message toMessage(Value v) throws IgniteCheckedException {
        switch (v.getType()) {
            case 0: {
                return GridH2Null.INSTANCE;
            }
            case 1: {
                return new GridH2Boolean(v);
            }
            case 2: {
                return new GridH2Byte(v);
            }
            case 3: {
                return new GridH2Short(v);
            }
            case 4: {
                return new GridH2Integer(v);
            }
            case 5: {
                return new GridH2Long(v);
            }
            case 6: {
                return new GridH2Decimal(v);
            }
            case 7: {
                return new GridH2Double(v);
            }
            case 8: {
                return new GridH2Float(v);
            }
            case 10: {
                return new GridH2Date(v);
            }
            case 9: {
                return new GridH2Time(v);
            }
            case 11: {
                return new GridH2Timestamp(v);
            }
            case 12: {
                return new GridH2Bytes(v);
            }
            case 13: 
            case 14: 
            case 21: {
                return new GridH2String(v);
            }
            case 17: {
                return new GridH2Array(v);
            }
            case 19: {
                if (v instanceof GridH2ValueCacheObject) {
                    return new GridH2CacheObject((GridH2ValueCacheObject)v);
                }
                return new GridH2JavaObject(v);
            }
            case 20: {
                return new GridH2Uuid(v);
            }
            case 22: {
                return new GridH2Geometry(v);
            }
        }
        throw new IllegalStateException("Unsupported H2 type: " + v.getType());
    }
}

