/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.twostep;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.h2.api.TableEngine;
import org.h2.command.ddl.CreateTableData;
import org.h2.engine.DbObject;
import org.h2.engine.Session;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.result.SortOrder;
import org.h2.schema.Schema;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.PlanItem;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.value.Value;

public class GridThreadLocalTable
extends Table {
    private final ThreadLocal<Table> tbl = new ThreadLocal();

    public GridThreadLocalTable(Schema schema, int id, String name, boolean persistIndexes, boolean persistData) {
        super(schema, id, name, persistIndexes, persistData);
    }

    public void setInnerTable(Table t) {
        if (t == null) {
            this.tbl.remove();
        } else {
            this.tbl.set(t);
        }
    }

    public Index getPrimaryKey() {
        return this.tbl.get().getPrimaryKey();
    }

    public Column getRowIdColumn() {
        return this.tbl.get().getRowIdColumn();
    }

    public PlanItem getBestPlanItem(Session session, int[] masks, TableFilter filter, SortOrder sortOrder) {
        return this.tbl.get().getBestPlanItem(session, masks, filter, sortOrder);
    }

    public Value getDefaultValue(Session session, Column column) {
        return this.tbl.get().getDefaultValue(session, column);
    }

    public SearchRow getTemplateSimpleRow(boolean singleColumn) {
        return this.tbl.get().getTemplateSimpleRow(singleColumn);
    }

    public Row getTemplateRow() {
        return this.tbl.get().getTemplateRow();
    }

    public Column getColumn(String columnName) {
        return this.tbl.get().getColumn(columnName);
    }

    public Column getColumn(int index) {
        return this.tbl.get().getColumn(index);
    }

    public Index getIndexForColumn(Column column) {
        return this.tbl.get().getIndexForColumn(column);
    }

    public Column[] getColumns() {
        return this.tbl.get().getColumns();
    }

    protected void setColumns(Column[] columns) {
        throw new IllegalStateException("Cols: " + Arrays.asList(columns));
    }

    public void lock(Session session, boolean exclusive, boolean force) {
        this.tbl.get().lock(session, exclusive, force);
    }

    public void close(Session session) {
    }

    public void unlock(Session s) {
        this.tbl.get().unlock(s);
    }

    public Index addIndex(Session session, String indexName, int indexId, IndexColumn[] cols, IndexType indexType, boolean create, String indexComment) {
        return this.tbl.get().addIndex(session, indexName, indexId, cols, indexType, create, indexComment);
    }

    public void removeRow(Session session, Row row) {
        this.tbl.get().removeRow(session, row);
    }

    public void truncate(Session session) {
        this.tbl.get().truncate(session);
    }

    public void addRow(Session session, Row row) {
        this.tbl.get().addRow(session, row);
    }

    public void checkSupportAlter() {
        this.tbl.get().checkSupportAlter();
    }

    public String getTableType() {
        return "EXTERNAL";
    }

    public Index getUniqueIndex() {
        return this.tbl.get().getUniqueIndex();
    }

    public Index getScanIndex(Session session) {
        return this.tbl.get().getScanIndex(session);
    }

    public ArrayList<Index> getIndexes() {
        return this.tbl.get().getIndexes();
    }

    public boolean isLockedExclusively() {
        return this.tbl.get().isLockedExclusively();
    }

    public long getMaxDataModificationId() {
        return 0L;
    }

    public boolean isDeterministic() {
        return this.tbl.get().isDeterministic();
    }

    public boolean canGetRowCount() {
        return this.tbl.get().canGetRowCount();
    }

    public boolean canDrop() {
        return false;
    }

    public long getRowCount(Session session) {
        return this.tbl.get().getRowCount(session);
    }

    public long getRowCountApproximation() {
        Table t = this.tbl.get();
        return t == null ? 0L : t.getRowCountApproximation();
    }

    public long getDiskSpaceUsed() {
        return 0L;
    }

    public String getCreateSQL() {
        return "";
    }

    public String getDropSQL() {
        return "";
    }

    public void addDependencies(HashSet<DbObject> dependencies) {
    }

    public void checkRename() {
        throw DbException.getUnsupportedException((String)"rename");
    }

    public static class Engine
    implements TableEngine {
        private static ThreadLocal<GridThreadLocalTable> createdTbl = new ThreadLocal();

        public static GridThreadLocalTable getCreated() {
            GridThreadLocalTable tbl = createdTbl.get();
            assert (tbl != null);
            createdTbl.remove();
            return tbl;
        }

        public Table createTable(CreateTableData d) {
            assert (createdTbl.get() == null);
            GridThreadLocalTable tbl = new GridThreadLocalTable(d.schema, d.id, d.tableName, d.persistIndexes, d.persistData);
            createdTbl.set(tbl);
            return tbl;
        }
    }
}

