/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.twostep;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.cache.CacheException;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.query.h2.twostep.GridMergeIndex;
import org.apache.ignite.internal.processors.query.h2.twostep.GridMergeTable;
import org.apache.ignite.internal.processors.query.h2.twostep.GridResultPage;
import org.h2.index.Cursor;
import org.h2.index.IndexType;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.value.Value;
import org.jetbrains.annotations.Nullable;

public class GridMergeIndexUnsorted
extends GridMergeIndex {
    private final BlockingQueue<GridResultPage> queue = new LinkedBlockingQueue<GridResultPage>();

    public GridMergeIndexUnsorted(GridKernalContext ctx, GridMergeTable tbl, String name) {
        super(ctx, tbl, name, IndexType.createScan((boolean)false), IndexColumn.wrap((Column[])tbl.getColumns()));
    }

    public static GridMergeIndexUnsorted createDummy(GridKernalContext ctx) {
        return new GridMergeIndexUnsorted(ctx);
    }

    private GridMergeIndexUnsorted(GridKernalContext ctx) {
        super(ctx);
    }

    @Override
    protected void addPage0(GridResultPage page) {
        assert (page.rowsInPage() > 0 || page.isLast() || page.isFail());
        this.queue.add(page);
    }

    @Override
    protected Cursor findAllFetched(List<Row> fetched, @Nullable SearchRow first, @Nullable SearchRow last) {
        return new GridMergeIndex.IteratorCursor(fetched.iterator());
    }

    @Override
    protected Cursor findInStream(@Nullable SearchRow first, @Nullable SearchRow last) {
        return new GridMergeIndex.FetchingCursor(new Iterator<Row>(){
            Iterator<Value[]> iter = Collections.emptyIterator();

            @Override
            public boolean hasNext() {
                while (!this.iter.hasNext()) {
                    GridResultPage page;
                    while (true) {
                        try {
                            page = (GridResultPage)GridMergeIndexUnsorted.this.queue.poll(500L, TimeUnit.MILLISECONDS);
                        }
                        catch (InterruptedException e) {
                            throw new CacheException("Query execution was interrupted.", (Throwable)e);
                        }
                        if (page != null) break;
                        GridMergeIndexUnsorted.this.checkSourceNodesAlive();
                    }
                    if (page.isLast()) {
                        return false;
                    }
                    GridMergeIndexUnsorted.this.fetchNextPage(page);
                    this.iter = page.rows();
                }
                return true;
            }

            @Override
            public Row next() {
                return new Row(this.iter.next(), 0);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        });
    }
}

