/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.twostep;

import java.lang.reflect.Field;
import java.sql.ResultSet;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReferenceArray;
import javax.cache.CacheException;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.events.CacheQueryExecutedEvent;
import org.apache.ignite.events.CacheQueryReadEvent;
import org.apache.ignite.events.DiscoveryEvent;
import org.apache.ignite.events.Event;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.GridTopic;
import org.apache.ignite.internal.managers.communication.GridMessageListener;
import org.apache.ignite.internal.managers.eventstorage.GridLocalEventListener;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtPartitionsReservation;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridReservable;
import org.apache.ignite.internal.processors.cache.query.CacheQueryType;
import org.apache.ignite.internal.processors.cache.query.GridCacheSqlQuery;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.h2.twostep.messages.GridQueryCancelRequest;
import org.apache.ignite.internal.processors.query.h2.twostep.messages.GridQueryFailResponse;
import org.apache.ignite.internal.processors.query.h2.twostep.messages.GridQueryNextPageRequest;
import org.apache.ignite.internal.processors.query.h2.twostep.messages.GridQueryNextPageResponse;
import org.apache.ignite.internal.processors.query.h2.twostep.messages.GridQueryRequest;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2ValueMessageFactory;
import org.apache.ignite.internal.util.GridSpinBusyLock;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.h2.jdbc.JdbcResultSet;
import org.h2.result.ResultInterface;
import org.h2.value.Value;
import org.jetbrains.annotations.Nullable;
import org.jsr166.ConcurrentHashMap8;

public class GridMapQueryExecutor {
    private static final Field RESULT_FIELD;
    private IgniteLogger log;
    private GridKernalContext ctx;
    private IgniteH2Indexing h2;
    private ConcurrentMap<UUID, ConcurrentMap<Long, QueryResults>> qryRess = new ConcurrentHashMap8();
    private final GridSpinBusyLock busyLock;
    private final ConcurrentMap<T2<String, AffinityTopologyVersion>, GridReservable> reservations = new ConcurrentHashMap8();

    public GridMapQueryExecutor(GridSpinBusyLock busyLock) {
        this.busyLock = busyLock;
    }

    public void start(GridKernalContext ctx, IgniteH2Indexing h2) throws IgniteCheckedException {
        this.ctx = ctx;
        this.h2 = h2;
        this.log = ctx.log(GridMapQueryExecutor.class);
        ctx.event().addLocalEventListener(new GridLocalEventListener(){

            public void onEvent(Event evt) {
                UUID nodeId = ((DiscoveryEvent)evt).eventNode().id();
                ConcurrentMap nodeRess = (ConcurrentMap)GridMapQueryExecutor.this.qryRess.remove(nodeId);
                if (nodeRess == null) {
                    return;
                }
                for (QueryResults ress : nodeRess.values()) {
                    ress.cancel();
                }
            }
        }, 12, new int[]{11});
        ctx.io().addMessageListener(GridTopic.TOPIC_QUERY, new GridMessageListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onMessage(UUID nodeId, Object msg) {
                if (!GridMapQueryExecutor.this.busyLock.enterBusy()) {
                    return;
                }
                try {
                    GridMapQueryExecutor.this.onMessage(nodeId, msg);
                }
                finally {
                    GridMapQueryExecutor.this.busyLock.leaveBusy();
                }
            }
        });
    }

    public void onMessage(UUID nodeId, Object msg) {
        try {
            assert (msg != null);
            ClusterNode node = this.ctx.discovery().node(nodeId);
            if (node == null) {
                return;
            }
            boolean processed = true;
            if (msg instanceof GridQueryRequest) {
                this.onQueryRequest(node, (GridQueryRequest)msg);
            } else if (msg instanceof GridQueryNextPageRequest) {
                this.onNextPageRequest(node, (GridQueryNextPageRequest)msg);
            } else if (msg instanceof GridQueryCancelRequest) {
                this.onCancel(node, (GridQueryCancelRequest)msg);
            } else {
                processed = false;
            }
            if (processed && this.log.isDebugEnabled()) {
                this.log.debug("Processed request: " + nodeId + "->" + this.ctx.localNodeId() + " " + msg);
            }
        }
        catch (Throwable th) {
            U.error((IgniteLogger)this.log, (Object)("Failed to process message: " + msg), (Throwable)th);
        }
    }

    private void onCancel(ClusterNode node, GridQueryCancelRequest msg) {
        ConcurrentMap<Long, QueryResults> nodeRess = this.resultsForNode(node.id());
        QueryResults results = (QueryResults)nodeRess.remove(msg.queryRequestId());
        if (results == null) {
            return;
        }
        results.cancel();
    }

    private ConcurrentMap<Long, QueryResults> resultsForNode(UUID nodeId) {
        ConcurrentMap<Long, QueryResults> old;
        ConcurrentMap<Long, QueryResults> nodeRess = (ConcurrentMap<Long, QueryResults>)this.qryRess.get(nodeId);
        if (nodeRess == null && (old = this.qryRess.putIfAbsent(nodeId, nodeRess = new ConcurrentHashMap8())) != null) {
            nodeRess = old;
        }
        return nodeRess;
    }

    @Nullable
    private GridCacheContext<?, ?> cacheContext(String cacheName) {
        GridCacheAdapter cache = this.ctx.cache().internalCache(cacheName);
        if (cache == null) {
            return null;
        }
        return cache.context();
    }

    private GridDhtLocalPartition partition(GridCacheContext<?, ?> cctx, int p) {
        return cctx.topology().localPartition(p, AffinityTopologyVersion.NONE, false);
    }

    private boolean reservePartitions(Collection<String> cacheNames, AffinityTopologyVersion topVer, int[] explicitParts, List<GridReservable> reserved) throws IgniteCheckedException {
        assert (topVer != null);
        Set partIds = GridMapQueryExecutor.wrap(explicitParts);
        for (String cacheName : cacheNames) {
            GridDhtPartitionsReservation grp;
            GridCacheContext<?, ?> cctx = this.cacheContext(cacheName);
            if (cctx == null) {
                return false;
            }
            if (cctx.isLocal()) continue;
            final T2 grpKey = new T2((Object)cctx.name(), (Object)(cctx.isReplicated() ? null : topVer));
            GridReservable r = (GridReservable)this.reservations.get(grpKey);
            if (explicitParts == null && r != null) {
                if (r == ReplicatedReservation.INSTANCE) continue;
                if (!r.reserve()) {
                    return false;
                }
                reserved.add(r);
                continue;
            }
            int partsCnt = cctx.affinity().partitions();
            if (cctx.isReplicated()) {
                if (r != null) continue;
                for (int p = 0; p < partsCnt; ++p) {
                    GridDhtLocalPartition part = this.partition(cctx, p);
                    if (part != null && part.state() == GridDhtPartitionState.OWNING) continue;
                    return false;
                }
                this.reservations.putIfAbsent((T2<String, AffinityTopologyVersion>)grpKey, ReplicatedReservation.INSTANCE);
                continue;
            }
            if (explicitParts == null) {
                partIds = cctx.affinity().primaryPartitions(this.ctx.localNodeId(), topVer);
            }
            for (int partId : partIds) {
                GridDhtLocalPartition part = this.partition(cctx, partId);
                if (part == null || part.state() != GridDhtPartitionState.OWNING || !part.reserve()) {
                    return false;
                }
                reserved.add((GridReservable)part);
                if (part.state() == GridDhtPartitionState.OWNING) continue;
                return false;
            }
            if (explicitParts != null || !(grp = new GridDhtPartitionsReservation(topVer, cctx, (Object)"SQL")).register(reserved.subList(reserved.size() - partIds.size(), reserved.size()))) continue;
            if (this.reservations.putIfAbsent((T2<String, AffinityTopologyVersion>)grpKey, (GridReservable)grp) != null) {
                throw new IllegalStateException("Reservation already exists.");
            }
            grp.onPublish((CI1)new CI1<GridDhtPartitionsReservation>(){

                public void apply(GridDhtPartitionsReservation r) {
                    GridMapQueryExecutor.this.reservations.remove(grpKey, r);
                }
            });
        }
        return true;
    }

    private static Collection<Integer> wrap(final int[] ints) {
        if (ints == null) {
            return null;
        }
        if (ints.length == 0) {
            return Collections.emptySet();
        }
        return new AbstractCollection<Integer>(){

            @Override
            public Iterator<Integer> iterator() {
                return new Iterator<Integer>(){
                    private int i = 0;

                    @Override
                    public boolean hasNext() {
                        return this.i < ints.length;
                    }

                    @Override
                    public Integer next() {
                        return ints[this.i++];
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                return ints.length;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onQueryRequest(ClusterNode node, GridQueryRequest req) {
        ConcurrentMap<Long, QueryResults> nodeRess = this.resultsForNode(node.id());
        QueryResults qr = null;
        ArrayList<GridReservable> reserved = new ArrayList<GridReservable>();
        try {
            Collection qrys;
            try {
                qrys = req.queries();
                if (!node.isLocal()) {
                    Marshaller m = this.ctx.config().getMarshaller();
                    for (GridCacheSqlQuery qry : qrys) {
                        qry.unmarshallParams(m, this.ctx);
                    }
                }
            }
            catch (IgniteCheckedException e) {
                throw new CacheException("Failed to unmarshall parameters.", (Throwable)e);
            }
            List caches = (List)F.concat((boolean)true, (Object)req.space(), (Collection)req.extraSpaces());
            AffinityTopologyVersion topVer = req.topologyVersion();
            if (topVer != null && !this.reservePartitions(caches, topVer, req.partitions(), reserved)) {
                this.sendRetry(node, req.requestId());
                return;
            }
            GridCacheContext<?, ?> mainCctx = this.cacheContext(req.space());
            if (mainCctx == null) {
                throw new CacheException("Failed to find cache: " + req.space());
            }
            qr = new QueryResults(req.requestId(), qrys.size(), mainCctx);
            if (nodeRess.put(req.requestId(), qr) != null) {
                throw new IllegalStateException();
            }
            this.h2.setFilters(this.h2.backupFilter(caches, topVer, req.partitions()));
            int i = 0;
            for (GridCacheSqlQuery qry : qrys) {
                ResultSet rs = this.h2.executeSqlQueryWithTimer(req.space(), this.h2.connectionForSpace(req.space()), qry.query(), F.asList((Object[])qry.parameters()), true);
                if (this.ctx.event().isRecordable(96)) {
                    this.ctx.event().record((Event)new CacheQueryExecutedEvent(node, "SQL query executed.", 96, CacheQueryType.SQL.name(), mainCctx.namex(), null, qry.query(), null, null, qry.parameters(), node.id(), null));
                }
                assert (rs instanceof JdbcResultSet) : rs.getClass();
                qr.addResult(i, qry, node.id(), rs);
                if (qr.canceled) {
                    qr.result(i).close();
                    return;
                }
                this.sendNextPage(nodeRess, node, qr, i, req.pageSize());
                ++i;
            }
        }
        catch (Throwable e) {
            if (qr != null) {
                nodeRess.remove(req.requestId(), qr);
                qr.cancel();
            }
            U.error((IgniteLogger)this.log, (Object)("Failed to execute local query: " + req), (Throwable)e);
            this.sendError(node, req.requestId(), e);
            if (e instanceof Error) {
                throw (Error)e;
            }
        }
        finally {
            this.h2.setFilters(null);
            for (GridReservable r : reserved) {
                r.release();
            }
        }
    }

    private void sendError(ClusterNode node, long qryReqId, Throwable err) {
        try {
            GridQueryFailResponse msg = new GridQueryFailResponse(qryReqId, err);
            if (node.isLocal()) {
                this.h2.reduceQueryExecutor().onMessage(this.ctx.localNodeId(), msg);
            } else {
                this.ctx.io().send(node, GridTopic.TOPIC_QUERY, (Message)msg, (byte)2);
            }
        }
        catch (Exception e) {
            e.addSuppressed(err);
            U.error((IgniteLogger)this.log, (Object)"Failed to send error message.", (Throwable)e);
        }
    }

    private void onNextPageRequest(ClusterNode node, GridQueryNextPageRequest req) {
        QueryResults qr;
        ConcurrentMap nodeRess = (ConcurrentMap)this.qryRess.get(node.id());
        QueryResults queryResults = qr = nodeRess == null ? null : (QueryResults)nodeRess.get(req.queryRequestId());
        if (qr == null || qr.canceled) {
            this.sendError(node, req.queryRequestId(), (Throwable)new CacheException("No query result found for request: " + req));
        } else {
            this.sendNextPage(nodeRess, node, qr, req.query(), req.pageSize());
        }
    }

    private void sendNextPage(ConcurrentMap<Long, QueryResults> nodeRess, ClusterNode node, QueryResults qr, int qry, int pageSize) {
        QueryResult res = qr.result(qry);
        assert (res != null);
        int page = res.page;
        ArrayList<Value[]> rows = new ArrayList<Value[]>(Math.min(64, pageSize));
        boolean last = res.fetchNextPage(rows, pageSize);
        if (last) {
            res.close();
            if (qr.isAllClosed()) {
                nodeRess.remove(qr.qryReqId, qr);
            }
        }
        try {
            boolean loc = node.isLocal();
            GridQueryNextPageResponse msg = new GridQueryNextPageResponse(qr.qryReqId, qry, page, page == 0 ? res.rowCount : -1, res.cols, loc ? null : GridH2ValueMessageFactory.toMessages(rows, new ArrayList<Message>(res.cols)), loc ? rows : null);
            if (loc) {
                this.h2.reduceQueryExecutor().onMessage(this.ctx.localNodeId(), msg);
            } else {
                this.ctx.io().send(node, GridTopic.TOPIC_QUERY, (Message)msg, (byte)2);
            }
        }
        catch (IgniteCheckedException e) {
            this.log.error("Failed to send message.", (Throwable)e);
            throw new IgniteException((Throwable)e);
        }
    }

    private void sendRetry(ClusterNode node, long reqId) throws IgniteCheckedException {
        boolean loc = node.isLocal();
        GridQueryNextPageResponse msg = new GridQueryNextPageResponse(reqId, 0, 0, 0, 1, loc ? null : Collections.emptyList(), loc ? Collections.emptyList() : null);
        msg.retry(this.h2.readyTopologyVersion());
        if (loc) {
            this.h2.reduceQueryExecutor().onMessage(this.ctx.localNodeId(), msg);
        } else {
            this.ctx.io().send(node, GridTopic.TOPIC_QUERY, (Message)msg, (byte)2);
        }
    }

    public void onCacheStop(String cacheName) {
        for (T2 grpKey : this.reservations.keySet()) {
            if (!F.eq((Object)grpKey.get1(), (Object)cacheName)) continue;
            this.reservations.remove(grpKey);
        }
    }

    static {
        try {
            RESULT_FIELD = JdbcResultSet.class.getDeclaredField("result");
            RESULT_FIELD.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException("Check H2 version in classpath.", e);
        }
    }

    private static class ReplicatedReservation
    implements GridReservable {
        static final ReplicatedReservation INSTANCE = new ReplicatedReservation();

        private ReplicatedReservation() {
        }

        public boolean reserve() {
            throw new IllegalStateException();
        }

        public void release() {
            throw new IllegalStateException();
        }
    }

    private class QueryResult
    implements AutoCloseable {
        private final ResultInterface res;
        private final ResultSet rs;
        private final GridCacheContext<?, ?> cctx;
        private final GridCacheSqlQuery qry;
        private final UUID qrySrcNodeId;
        private final int cols;
        private int page;
        private final int rowCount;
        private volatile boolean closed;

        private QueryResult(ResultSet rs, GridCacheContext<?, ?> cctx, UUID qrySrcNodeId, GridCacheSqlQuery qry) {
            this.rs = rs;
            this.cctx = cctx;
            this.qry = qry;
            this.qrySrcNodeId = qrySrcNodeId;
            try {
                this.res = (ResultInterface)RESULT_FIELD.get(rs);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
            this.rowCount = this.res.getRowCount();
            this.cols = this.res.getVisibleColumnCount();
        }

        synchronized boolean fetchNextPage(List<Value[]> rows, int pageSize) {
            if (this.closed) {
                return true;
            }
            boolean readEvt = this.cctx.gridEvents().isRecordable(97);
            ++this.page;
            for (int i = 0; i < pageSize; ++i) {
                if (!this.res.next()) {
                    return true;
                }
                Value[] row = this.res.currentRow();
                assert (row != null);
                if (readEvt) {
                    this.cctx.gridEvents().record((Event)new CacheQueryReadEvent(this.cctx.localNode(), "SQL fields query result set row read.", 97, CacheQueryType.SQL.name(), this.cctx.namex(), null, this.qry.query(), null, null, this.qry.parameters(), this.qrySrcNodeId, null, null, null, null, this.row(row)));
                }
                rows.add(this.res.currentRow());
            }
            return false;
        }

        private List<?> row(Value[] row) {
            ArrayList<Object> res = new ArrayList<Object>(row.length);
            for (Value v : row) {
                res.add(v.getObject());
            }
            return res;
        }

        @Override
        public synchronized void close() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            U.close((AutoCloseable)this.rs, (IgniteLogger)GridMapQueryExecutor.this.log);
        }
    }

    private class QueryResults {
        private final long qryReqId;
        private final AtomicReferenceArray<QueryResult> results;
        private final GridCacheContext<?, ?> cctx;
        private volatile boolean canceled;

        private QueryResults(long qryReqId, int qrys, GridCacheContext<?, ?> cctx) {
            this.qryReqId = qryReqId;
            this.cctx = cctx;
            this.results = new AtomicReferenceArray(qrys);
        }

        QueryResult result(int qry) {
            return this.results.get(qry);
        }

        void addResult(int qry, GridCacheSqlQuery q, UUID qrySrcNodeId, ResultSet rs) {
            if (!this.results.compareAndSet(qry, null, new QueryResult(rs, this.cctx, qrySrcNodeId, q))) {
                throw new IllegalStateException();
            }
        }

        boolean isAllClosed() {
            for (int i = 0; i < this.results.length(); ++i) {
                QueryResult res = this.results.get(i);
                if (res != null && res.closed) continue;
                return false;
            }
            return true;
        }

        void cancel() {
            if (this.canceled) {
                return;
            }
            this.canceled = true;
            for (int i = 0; i < this.results.length(); ++i) {
                QueryResult res = this.results.get(i);
                if (res == null) continue;
                res.close();
            }
        }
    }
}

