/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.sql;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.processors.cache.query.GridCacheSqlQuery;
import org.apache.ignite.internal.processors.cache.query.GridCacheTwoStepQuery;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlAggregateFunction;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlAlias;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlColumn;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlElement;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlFunction;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlFunctionType;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlJoin;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlOperation;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlOperationType;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlParameter;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlPlaceholder;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlQuery;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlQueryParser;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlSelect;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlSortColumn;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlSubquery;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlTable;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlType;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlUnion;
import org.h2.jdbc.JdbcPreparedStatement;
import org.h2.util.IntArray;
import org.jetbrains.annotations.Nullable;

public class GridSqlQuerySplitter {
    private static final String TABLE_SCHEMA = "PUBLIC";
    private static final String TABLE_PREFIX = "__T";
    private static final String COLUMN_PREFIX = "__C";
    private static final String HAVING_COLUMN = "__H";

    public static GridSqlTable table(int idx) {
        return new GridSqlTable(TABLE_SCHEMA, TABLE_PREFIX + idx);
    }

    private static String columnName(int idx) {
        return COLUMN_PREFIX + idx;
    }

    private static GridSqlSelect leftest(GridSqlQuery qry) {
        if (qry instanceof GridSqlUnion) {
            return GridSqlQuerySplitter.leftest(((GridSqlUnion)qry).left());
        }
        return (GridSqlSelect)qry;
    }

    private static GridSqlSelect wrapUnion(GridSqlQuery qry) {
        if (qry instanceof GridSqlSelect) {
            return (GridSqlSelect)qry;
        }
        GridSqlSelect wrapQry = new GridSqlSelect().from(new GridSqlSubquery(qry));
        wrapQry.explain(qry.explain());
        qry.explain(false);
        GridSqlSelect left = GridSqlQuerySplitter.leftest(qry);
        int c = 0;
        for (GridSqlElement expr : left.columns(true)) {
            String colName;
            GridSqlType type = expr.resultType();
            if (expr instanceof GridSqlAlias) {
                colName = ((GridSqlAlias)expr).alias();
            } else if (expr instanceof GridSqlColumn) {
                colName = ((GridSqlColumn)expr).columnName();
            } else {
                colName = GridSqlQuerySplitter.columnName(c);
                expr = GridSqlQuerySplitter.alias(colName, expr);
                left.setColumn(c, expr);
            }
            GridSqlColumn col = GridSqlQuerySplitter.column(colName);
            col.resultType(type);
            wrapQry.addColumn(col, true);
            ++c;
        }
        if (!qry.sort().isEmpty()) {
            for (GridSqlSortColumn col : qry.sort()) {
                wrapQry.addSort(col);
            }
        }
        return wrapQry;
    }

    public static GridCacheTwoStepQuery split(JdbcPreparedStatement stmt, Object[] params, boolean collocated, IgniteH2Indexing igniteH2Indexing) {
        int i;
        if (params == null) {
            params = GridCacheSqlQuery.EMPTY_PARAMS;
        }
        HashSet<String> schemas = new HashSet<String>();
        GridSqlSelect mapQry = GridSqlQuerySplitter.wrapUnion(GridSqlQuerySplitter.collectAllSpaces(GridSqlQueryParser.parse(stmt), schemas));
        boolean explain = mapQry.explain();
        mapQry.explain(false);
        GridSqlSelect rdcQry = new GridSqlSelect().from(GridSqlQuerySplitter.table(0));
        ArrayList<GridSqlElement> mapExps = new ArrayList<GridSqlElement>(mapQry.allColumns());
        mapExps.addAll(mapQry.columns(false));
        int visibleCols = mapQry.visibleColumns();
        int havingCol = mapQry.havingColumn();
        ArrayList<GridSqlElement> rdcExps = new ArrayList<GridSqlElement>(visibleCols);
        HashSet<String> colNames = new HashSet<String>();
        boolean aggregateFound = false;
        int len = mapExps.size();
        for (int i2 = 0; i2 < len; ++i2) {
            aggregateFound |= GridSqlQuerySplitter.splitSelectExpression(mapExps, rdcExps, colNames, i2, collocated, i2 == havingCol);
        }
        mapQry.clearColumns();
        for (GridSqlElement exp : mapExps) {
            mapQry.addColumn(exp, true);
        }
        for (i = 0; i < visibleCols; ++i) {
            rdcQry.addColumn((GridSqlElement)rdcExps.get(i), true);
        }
        for (i = visibleCols; i < rdcExps.size(); ++i) {
            rdcQry.addColumn((GridSqlElement)rdcExps.get(i), false);
        }
        for (i = rdcExps.size(); i < mapExps.size(); ++i) {
            rdcQry.addColumn(GridSqlQuerySplitter.column(((GridSqlAlias)mapExps.get(i)).alias()), false);
        }
        if (mapQry.groupColumns() != null && !collocated) {
            rdcQry.groupColumns(mapQry.groupColumns());
        }
        if (havingCol >= 0 && !collocated) {
            for (i = visibleCols; i < rdcQry.allColumns(); ++i) {
                GridSqlElement c = rdcQry.column(i);
                if (!(c instanceof GridSqlAlias) || !HAVING_COLUMN.equals(((GridSqlAlias)c).alias())) continue;
                rdcQry.havingColumn(i);
                break;
            }
            mapQry.havingColumn(-1);
        }
        if (!mapQry.sort().isEmpty()) {
            for (GridSqlSortColumn sortCol : mapQry.sort()) {
                rdcQry.addSort(sortCol);
            }
            if (aggregateFound) {
                mapQry.clearSort();
            }
        }
        if (mapQry.limit() != null) {
            rdcQry.limit(mapQry.limit());
            if (aggregateFound) {
                mapQry.limit(null);
            }
        }
        if (mapQry.offset() != null) {
            rdcQry.offset(mapQry.offset());
            if (mapQry.limit() != null) {
                mapQry.limit(GridSqlQuerySplitter.op(GridSqlOperationType.PLUS, mapQry.offset(), mapQry.limit()));
            }
            mapQry.offset(null);
        }
        if (mapQry.distinct()) {
            mapQry.distinct(!aggregateFound && mapQry.groupColumns() == null && mapQry.havingColumn() < 0);
            rdcQry.distinct(true);
        }
        IntArray paramIdxs = new IntArray(params.length);
        GridCacheSqlQuery rdc = new GridCacheSqlQuery(rdcQry.getSQL(), GridSqlQuerySplitter.findParams(rdcQry, params, new ArrayList<Object>(), paramIdxs).toArray());
        rdc.parameterIndexes(GridSqlQuerySplitter.toIntArray(paramIdxs));
        paramIdxs = new IntArray(params.length);
        GridCacheSqlQuery map = new GridCacheSqlQuery(mapQry.getSQL(), GridSqlQuerySplitter.findParams(mapQry, params, new ArrayList<Object>(params.length), paramIdxs).toArray()).columns(GridSqlQuerySplitter.collectColumns(mapExps));
        map.parameterIndexes(GridSqlQuerySplitter.toIntArray(paramIdxs));
        HashSet<String> spaces = new HashSet<String>(schemas.size());
        for (String schema : schemas) {
            spaces.add(igniteH2Indexing.space(schema));
        }
        GridCacheTwoStepQuery res = new GridCacheTwoStepQuery(spaces, rdc, rdcQry.simpleQuery()).addMapQuery(map);
        res.explain(explain);
        return res;
    }

    private static int[] toIntArray(IntArray arr) {
        int[] res = new int[arr.size()];
        arr.toArray(res);
        return res;
    }

    private static LinkedHashMap<String, ?> collectColumns(List<GridSqlElement> cols) {
        LinkedHashMap<String, GridSqlType> res = new LinkedHashMap<String, GridSqlType>(cols.size(), 1.0f, false);
        for (int i = 0; i < cols.size(); ++i) {
            GridSqlElement col = cols.get(i);
            GridSqlType t = col.resultType();
            if (t == null) {
                throw new NullPointerException("Column type.");
            }
            if (t == GridSqlType.UNKNOWN) {
                throw new IllegalStateException("Unknown type: " + col);
            }
            String alias = col instanceof GridSqlAlias ? ((GridSqlAlias)col).alias() : GridSqlQuerySplitter.columnName(i);
            if (res.put(alias, t) == null) continue;
            throw new IllegalStateException("Alias already exists: " + alias);
        }
        return res;
    }

    private static GridSqlQuery collectAllSpaces(GridSqlQuery qry, Set<String> schemas) {
        if (qry instanceof GridSqlUnion) {
            GridSqlUnion union = (GridSqlUnion)qry;
            GridSqlQuerySplitter.collectAllSpaces(union.left(), schemas);
            GridSqlQuerySplitter.collectAllSpaces(union.right(), schemas);
        } else {
            GridSqlSelect select = (GridSqlSelect)qry;
            GridSqlQuerySplitter.collectAllSpacesInFrom(select.from(), schemas);
            for (GridSqlElement el : select.columns(false)) {
                GridSqlQuerySplitter.collectAllSpacesInSubqueries(el, schemas);
            }
            GridSqlQuerySplitter.collectAllSpacesInSubqueries(select.where(), schemas);
        }
        return qry;
    }

    private static void collectAllSpacesInFrom(GridSqlElement from, Set<String> schemas) {
        assert (from != null);
        if (from instanceof GridSqlJoin) {
            GridSqlQuerySplitter.collectAllSpacesInFrom(from.child(0), schemas);
            GridSqlQuerySplitter.collectAllSpacesInFrom(from.child(1), schemas);
        } else if (from instanceof GridSqlTable) {
            String schema = ((GridSqlTable)from).schema();
            if (schema != null) {
                schemas.add(schema);
            }
        } else if (from instanceof GridSqlSubquery) {
            GridSqlQuerySplitter.collectAllSpaces(((GridSqlSubquery)from).select(), schemas);
        } else if (from instanceof GridSqlAlias) {
            GridSqlQuerySplitter.collectAllSpacesInFrom(from.child(), schemas);
        } else if (!(from instanceof GridSqlFunction)) {
            throw new IllegalStateException(from.getClass().getName() + " : " + from.getSQL());
        }
    }

    private static void collectAllSpacesInSubqueries(GridSqlElement el, Set<String> schemas) {
        if (el instanceof GridSqlAlias) {
            el = el.child();
        }
        if (el instanceof GridSqlOperation || el instanceof GridSqlFunction) {
            for (GridSqlElement child : el) {
                GridSqlQuerySplitter.collectAllSpacesInSubqueries(child, schemas);
            }
        } else if (el instanceof GridSqlSubquery) {
            GridSqlQuerySplitter.collectAllSpaces(((GridSqlSubquery)el).select(), schemas);
        }
    }

    private static List<Object> findParams(GridSqlQuery qry, Object[] params, ArrayList<Object> target, IntArray paramIdxs) {
        if (qry instanceof GridSqlSelect) {
            return GridSqlQuerySplitter.findParams((GridSqlSelect)qry, params, target, paramIdxs);
        }
        GridSqlUnion union = (GridSqlUnion)qry;
        GridSqlQuerySplitter.findParams(union.left(), params, target, paramIdxs);
        GridSqlQuerySplitter.findParams(union.right(), params, target, paramIdxs);
        GridSqlQuerySplitter.findParams(qry.limit(), params, target, paramIdxs);
        GridSqlQuerySplitter.findParams(qry.offset(), params, target, paramIdxs);
        return target;
    }

    private static List<Object> findParams(GridSqlSelect qry, Object[] params, ArrayList<Object> target, IntArray paramIdxs) {
        if (params.length == 0) {
            return target;
        }
        for (GridSqlElement el : qry.columns(false)) {
            GridSqlQuerySplitter.findParams(el, params, target, paramIdxs);
        }
        GridSqlQuerySplitter.findParams(qry.from(), params, target, paramIdxs);
        GridSqlQuerySplitter.findParams(qry.where(), params, target, paramIdxs);
        GridSqlQuerySplitter.findParams(qry.limit(), params, target, paramIdxs);
        GridSqlQuerySplitter.findParams(qry.offset(), params, target, paramIdxs);
        return target;
    }

    private static void findParams(@Nullable GridSqlElement el, Object[] params, ArrayList<Object> target, IntArray paramIdxs) {
        if (el == null) {
            return;
        }
        if (el instanceof GridSqlParameter) {
            int idx = ((GridSqlParameter)el).index();
            while (target.size() < idx) {
                target.add(null);
            }
            if (params.length <= idx) {
                throw new IgniteException("Invalid number of query parameters. Cannot find " + idx + " parameter.");
            }
            Object param = params[idx];
            if (idx == target.size()) {
                target.add(param);
            } else {
                target.set(idx, param);
            }
            paramIdxs.add(idx);
        } else if (el instanceof GridSqlSubquery) {
            GridSqlQuerySplitter.findParams(((GridSqlSubquery)el).select(), params, target, paramIdxs);
        } else {
            for (GridSqlElement child : el) {
                GridSqlQuerySplitter.findParams(child, params, target, paramIdxs);
            }
        }
    }

    private static boolean splitSelectExpression(List<GridSqlElement> mapSelect, List<GridSqlElement> rdcSelect, Set<String> colNames, int idx, boolean collocated, boolean isHaving) {
        GridSqlElement el = mapSelect.get(idx);
        GridSqlAlias alias = null;
        boolean aggregateFound = false;
        if (el instanceof GridSqlAlias) {
            alias = (GridSqlAlias)el;
            el = alias.child();
        }
        if (!collocated && GridSqlQuerySplitter.hasAggregates(el)) {
            aggregateFound = true;
            if (alias == null) {
                alias = GridSqlQuerySplitter.alias(isHaving ? HAVING_COLUMN : GridSqlQuerySplitter.columnName(idx), el);
            }
            GridSqlQuerySplitter.splitAggregates(alias, 0, mapSelect, idx, true);
            GridSqlQuerySplitter.set(rdcSelect, idx, alias);
        } else {
            String mapColAlias;
            String string = mapColAlias = isHaving ? HAVING_COLUMN : GridSqlQuerySplitter.columnName(idx);
            String rdcColAlias = alias == null ? (el instanceof GridSqlColumn ? ((GridSqlColumn)el).columnName() : mapColAlias) : alias.alias();
            mapSelect.set(idx, GridSqlQuerySplitter.alias(mapColAlias, el));
            GridSqlElement rdcEl = GridSqlQuerySplitter.column(mapColAlias);
            if (colNames.add(rdcColAlias)) {
                rdcEl = GridSqlQuerySplitter.alias(rdcColAlias, rdcEl);
            }
            GridSqlQuerySplitter.set(rdcSelect, idx, rdcEl);
        }
        return aggregateFound;
    }

    private static <Z> void set(List<Z> list, int idx, Z item) {
        assert (list.size() == idx);
        list.add(item);
    }

    private static boolean hasAggregates(GridSqlElement el) {
        if (el instanceof GridSqlAggregateFunction) {
            return true;
        }
        for (GridSqlElement child : el) {
            if (!GridSqlQuerySplitter.hasAggregates(child)) continue;
            return true;
        }
        return false;
    }

    private static boolean splitAggregates(GridSqlElement parentExpr, int childIdx, List<GridSqlElement> mapSelect, int exprIdx, boolean first) {
        Object el = parentExpr.child(childIdx);
        if (el instanceof GridSqlAggregateFunction) {
            GridSqlQuerySplitter.splitAggregate(parentExpr, childIdx, mapSelect, exprIdx, first);
            return true;
        }
        for (int i = 0; i < ((GridSqlElement)el).size(); ++i) {
            if (!GridSqlQuerySplitter.splitAggregates(el, i, mapSelect, exprIdx, first)) continue;
            first = false;
        }
        return !first;
    }

    private static void splitAggregate(GridSqlElement parentExpr, int aggIdx, List<GridSqlElement> mapSelect, int exprIdx, boolean first) {
        GridSqlElement rdcAgg;
        GridSqlElement mapAgg;
        GridSqlAggregateFunction agg = (GridSqlAggregateFunction)parentExpr.child(aggIdx);
        assert (agg.resultType() != null);
        GridSqlAlias mapAggAlias = GridSqlQuerySplitter.alias(GridSqlQuerySplitter.columnName(first ? exprIdx : mapSelect.size()), GridSqlPlaceholder.EMPTY);
        if (first) {
            mapSelect.set(exprIdx, mapAggAlias);
        } else {
            mapSelect.add(mapAggAlias);
        }
        switch (agg.type()) {
            case AVG: {
                GridSqlElement cntMapAgg = GridSqlQuerySplitter.aggregate(agg.distinct(), GridSqlFunctionType.COUNT).resultType(GridSqlType.BIGINT).addChild((GridSqlElement)agg.child());
                String cntMapAggAlias = GridSqlQuerySplitter.columnName(mapSelect.size());
                cntMapAgg = GridSqlQuerySplitter.alias(cntMapAggAlias, cntMapAgg);
                mapSelect.add(cntMapAgg);
                mapAgg = GridSqlQuerySplitter.aggregate(agg.distinct(), GridSqlFunctionType.AVG).resultType(GridSqlType.DOUBLE).addChild(GridSqlQuerySplitter.function(GridSqlFunctionType.CAST).resultType(GridSqlType.DOUBLE).addChild((GridSqlElement)agg.child()));
                GridSqlElement sumUpRdc = GridSqlQuerySplitter.aggregate(false, GridSqlFunctionType.SUM).addChild(GridSqlQuerySplitter.op(GridSqlOperationType.MULTIPLY, GridSqlQuerySplitter.column(mapAggAlias.alias()), GridSqlQuerySplitter.column(cntMapAggAlias)));
                GridSqlElement sumDownRdc = GridSqlQuerySplitter.aggregate(false, GridSqlFunctionType.SUM).addChild(GridSqlQuerySplitter.column(cntMapAggAlias));
                rdcAgg = GridSqlQuerySplitter.op(GridSqlOperationType.DIVIDE, sumUpRdc, sumDownRdc);
                break;
            }
            case SUM: 
            case MAX: 
            case MIN: {
                mapAgg = GridSqlQuerySplitter.aggregate(agg.distinct(), agg.type()).resultType(agg.resultType()).addChild((GridSqlElement)agg.child());
                rdcAgg = GridSqlQuerySplitter.aggregate(agg.distinct(), agg.type()).addChild(GridSqlQuerySplitter.column(mapAggAlias.alias()));
                break;
            }
            case COUNT_ALL: 
            case COUNT: {
                mapAgg = GridSqlQuerySplitter.aggregate(agg.distinct(), agg.type()).resultType(GridSqlType.BIGINT);
                if (agg.type() == GridSqlFunctionType.COUNT) {
                    mapAgg.addChild((GridSqlElement)agg.child());
                }
                rdcAgg = GridSqlQuerySplitter.aggregate(false, GridSqlFunctionType.SUM).addChild(GridSqlQuerySplitter.column(mapAggAlias.alias()));
                rdcAgg = GridSqlQuerySplitter.function(GridSqlFunctionType.CAST).resultType(GridSqlType.BIGINT).addChild(rdcAgg);
                break;
            }
            default: {
                throw new IgniteException("Unsupported aggregate: " + (Object)((Object)agg.type()));
            }
        }
        assert (!(mapAgg instanceof GridSqlAlias));
        assert (mapAgg.resultType() != null);
        mapAggAlias.child(0, mapAgg);
        mapAggAlias.resultType(mapAgg.resultType());
        parentExpr.child(aggIdx, rdcAgg);
    }

    private static GridSqlAggregateFunction aggregate(boolean distinct, GridSqlFunctionType type) {
        return new GridSqlAggregateFunction(distinct, type);
    }

    private static GridSqlColumn column(String name) {
        return new GridSqlColumn(null, name, name);
    }

    private static GridSqlAlias alias(String alias, GridSqlElement child) {
        GridSqlAlias res = new GridSqlAlias(alias, child);
        res.resultType(child.resultType());
        return res;
    }

    private static GridSqlOperation op(GridSqlOperationType type, GridSqlElement left, GridSqlElement right) {
        return new GridSqlOperation(type, left, right);
    }

    private static GridSqlFunction function(GridSqlFunctionType type) {
        return new GridSqlFunction(type);
    }
}

