/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.sql;

import java.util.ArrayList;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlElement;
import org.h2.util.StatementBuilder;
import org.h2.util.StringUtils;
import org.jetbrains.annotations.Nullable;

public class GridSqlJoin
extends GridSqlElement {
    private boolean leftOuter;

    public GridSqlJoin(GridSqlElement leftTbl, GridSqlElement rightTbl, boolean leftOuter, @Nullable GridSqlElement on) {
        super(new ArrayList<GridSqlElement>(on == null ? 2 : 3));
        this.addChild(leftTbl);
        this.addChild(rightTbl);
        if (on != null) {
            this.addChild(on);
        }
        this.leftOuter = leftOuter;
    }

    public GridSqlElement leftTable() {
        return this.child(0);
    }

    public GridSqlElement rightTable() {
        return this.child(1);
    }

    @Nullable
    public GridSqlElement on() {
        return this.size() < 3 ? null : (GridSqlElement)this.child(2);
    }

    @Override
    public String getSQL() {
        StatementBuilder buff = new StatementBuilder();
        buff.append(this.leftTable().getSQL());
        buff.append(this.leftOuter ? " \n LEFT OUTER JOIN " : " \n INNER JOIN ");
        buff.append(this.rightTable().getSQL());
        GridSqlElement on = this.on();
        if (on != null) {
            buff.append(" \n ON ").append(StringUtils.unEnclose((String)on.getSQL()));
        }
        return buff.toString();
    }
}

