/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.sql;

import java.util.Iterator;
import java.util.List;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlType;

public abstract class GridSqlElement
implements Iterable<GridSqlElement> {
    protected final List<GridSqlElement> children;
    private GridSqlType resultType;

    protected GridSqlElement(List<GridSqlElement> children) {
        assert (children != null);
        this.children = children;
    }

    public GridSqlType resultType() {
        return this.resultType;
    }

    public GridSqlElement resultType(GridSqlType type) {
        this.resultType = type;
        return this;
    }

    public abstract String getSQL();

    public GridSqlElement addChild(GridSqlElement expr) {
        if (expr == null) {
            throw new NullPointerException();
        }
        this.children.add(expr);
        return this;
    }

    public <E extends GridSqlElement> E child() {
        return this.child(0);
    }

    public <E extends GridSqlElement> E child(int idx) {
        return (E)this.children.get(idx);
    }

    public void child(int idx, GridSqlElement child) {
        if (child == null) {
            throw new NullPointerException();
        }
        this.children.set(idx, child);
    }

    public int size() {
        return this.children.size();
    }

    @Override
    public Iterator<GridSqlElement> iterator() {
        return this.children.iterator();
    }

    public String toString() {
        return this.getSQL();
    }
}

