/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.opt;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.binary.BinaryEnumObjectImpl;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheObjectContext;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.h2.message.DbException;
import org.h2.util.Utils;
import org.h2.value.CompareMode;
import org.h2.value.Value;

public class GridH2ValueCacheObject
extends Value {
    private CacheObject obj;
    private GridCacheContext<?, ?> cctx;

    public GridH2ValueCacheObject(GridCacheContext<?, ?> cctx, CacheObject obj) {
        assert (obj != null);
        this.obj = obj;
        this.cctx = cctx;
    }

    public CacheObject getCacheObject() {
        return this.obj;
    }

    public GridCacheContext<?, ?> getCacheContext() {
        return this.cctx;
    }

    public String getSQL() {
        throw new UnsupportedOperationException();
    }

    public int getType() {
        return 19;
    }

    public long getPrecision() {
        return 0L;
    }

    public int getDisplaySize() {
        return 64;
    }

    public String getString() {
        return this.getObject().toString();
    }

    public byte[] getBytes() {
        return Utils.cloneByteArray((byte[])this.getBytesNoCopy());
    }

    private CacheObjectContext objectContext() {
        return this.cctx == null ? null : this.cctx.cacheObjectContext();
    }

    public byte[] getBytesNoCopy() {
        if (this.obj.cacheObjectType() == 1) {
            try {
                return this.obj.valueBytes(this.objectContext());
            }
            catch (IgniteCheckedException e) {
                throw DbException.convert((Throwable)e);
            }
        }
        return Utils.serialize((Object)this.obj, null);
    }

    public Object getObject() {
        return this.obj.isPlatformType() ? this.obj.value(this.objectContext(), false) : this.obj;
    }

    public void set(PreparedStatement prep, int parameterIndex) throws SQLException {
        prep.setObject(parameterIndex, this.getObject(), 2000);
    }

    protected int compareSecure(Value v, CompareMode mode) {
        int h2;
        BinaryEnumObjectImpl bo1;
        Object o1 = this.getObject();
        Object o2 = v.getObject();
        boolean o1Comparable = o1 instanceof Comparable;
        boolean o2Comparable = o2 instanceof Comparable;
        if (o1Comparable && o2Comparable && Utils.haveCommonComparableSuperclass(o1.getClass(), o2.getClass())) {
            Comparable c1 = (Comparable)o1;
            return c1.compareTo(o2);
        }
        if (o1 instanceof BinaryEnumObjectImpl && o2 instanceof Enum && (bo1 = (BinaryEnumObjectImpl)o1).isTypeEquals(o2.getClass())) {
            return Integer.compare(bo1.enumOrdinal(), ((Enum)o2).ordinal());
        }
        if (o1.getClass() != o2.getClass()) {
            if (o1Comparable != o2Comparable) {
                return o1Comparable ? -1 : 1;
            }
            return o1.getClass().getName().compareTo(o2.getClass().getName());
        }
        int h1 = this.hashCode();
        if (h1 == (h2 = v.hashCode())) {
            if (o1.equals(o2)) {
                return 0;
            }
            return Utils.compareNotNullSigned((byte[])this.getBytesNoCopy(), (byte[])v.getBytesNoCopy());
        }
        return h1 > h2 ? 1 : -1;
    }

    public int hashCode() {
        return this.getObject().hashCode();
    }

    public boolean equals(Object other) {
        if (!(other instanceof Value)) {
            return false;
        }
        Value otherVal = (Value)other;
        return otherVal.getType() == 19 && this.getObject().equals(otherVal.getObject());
    }

    public Value convertPrecision(long precision, boolean force) {
        return this;
    }

    public int getMemory() {
        return 0;
    }
}

