/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.opt;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2AbstractKeyValueRow;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2IndexBase;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Row;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2RowDescriptor;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2TreeIndex;
import org.apache.ignite.internal.util.offheap.unsafe.GridUnsafeMemory;
import org.h2.api.TableEngine;
import org.h2.command.ddl.CreateTableData;
import org.h2.engine.Database;
import org.h2.engine.DbObject;
import org.h2.engine.Session;
import org.h2.index.Cursor;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.result.SortOrder;
import org.h2.schema.Schema;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.table.TableBase;
import org.h2.table.TableFilter;
import org.h2.value.Value;
import org.jetbrains.annotations.Nullable;
import org.jsr166.ConcurrentHashMap8;
import org.jsr166.LongAdder8;

public class GridH2Table
extends TableBase {
    private final String spaceName;
    private final GridH2RowDescriptor desc;
    private final ArrayList<Index> idxs;
    private final ReadWriteLock lock;
    private final Set<Session> sessions = Collections.newSetFromMap(new ConcurrentHashMap8());
    private volatile Object[] actualSnapshot;
    private final LongAdder8 size = new LongAdder8();
    private final boolean snapshotEnabled;

    public GridH2Table(CreateTableData createTblData, @Nullable GridH2RowDescriptor desc, IndexesFactory idxsFactory, @Nullable String spaceName) {
        super(createTblData);
        assert (idxsFactory != null);
        this.desc = desc;
        this.spaceName = spaceName;
        this.idxs = idxsFactory.createIndexes(this);
        assert (this.idxs != null);
        assert (this.idxs.size() >= 1);
        this.lock = new ReentrantReadWriteLock();
        this.idxs.add(0, new ScanIndex(this.index(0)));
        this.snapshotEnabled = desc == null || desc.snapshotableIndex();
    }

    public long getDiskSpaceUsed() {
        return 0L;
    }

    public GridH2RowDescriptor rowDescriptor() {
        return this.desc;
    }

    public boolean onSwap(CacheObject key) throws IgniteCheckedException {
        return this.onSwapUnswap(key, null);
    }

    public boolean onUnswap(CacheObject key, CacheObject val) throws IgniteCheckedException {
        assert (val != null) : "Key=" + key;
        return this.onSwapUnswap(key, val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean onSwapUnswap(CacheObject key, @Nullable CacheObject val) throws IgniteCheckedException {
        assert (key != null);
        GridH2TreeIndex pk = this.pk();
        assert (this.desc != null);
        GridH2Row searchRow = this.desc.createRow(key, null, 0L);
        GridUnsafeMemory mem = this.desc.memory();
        this.readLock();
        if (mem != null) {
            this.desc.guard().begin();
        }
        try {
            GridH2AbstractKeyValueRow row = (GridH2AbstractKeyValueRow)pk.findOne(searchRow);
            if (row == null) {
                boolean bl = false;
                return bl;
            }
            if (val == null) {
                row.onSwap();
            } else {
                row.onUnswap(val, false);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.readUnlock();
            if (mem != null) {
                this.desc.guard().end();
            }
        }
    }

    @Nullable
    String spaceName() {
        return this.spaceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock(@Nullable Session ses, boolean exclusive, boolean force) {
        Object[] snapshot;
        if (ses != null) {
            if (!this.sessions.add(ses)) {
                return;
            }
            Session session = ses;
            synchronized (session) {
                ses.addLock((Table)this);
            }
        }
        if (!this.snapshotEnabled) {
            return;
        }
        long waitTime = 100L;
        while (true) {
            if ((snapshot = this.actualSnapshot) != null) {
                int len = this.idxs.size();
                for (int i = 1; i < len; ++i) {
                    this.index(i).takeSnapshot(snapshot[i - 1]);
                }
                return;
            }
            try {
                if (this.lock.writeLock().tryLock(waitTime, TimeUnit.MILLISECONDS)) {
                    break;
                }
            }
            catch (InterruptedException e) {
                throw new IgniteException("Thread got interrupted while trying to acquire index lock.", (Throwable)e);
            }
            waitTime *= 2L;
        }
        boolean snapshoted = false;
        try {
            snapshot = this.actualSnapshot;
            if (snapshot == null) {
                snapshot = this.takeIndexesSnapshot();
                if (this.desc == null || this.desc.memory() == null) {
                    this.actualSnapshot = snapshot;
                }
                snapshoted = true;
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        if (!snapshoted) {
            int len = this.idxs.size();
            for (int i = 1; i < len; ++i) {
                this.index(i).takeSnapshot(snapshot[i - 1]);
            }
        }
    }

    private Object[] takeIndexesSnapshot() {
        int len = this.idxs.size();
        Object[] snapshot = new ConcurrentNavigableMap[len - 1];
        for (int i = 1; i < len; ++i) {
            Object s;
            snapshot[i - 1] = s = this.index(i).takeSnapshot(null);
        }
        return snapshot;
    }

    public void close(Session ses) {
        assert (!this.sessions.contains(ses));
    }

    public void unlock(@Nullable Session ses) {
        if (ses != null) {
            boolean res = this.sessions.remove(ses);
            assert (res);
        }
        int len = this.idxs.size();
        for (int i = 1; i < len; ++i) {
            this.index(i).releaseSnapshot();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.writeLock();
        try {
            int len = this.idxs.size();
            for (int i = 1; i < len; ++i) {
                this.index(i).close(null);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    public boolean update(CacheObject key, CacheObject val, long expirationTime, boolean rmv) throws IgniteCheckedException {
        assert (this.desc != null);
        GridH2Row row = this.desc.createRow(key, val, expirationTime);
        return this.doUpdate(row, rmv);
    }

    private GridH2IndexBase index(int idx) {
        return (GridH2IndexBase)this.idxs.get(idx);
    }

    private GridH2TreeIndex pk() {
        return (GridH2TreeIndex)this.idxs.get(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean doUpdate(GridH2Row row, boolean del) throws IgniteCheckedException {
        GridUnsafeMemory mem = this.desc == null ? null : this.desc.memory();
        this.readLock();
        if (mem != null) {
            this.desc.guard().begin();
        }
        try {
            GridH2Row old;
            GridH2TreeIndex pk = this.pk();
            if (!del) {
                old = pk.put(row);
                if (old instanceof GridH2AbstractKeyValueRow) {
                    GridH2AbstractKeyValueRow kvOld = (GridH2AbstractKeyValueRow)old;
                    kvOld.onUnswap(kvOld.getValue(1), true);
                } else if (old == null) {
                    this.size.increment();
                }
                int len = this.idxs.size();
                int i = 1;
                while (++i < len) {
                    GridH2IndexBase idx = this.index(i);
                    assert (!idx.getIndexType().isUnique()) : "Unique indexes are not supported.";
                    GridH2Row old2 = idx.put(row);
                    if (old2 != null) {
                        if (GridH2Table.eq((Index)pk, old2, old)) continue;
                        throw new IllegalStateException("Row conflict should never happen, unique indexes are not supported.");
                    }
                    if (old == null) continue;
                    idx.remove(old);
                }
            } else {
                Value v;
                old = pk.remove(row);
                if (old instanceof GridH2AbstractKeyValueRow && (v = row.getValue(1)) != null) {
                    ((GridH2AbstractKeyValueRow)old).onUnswap(v.getObject(), true);
                }
                if (old != null) {
                    this.size.decrement();
                    int len = this.idxs.size();
                    for (int i = 2; i < len; ++i) {
                        GridH2Row res = this.index(i).remove(old);
                        assert (GridH2Table.eq((Index)pk, res, old)) : "\n" + old + "\n" + res + "\n" + i + " -> " + this.index(i).getName();
                    }
                } else {
                    boolean bl = false;
                    return bl;
                }
            }
            this.actualSnapshot = null;
            boolean bl = true;
            return bl;
        }
        finally {
            this.readUnlock();
            if (mem != null) {
                this.desc.guard().end();
            }
        }
    }

    private static boolean eq(Index pk, SearchRow r1, SearchRow r2) {
        return r1 == r2 || r1 != null && r2 != null && pk.compareRows(r1, r2) == 0;
    }

    ArrayList<GridH2IndexBase> indexes() {
        ArrayList<GridH2IndexBase> res = new ArrayList<GridH2IndexBase>(this.idxs.size() - 1);
        int len = this.idxs.size();
        for (int i = 1; i < len; ++i) {
            res.add(this.index(i));
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebuildIndexes() {
        if (!this.snapshotEnabled) {
            return;
        }
        GridUnsafeMemory memory = this.desc == null ? null : this.desc.memory();
        this.lock.writeLock().lock();
        try {
            if (memory == null && this.actualSnapshot == null) {
                this.actualSnapshot = this.takeIndexesSnapshot();
            }
            int len = this.idxs.size();
            for (int i = 1; i < len; ++i) {
                GridH2IndexBase newIdx = this.index(i).rebuild();
                this.idxs.set(i, (Index)newIdx);
                if (i != 1) continue;
                this.idxs.set(0, new ScanIndex(newIdx));
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.lock.writeLock().unlock();
            this.actualSnapshot = null;
        }
    }

    public Index addIndex(Session ses, String s, int i, IndexColumn[] idxCols, IndexType idxType, boolean b, String s1) {
        throw DbException.getUnsupportedException((String)"addIndex");
    }

    public void removeRow(Session ses, Row row) {
        throw DbException.getUnsupportedException((String)"removeRow");
    }

    public void truncate(Session ses) {
        throw DbException.getUnsupportedException((String)"truncate");
    }

    public void addRow(Session ses, Row row) {
        throw DbException.getUnsupportedException((String)"addRow");
    }

    public void checkSupportAlter() {
        throw DbException.getUnsupportedException((String)"alter");
    }

    public String getTableType() {
        return "EXTERNAL";
    }

    public Index getScanIndex(Session ses) {
        return this.getIndexes().get(0);
    }

    public Index getUniqueIndex() {
        return this.getIndexes().get(1);
    }

    public ArrayList<Index> getIndexes() {
        return this.idxs;
    }

    public boolean isLockedExclusively() {
        return false;
    }

    public boolean isLockedExclusivelyBy(Session ses) {
        return false;
    }

    public long getMaxDataModificationId() {
        return 0L;
    }

    public boolean isDeterministic() {
        return true;
    }

    public boolean canGetRowCount() {
        return true;
    }

    public boolean canDrop() {
        return true;
    }

    public long getRowCount(@Nullable Session ses) {
        return this.getUniqueIndex().getRowCount(ses);
    }

    public long getRowCountApproximation() {
        return this.size.longValue();
    }

    public void checkRename() {
        throw DbException.getUnsupportedException((String)"rename");
    }

    public IndexColumn indexColumn(int col, int sorting) {
        IndexColumn res = new IndexColumn();
        res.column = this.getColumn(col);
        res.columnName = res.column.getName();
        res.sortType = sorting;
        return res;
    }

    private void readLock() {
        if (this.snapshotEnabled) {
            this.lock.readLock().lock();
        }
    }

    private void readUnlock() {
        if (this.snapshotEnabled) {
            this.lock.readLock().unlock();
        }
    }

    private void writeLock() {
        if (this.snapshotEnabled) {
            this.lock.writeLock().lock();
        }
    }

    private void writeUnlock() {
        if (this.snapshotEnabled) {
            this.lock.writeLock().unlock();
        }
    }

    static class ScanIndex
    implements Index {
        static final String SCAN_INDEX_NAME_SUFFIX = "__SCAN_";
        private static final IndexType TYPE = IndexType.createScan((boolean)false);
        private final GridH2IndexBase delegate;

        private ScanIndex(GridH2IndexBase delegate) {
            this.delegate = delegate;
        }

        public long getDiskSpaceUsed() {
            return 0L;
        }

        public void add(Session ses, Row row) {
            this.delegate.add(ses, row);
        }

        public boolean canFindNext() {
            return false;
        }

        public boolean canGetFirstOrLast() {
            return false;
        }

        public boolean canScan() {
            return this.delegate.canScan();
        }

        public void close(Session ses) {
            this.delegate.close(ses);
        }

        public void commit(int operation, Row row) {
        }

        public int compareRows(SearchRow rowData, SearchRow compare) {
            return this.delegate.compareRows(rowData, compare);
        }

        public Cursor find(TableFilter filter, SearchRow first, SearchRow last) {
            return this.find(filter.getSession(), first, last);
        }

        public Cursor find(Session ses, SearchRow first, SearchRow last) {
            return this.delegate.find(ses, null, null);
        }

        public Cursor findFirstOrLast(Session ses, boolean first) {
            throw DbException.getUnsupportedException((String)"SCAN");
        }

        public Cursor findNext(Session ses, SearchRow higherThan, SearchRow last) {
            throw DbException.throwInternalError();
        }

        public int getColumnIndex(Column col) {
            return -1;
        }

        public Column[] getColumns() {
            return this.delegate.getColumns();
        }

        public double getCost(Session ses, int[] masks, TableFilter tblFilter, SortOrder sortOrder) {
            return this.getRowCountApproximation() + 1000L;
        }

        public IndexColumn[] getIndexColumns() {
            return this.delegate.getIndexColumns();
        }

        public IndexType getIndexType() {
            return TYPE;
        }

        public String getPlanSQL() {
            return this.delegate.getTable().getSQL() + "." + SCAN_INDEX_NAME_SUFFIX;
        }

        public Row getRow(Session ses, long key) {
            return this.delegate.getRow(ses, key);
        }

        public long getRowCount(Session ses) {
            return this.delegate.getRowCount(ses);
        }

        public long getRowCountApproximation() {
            return this.delegate.getRowCountApproximation();
        }

        public Table getTable() {
            return this.delegate.getTable();
        }

        public boolean isRowIdIndex() {
            return this.delegate.isRowIdIndex();
        }

        public boolean needRebuild() {
            return false;
        }

        public void remove(Session ses) {
        }

        public void remove(Session ses, Row row) {
        }

        public void setSortedInsertMode(boolean sortedInsertMode) {
        }

        public void truncate(Session ses) {
        }

        public Schema getSchema() {
            return this.delegate.getSchema();
        }

        public boolean isHidden() {
            return this.delegate.isHidden();
        }

        public void checkRename() {
            throw DbException.getUnsupportedException((String)"rename");
        }

        public ArrayList<DbObject> getChildren() {
            return this.delegate.getChildren();
        }

        public String getComment() {
            return this.delegate.getComment();
        }

        public String getCreateSQL() {
            return null;
        }

        public String getCreateSQLForCopy(Table tbl, String quotedName) {
            return this.delegate.getCreateSQLForCopy(tbl, quotedName);
        }

        public Database getDatabase() {
            return this.delegate.getDatabase();
        }

        public String getDropSQL() {
            return this.delegate.getDropSQL();
        }

        public int getId() {
            return this.delegate.getId();
        }

        public String getName() {
            return this.delegate.getName() + SCAN_INDEX_NAME_SUFFIX;
        }

        public String getSQL() {
            return this.delegate.getSQL();
        }

        public int getType() {
            return this.delegate.getType();
        }

        public boolean isTemporary() {
            return this.delegate.isTemporary();
        }

        public void removeChildrenAndResources(Session ses) {
        }

        public void rename(String newName) {
            throw DbException.getUnsupportedException((String)"rename");
        }

        public void setComment(String comment) {
            throw DbException.getUnsupportedException((String)"comment");
        }

        public void setTemporary(boolean temporary) {
            throw DbException.getUnsupportedException((String)"temporary");
        }
    }

    public static interface IndexesFactory {
        public ArrayList<Index> createIndexes(GridH2Table var1);
    }

    public static class Engine
    implements TableEngine {
        private static GridH2RowDescriptor rowDesc;
        private static IndexesFactory idxsFactory;
        private static GridH2Table resTbl;
        private static String spaceName;

        public TableBase createTable(CreateTableData createTblData) {
            resTbl = new GridH2Table(createTblData, rowDesc, idxsFactory, spaceName);
            return resTbl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static synchronized GridH2Table createTable(Connection conn, String sql, @Nullable GridH2RowDescriptor desc, IndexesFactory factory, String space) throws SQLException {
            rowDesc = desc;
            idxsFactory = factory;
            spaceName = space;
            try {
                try (Statement s = conn.createStatement();){
                    s.execute(sql + " engine \"" + Engine.class.getName() + "\"");
                }
                GridH2Table gridH2Table = resTbl;
                return gridH2Table;
            }
            finally {
                resTbl = null;
                idxsFactory = null;
                rowDesc = null;
            }
        }
    }
}

