/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.opt;

import java.util.concurrent.locks.Lock;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2AbstractKeyValueRow;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2RowDescriptor;
import org.apache.ignite.internal.util.GridStripedLock;
import org.apache.ignite.internal.util.offheap.unsafe.GridUnsafeMemory;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.h2.store.Data;
import org.h2.value.Value;
import org.jetbrains.annotations.Nullable;

public class GridH2KeyValueRowOffheap
extends GridH2AbstractKeyValueRow {
    private static final GridStripedLock lock;
    private static final int OFFSET_KEY_SIZE = 4;
    private static final int OFFSET_VALUE_REF = 8;
    private static final int OFFSET_EXPIRATION = 16;
    private static final int OFFSET_KEY = 24;
    private static final int OFFSET_VALUE = 4;
    private static final Data SIZE_CALCULATOR;
    private long ptr;

    public GridH2KeyValueRowOffheap(GridH2RowDescriptor desc, long ptr) {
        super(desc);
        assert (ptr > 0L) : ptr;
        this.ptr = ptr;
    }

    public GridH2KeyValueRowOffheap(GridH2RowDescriptor desc, Object key, int keyType, @Nullable Object val, int valType, long expirationTime) throws IgniteCheckedException {
        super(desc, key, keyType, val, valType, expirationTime);
    }

    @Override
    public long expirationTime() {
        if (this.expirationTime == 0L) {
            long p = this.ptr;
            assert (p > 0L) : p;
            this.expirationTime = this.desc.memory().readLong(p + 16L);
        }
        return this.expirationTime;
    }

    @Override
    protected void cache() {
        this.desc.cache(this);
    }

    private static Lock lock(long ptr) {
        assert (ptr > 0L) : ptr;
        assert ((ptr & 7L) == 0L) : ptr;
        Lock l = lock.getLock(ptr >>> 3);
        l.lock();
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Value getOffheapValue(int col) {
        GridUnsafeMemory mem = this.desc.memory();
        long p = this.ptr;
        assert (p > 0L) : p;
        byte[] bytes = null;
        if (col == 0) {
            int size = mem.readInt(p + 4L);
            assert (size > 0) : size;
            bytes = mem.readBytes(p + 24L, size);
        } else if (col == 1) {
            Lock l = GridH2KeyValueRowOffheap.lock(p);
            this.desc.guard().begin();
            try {
                long valPtr = mem.readLongVolatile(p + 8L);
                if (valPtr == 0L) {
                    Value value = null;
                    return value;
                }
                int size = mem.readInt(valPtr);
                assert (size > 0) : size;
                bytes = mem.readBytes(valPtr + 4L, size);
            }
            finally {
                this.desc.guard().end();
                l.unlock();
            }
        } else assert (false) : col;
        Data data = Data.create(null, bytes);
        return data.readValue();
    }

    @Override
    public long pointer() {
        long p = this.ptr;
        assert (p > 0L) : p;
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void onSwap() throws IgniteCheckedException {
        Lock l = GridH2KeyValueRowOffheap.lock(this.ptr);
        try {
            long p = this.ptr + 8L;
            final GridUnsafeMemory mem = this.desc.memory();
            final long valPtr = mem.readLongVolatile(p);
            if (valPtr <= 0L) {
                throw new IllegalStateException("Already swapped: " + this.ptr);
            }
            if (!mem.casLong(p, valPtr, 0L)) {
                throw new IllegalStateException("Concurrent unswap: " + this.ptr);
            }
            this.desc.guard().finalizeLater(new Runnable(){

                @Override
                public void run() {
                    mem.release(valPtr, (long)(mem.readInt(valPtr) + 4));
                }
            });
        }
        finally {
            l.unlock();
        }
    }

    @Override
    protected synchronized Value updateWeakValue(Object valObj) throws IgniteCheckedException {
        Value val = this.peekValue(1);
        if (val != null) {
            return val;
        }
        Value upd = this.desc.wrap(valObj, this.desc.valueType());
        this.setValue(1, upd);
        this.notifyAll();
        return upd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void onUnswap(Object val, boolean beforeRmv) throws IgniteCheckedException {
        assert (val != null);
        long p = this.ptr;
        Lock l = GridH2KeyValueRowOffheap.lock(p);
        try {
            GridUnsafeMemory mem = this.desc.memory();
            if (mem.readLongVolatile(p + 8L) != 0L) {
                return;
            }
            Value v = this.peekValue(1);
            if (v == null) {
                this.setValue(1, this.desc.wrap(val, this.desc.valueType()));
                v = this.peekValue(1);
            }
            byte[] bytes = new byte[SIZE_CALCULATOR.getValueLen(v)];
            Data data = Data.create(null, (byte[])bytes);
            data.writeValue(v);
            long valPtr = mem.allocate((long)(bytes.length + 4));
            mem.writeInt(valPtr, bytes.length);
            mem.writeBytes(valPtr + 4L, bytes);
            mem.writeLongVolatile(p + 8L, valPtr);
        }
        finally {
            l.unlock();
        }
        this.notifyAll();
    }

    @Override
    protected Value syncValue(long waitTime) {
        Value v = super.syncValue(waitTime);
        if (v != null) {
            return v;
        }
        return this.getOffheapValue(1);
    }

    @Override
    public void incrementRefCount() {
        long p = this.ptr;
        GridUnsafeMemory mem = this.desc.memory();
        if (p == 0L) {
            Value key = this.peekValue(0);
            Value val = this.peekValue(1);
            assert (key != null);
            assert (val != null);
            Data data = Data.create(null, (byte[])new byte[SIZE_CALCULATOR.getValueLen(key)]);
            data.writeValue(key);
            int keySize = data.length();
            p = mem.allocate((long)(keySize + 24));
            mem.writeInt(p, 1);
            mem.writeLong(p + 16L, this.expirationTime);
            mem.writeInt(p + 4L, keySize);
            mem.writeBytes(p + 24L, data.getBytes(), 0, keySize);
            data = Data.create(null, (byte[])new byte[SIZE_CALCULATOR.getValueLen(val)]);
            data.writeValue(val);
            int valSize = data.length();
            long valPtr = mem.allocate((long)(valSize + 4));
            mem.writeInt(valPtr, valSize);
            mem.writeBytes(valPtr + 4L, data.getBytes(), 0, valSize);
            mem.writeLongVolatile(p + 8L, valPtr);
            this.ptr = p;
            this.desc.cache(this);
        } else {
            int cnt;
            do {
                cnt = mem.readIntVolatile(p);
                assert (cnt > 0) : cnt;
            } while (!mem.casInt(p, cnt, cnt + 1));
        }
    }

    @Override
    public void decrementRefCount() {
        GridUnsafeMemory mem;
        long p;
        block5: {
            int cnt;
            p = this.ptr;
            assert (p > 0L) : p;
            mem = this.desc.memory();
            do {
                cnt = mem.readIntVolatile(p);
                assert (cnt > 0) : cnt;
                if (cnt == 1) break block5;
            } while (!mem.casInt(p, cnt, cnt - 1));
            return;
        }
        this.desc.uncache(p);
        long valPtr = mem.readLongVolatile(p + 8L);
        assert (valPtr >= 0L) : valPtr;
        if (valPtr != 0L) {
            mem.release(valPtr, (long)(mem.readInt(valPtr) + 4));
        }
        mem.release(p, (long)(mem.readInt(p + 4L) + 24));
    }

    @Override
    protected void addOffheapRowId(SB sb) {
        sb.a('-').a(this.ptr);
    }

    static {
        int cpus = Runtime.getRuntime().availableProcessors();
        lock = new GridStripedLock(cpus * cpus * 8);
        SIZE_CALCULATOR = Data.create(null, null);
    }
}

