/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.opt;

import java.util.Iterator;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2AbstractKeyValueRow;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Row;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.util.lang.GridFilteredIterator;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.spi.indexing.IndexingQueryFilter;
import org.h2.engine.Session;
import org.h2.index.BaseIndex;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.value.Value;
import org.jetbrains.annotations.Nullable;

public abstract class GridH2IndexBase
extends BaseIndex {
    protected static final ThreadLocal<IndexingQueryFilter> filters = new ThreadLocal();
    protected final int keyCol;
    protected final int valCol;

    protected GridH2IndexBase(int keyCol, int valCol) {
        this.keyCol = keyCol;
        this.valCol = valCol;
    }

    public static void setFiltersForThread(IndexingQueryFilter fs) {
        filters.set(fs);
    }

    public GridH2IndexBase rebuild() throws InterruptedException {
        return this;
    }

    public abstract GridH2Row put(GridH2Row var1);

    public abstract GridH2Row remove(SearchRow var1);

    public Object takeSnapshot(@Nullable Object s) {
        return s;
    }

    public void releaseSnapshot() {
    }

    public int compareRows(SearchRow rowData, SearchRow compare) {
        if (rowData == compare) {
            return 0;
        }
        int len = this.indexColumns.length;
        for (int i = 0; i < len; ++i) {
            int index = this.columnIds[i];
            Value v1 = rowData.getValue(index);
            Value v2 = compare.getValue(index);
            if (v1 == null || v2 == null) {
                return 0;
            }
            int c = this.compareValues(v1, v2, this.indexColumns[i].sortType);
            if (c == 0) continue;
            return c;
        }
        return 0;
    }

    private int compareValues(Value a, Value b, int sortType) {
        if (a == b) {
            return 0;
        }
        int comp = this.table.compareTypeSave(a, b);
        if ((sortType & 1) != 0) {
            comp = -comp;
        }
        return comp;
    }

    protected Iterator<GridH2Row> filter(Iterator<GridH2Row> iter) {
        Object p = null;
        IndexingQueryFilter f = filters.get();
        return new FilteringIterator(iter, U.currentTimeMillis(), f);
    }

    public long getDiskSpaceUsed() {
        return 0L;
    }

    public void checkRename() {
        throw DbException.getUnsupportedException((String)"rename");
    }

    public void add(Session ses, Row row) {
        throw DbException.getUnsupportedException((String)"add");
    }

    public void remove(Session ses, Row row) {
        throw DbException.getUnsupportedException((String)"remove row");
    }

    public void remove(Session ses) {
        throw DbException.getUnsupportedException((String)"remove index");
    }

    public void truncate(Session ses) {
        throw DbException.getUnsupportedException((String)"truncate");
    }

    public boolean needRebuild() {
        return false;
    }

    protected class FilteringIterator
    extends GridFilteredIterator<GridH2Row> {
        private final IgniteBiPredicate<Object, Object> fltr;
        private final long time;
        private final boolean isValRequired;

        protected FilteringIterator(Iterator<GridH2Row> iter, long time, IndexingQueryFilter qryFilter) {
            super(iter);
            this.time = time;
            if (qryFilter != null) {
                this.fltr = qryFilter.forSpace(((GridH2Table)GridH2IndexBase.this.getTable()).spaceName());
                this.isValRequired = qryFilter.isValueRequired();
            } else {
                this.fltr = null;
                this.isValRequired = false;
            }
        }

        protected boolean accept(GridH2Row row) {
            Object val;
            if (row instanceof GridH2AbstractKeyValueRow && ((GridH2AbstractKeyValueRow)row).expirationTime() <= this.time) {
                return false;
            }
            if (this.fltr == null) {
                return true;
            }
            Object key = row.getValue(GridH2IndexBase.this.keyCol).getObject();
            Object object = val = this.isValRequired ? row.getValue(GridH2IndexBase.this.valCol).getObject() : null;
            assert (key != null);
            assert (!this.isValRequired || val != null);
            return this.fltr.apply(key, val);
        }
    }
}

