/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.cache.Cache;
import javax.cache.CacheException;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cache.CacheMemoryMode;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.SqlQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlFunction;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheEntryImpl;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheObjectContext;
import org.apache.ignite.internal.processors.cache.GridCacheAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheAffinityManager;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.IgniteInternalCache;
import org.apache.ignite.internal.processors.cache.QueryCursorImpl;
import org.apache.ignite.internal.processors.cache.query.GridCacheTwoStepQuery;
import org.apache.ignite.internal.processors.query.GridQueryFieldMetadata;
import org.apache.ignite.internal.processors.query.GridQueryFieldsResult;
import org.apache.ignite.internal.processors.query.GridQueryFieldsResultAdapter;
import org.apache.ignite.internal.processors.query.GridQueryIndexDescriptor;
import org.apache.ignite.internal.processors.query.GridQueryIndexType;
import org.apache.ignite.internal.processors.query.GridQueryIndexing;
import org.apache.ignite.internal.processors.query.GridQueryProperty;
import org.apache.ignite.internal.processors.query.GridQueryTypeDescriptor;
import org.apache.ignite.internal.processors.query.h2.GridH2ResultSetIterator;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2IndexBase;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2KeyValueRowOffheap;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2KeyValueRowOnheap;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Row;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2RowDescriptor;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2TreeIndex;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Utils;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2ValueCacheObject;
import org.apache.ignite.internal.processors.query.h2.opt.GridLuceneIndex;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlQuerySplitter;
import org.apache.ignite.internal.processors.query.h2.twostep.GridMapQueryExecutor;
import org.apache.ignite.internal.processors.query.h2.twostep.GridReduceQueryExecutor;
import org.apache.ignite.internal.processors.timeout.GridTimeoutProcessor;
import org.apache.ignite.internal.util.GridBoundedConcurrentLinkedHashMap;
import org.apache.ignite.internal.util.GridEmptyCloseableIterator;
import org.apache.ignite.internal.util.GridSpinBusyLock;
import org.apache.ignite.internal.util.lang.GridCloseableIterator;
import org.apache.ignite.internal.util.offheap.unsafe.GridUnsafeGuard;
import org.apache.ignite.internal.util.offheap.unsafe.GridUnsafeMemory;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T3;
import org.apache.ignite.internal.util.typedef.internal.LT;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.marshaller.jdk.JdkMarshaller;
import org.apache.ignite.resources.LoggerResource;
import org.apache.ignite.spi.IgniteSpiCloseableIterator;
import org.apache.ignite.spi.indexing.IndexingQueryFilter;
import org.h2.Driver;
import org.h2.api.JavaObjectSerializer;
import org.h2.command.CommandInterface;
import org.h2.constant.SysProperties;
import org.h2.index.Index;
import org.h2.index.SpatialIndex;
import org.h2.jdbc.JdbcPreparedStatement;
import org.h2.message.DbException;
import org.h2.mvstore.cache.CacheLongKeyLIRS;
import org.h2.server.Service;
import org.h2.server.web.WebServer;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.tools.Server;
import org.h2.util.Utils;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueByte;
import org.h2.value.ValueBytes;
import org.h2.value.ValueDate;
import org.h2.value.ValueDecimal;
import org.h2.value.ValueDouble;
import org.h2.value.ValueFloat;
import org.h2.value.ValueGeometry;
import org.h2.value.ValueInt;
import org.h2.value.ValueJavaObject;
import org.h2.value.ValueLong;
import org.h2.value.ValueNull;
import org.h2.value.ValueShort;
import org.h2.value.ValueString;
import org.h2.value.ValueTime;
import org.h2.value.ValueUuid;
import org.jetbrains.annotations.Nullable;
import org.jsr166.ConcurrentHashMap8;

public class IgniteH2Indexing
implements GridQueryIndexing {
    private static final String DB_OPTIONS = ";LOCK_MODE=3;MULTI_THREADED=1;DB_CLOSE_ON_EXIT=FALSE;DEFAULT_LOCK_TIMEOUT=10000;FUNCTIONS_IN_SCHEMA=true;OPTIMIZE_REUSE_RESULTS=0;QUERY_CACHE_SIZE=0;RECOMPILE_ALWAYS=1;MAX_OPERATION_MEMORY=0";
    private static final int PREPARED_STMT_CACHE_SIZE = 256;
    private static final int TWO_STEP_QRY_CACHE_SIZE = 1024;
    public static final String KEY_FIELD_NAME = "_key";
    public static final String VAL_FIELD_NAME = "_val";
    private static final Field COMMAND_FIELD;
    private static final char ESC_CH = '\"';
    private static final String ESC_STR = "\"\"";
    private final Long CLEANUP_STMT_CACHE_PERIOD = Long.getLong("IGNITE_H2_INDEXING_CACHE_CLEANUP_PERIOD", 10000L);
    private final Long STATEMENT_CACHE_THREAD_USAGE_TIMEOUT = Long.getLong("IGNITE_H2_INDEXING_CACHE_THREAD_USAGE_TIMEOUT", 600000L);
    private GridTimeoutProcessor.CancelableTask stmtCacheCleanupTask;
    @LoggerResource
    private IgniteLogger log;
    private UUID nodeId;
    private Marshaller marshaller;
    private final ConcurrentMap<String, Schema> schemas = new ConcurrentHashMap8();
    private String dbUrl = "jdbc:h2:mem:";
    private final Collection<Connection> conns = Collections.synchronizedCollection(new ArrayList());
    private GridMapQueryExecutor mapQryExec;
    private GridReduceQueryExecutor rdcQryExec;
    private final Map<String, String> space2schema = new ConcurrentHashMap8();
    private final ThreadLocal<ConnectionWrapper> connCache = new ThreadLocal<ConnectionWrapper>(){

        @Override
        @Nullable
        public ConnectionWrapper get() {
            ConnectionWrapper c = (ConnectionWrapper)super.get();
            boolean reconnect = true;
            try {
                reconnect = c == null || c.connection().isClosed();
            }
            catch (SQLException e) {
                U.warn((IgniteLogger)IgniteH2Indexing.this.log, (Object)"Failed to check connection status.", (Object)e);
            }
            if (reconnect) {
                c = this.initialValue();
                this.set(c);
                IgniteH2Indexing.this.stmtCache.remove(Thread.currentThread());
            }
            return c;
        }

        @Override
        @Nullable
        protected ConnectionWrapper initialValue() {
            Connection c;
            try {
                c = DriverManager.getConnection(IgniteH2Indexing.this.dbUrl);
            }
            catch (SQLException e) {
                throw new IgniteException("Failed to initialize DB connection: " + IgniteH2Indexing.this.dbUrl, (Throwable)e);
            }
            IgniteH2Indexing.this.conns.add(c);
            return new ConnectionWrapper(c);
        }
    };
    private volatile GridKernalContext ctx;
    private final ConcurrentHashMap<Thread, StatementCache> stmtCache = new ConcurrentHashMap();
    private final GridBoundedConcurrentLinkedHashMap<T3<String, String, Boolean>, TwoStepCachedQuery> twoStepCache = new GridBoundedConcurrentLinkedHashMap(1024);

    public Connection connectionForSpace(@Nullable String space) {
        try {
            return this.connectionForThread(this.schema(space));
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException((Throwable)e);
        }
    }

    private PreparedStatement prepareStatement(Connection c, String sql, boolean useStmtCache) throws SQLException {
        if (useStmtCache) {
            StatementCache cache0;
            Thread curThread = Thread.currentThread();
            StatementCache cache = this.stmtCache.get(curThread);
            if (cache == null && (cache = this.stmtCache.putIfAbsent(curThread, cache0 = new StatementCache(256))) == null) {
                cache = cache0;
            }
            cache.updateLastUsage();
            PreparedStatement stmt = (PreparedStatement)cache.get(sql);
            if (stmt != null && !stmt.isClosed()) {
                assert (stmt.getConnection() == c);
                return stmt;
            }
            stmt = c.prepareStatement(sql);
            cache.put(sql, stmt);
            return stmt;
        }
        return c.prepareStatement(sql);
    }

    private Connection connectionForThread(@Nullable String schema) throws IgniteCheckedException {
        ConnectionWrapper c = this.connCache.get();
        if (c == null) {
            throw new IgniteCheckedException("Failed to get DB connection for thread (check log for details).");
        }
        if (schema != null && !F.eq((Object)c.schema(), (Object)schema)) {
            Statement stmt = null;
            try {
                stmt = c.connection().createStatement();
                stmt.executeUpdate("SET SCHEMA " + schema);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Set schema: " + schema);
                }
                c.schema(schema);
            }
            catch (SQLException e) {
                throw new IgniteCheckedException("Failed to set schema for DB connection for thread [schema=" + schema + "]", (Throwable)e);
            }
            finally {
                U.close((AutoCloseable)stmt, (IgniteLogger)this.log);
            }
        }
        return c.connection();
    }

    private void createSchema(String schema) throws IgniteCheckedException {
        this.executeStatement("INFORMATION_SCHEMA", "CREATE SCHEMA IF NOT EXISTS " + schema);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Created H2 schema for index database: " + schema);
        }
    }

    private void dropSchema(String schema) throws IgniteCheckedException {
        this.executeStatement("INFORMATION_SCHEMA", "DROP SCHEMA IF EXISTS " + schema);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Dropped H2 schema for index database: " + schema);
        }
    }

    public void executeStatement(String schema, String sql) throws IgniteCheckedException {
        Statement stmt = null;
        try {
            Connection c = this.connectionForThread(schema);
            stmt = c.createStatement();
            stmt.executeUpdate(sql);
        }
        catch (SQLException e) {
            try {
                this.onSqlException();
                throw new IgniteCheckedException("Failed to execute statement: " + sql, (Throwable)e);
            }
            catch (Throwable throwable) {
                U.close(stmt, (IgniteLogger)this.log);
                throw throwable;
            }
        }
        U.close((AutoCloseable)stmt, (IgniteLogger)this.log);
    }

    private void removeKey(@Nullable String spaceName, CacheObject key, TableDescriptor tblToUpdate) throws IgniteCheckedException {
        try {
            Collection<TableDescriptor> tbls = this.tables(this.schema(spaceName));
            Class<?> keyCls = this.getClass(this.objectContext(spaceName), key);
            for (TableDescriptor tbl : tbls) {
                if (tbl == tblToUpdate || !tbl.type().keyClass().isAssignableFrom(keyCls) || !tbl.tbl.update(key, null, 0L, true)) continue;
                if (tbl.luceneIdx != null) {
                    tbl.luceneIdx.remove(key);
                }
                return;
            }
        }
        catch (Exception e) {
            throw new IgniteCheckedException("Failed to remove key: " + key, (Throwable)e);
        }
    }

    private void bindObject(PreparedStatement stmt, int idx, @Nullable Object obj) throws IgniteCheckedException {
        try {
            if (obj == null) {
                stmt.setNull(idx, 12);
            } else {
                stmt.setObject(idx, obj);
            }
        }
        catch (SQLException e) {
            throw new IgniteCheckedException("Failed to bind parameter [idx=" + idx + ", obj=" + obj + ", stmt=" + stmt + ']', (Throwable)e);
        }
    }

    private void onSqlException() {
        Connection conn = this.connCache.get().connection();
        this.connCache.set(null);
        if (conn != null) {
            this.conns.remove(conn);
            U.close((AutoCloseable)conn, (IgniteLogger)this.log);
        }
    }

    public void store(@Nullable String spaceName, GridQueryTypeDescriptor type, CacheObject k, CacheObject v, byte[] ver, long expirationTime) throws IgniteCheckedException {
        TableDescriptor tbl = this.tableDescriptor(spaceName, type);
        this.removeKey(spaceName, k, tbl);
        if (tbl == null) {
            return;
        }
        if (expirationTime == 0L) {
            expirationTime = Long.MAX_VALUE;
        }
        tbl.tbl.update(k, v, expirationTime, false);
        if (tbl.luceneIdx != null) {
            tbl.luceneIdx.store(k, v, ver, expirationTime);
        }
    }

    private boolean isBinary(CacheObject o) {
        if (this.ctx == null) {
            return false;
        }
        return this.ctx.cacheObjects().isBinaryObject((Object)o);
    }

    private Class<?> getClass(CacheObjectContext coctx, CacheObject o) {
        return this.isBinary(o) ? Object.class : o.value(coctx, false).getClass();
    }

    private CacheObjectContext objectContext(String space) {
        if (this.ctx == null) {
            return null;
        }
        return this.ctx.cache().internalCache(space).context().cacheObjectContext();
    }

    private GridCacheContext cacheContext(String space) {
        if (this.ctx == null) {
            return null;
        }
        return this.ctx.cache().internalCache(space).context();
    }

    public void remove(@Nullable String spaceName, CacheObject key, CacheObject val) throws IgniteCheckedException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Removing key from cache query index [locId=" + this.nodeId + ", key=" + key + ", val=" + val + ']');
        }
        CacheObjectContext coctx = this.objectContext(spaceName);
        Class<?> keyCls = this.getClass(coctx, key);
        Class<?> valCls = val == null ? null : this.getClass(coctx, val);
        for (TableDescriptor tbl : this.tables(this.schema(spaceName))) {
            if (!tbl.type().keyClass().isAssignableFrom(keyCls) || val != null && !tbl.type().valueClass().isAssignableFrom(valCls) || !tbl.tbl.update(key, val, 0L, true)) continue;
            if (tbl.luceneIdx != null) {
                tbl.luceneIdx.remove(key);
            }
            return;
        }
    }

    public void onSwap(@Nullable String spaceName, CacheObject key) throws IgniteCheckedException {
        Schema schema = (Schema)this.schemas.get(this.schema(spaceName));
        if (schema == null) {
            return;
        }
        Class<?> keyCls = this.getClass(this.objectContext(spaceName), key);
        for (TableDescriptor tbl : schema.tbls.values()) {
            if (!tbl.type().keyClass().isAssignableFrom(keyCls)) continue;
            try {
                if (!tbl.tbl.onSwap(key)) continue;
                return;
            }
            catch (IgniteCheckedException e) {
                throw new IgniteCheckedException((Throwable)e);
            }
        }
    }

    public void onUnswap(@Nullable String spaceName, CacheObject key, CacheObject val) throws IgniteCheckedException {
        assert (val != null);
        CacheObjectContext coctx = this.objectContext(spaceName);
        Class<?> keyCls = this.getClass(coctx, key);
        Class<?> valCls = this.getClass(coctx, val);
        for (TableDescriptor tbl : this.tables(this.schema(spaceName))) {
            if (!tbl.type().keyClass().isAssignableFrom(keyCls) || !tbl.type().valueClass().isAssignableFrom(valCls)) continue;
            try {
                if (!tbl.tbl.onUnswap(key, val)) continue;
                return;
            }
            catch (IgniteCheckedException e) {
                throw new IgniteCheckedException((Throwable)e);
            }
        }
    }

    private void removeTable(TableDescriptor tbl) throws IgniteCheckedException {
        assert (tbl != null);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Removing query index table: " + tbl.fullTableName());
        }
        Connection c = this.connectionForThread(tbl.schemaName());
        Statement stmt = null;
        try {
            stmt = c.createStatement();
            String sql = "DROP TABLE IF EXISTS " + tbl.fullTableName();
            if (this.log.isDebugEnabled()) {
                this.log.debug("Dropping database index table with SQL: " + sql);
            }
            stmt.executeUpdate(sql);
        }
        catch (SQLException e) {
            this.onSqlException();
            throw new IgniteCheckedException("Failed to drop database index table [type=" + tbl.type().name() + ", table=" + tbl.fullTableName() + "]", (Throwable)e);
        }
        finally {
            U.close((AutoCloseable)stmt, (IgniteLogger)this.log);
        }
        tbl.tbl.close();
        if (tbl.luceneIdx != null) {
            U.closeQuiet((AutoCloseable)tbl.luceneIdx);
        }
        tbl.schema.tbls.remove(tbl.name());
    }

    public <K, V> GridCloseableIterator<IgniteBiTuple<K, V>> queryText(@Nullable String spaceName, String qry, GridQueryTypeDescriptor type, IndexingQueryFilter filters) throws IgniteCheckedException {
        TableDescriptor tbl = this.tableDescriptor(spaceName, type);
        if (tbl != null && tbl.luceneIdx != null) {
            return tbl.luceneIdx.query(qry, filters);
        }
        return new GridEmptyCloseableIterator();
    }

    public void unregisterType(@Nullable String spaceName, GridQueryTypeDescriptor type) throws IgniteCheckedException {
        TableDescriptor tbl = this.tableDescriptor(spaceName, type);
        if (tbl != null) {
            this.removeTable(tbl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GridQueryFieldsResult queryFields(@Nullable String spaceName, String qry, @Nullable Collection<Object> params, IndexingQueryFilter filters) throws IgniteCheckedException {
        this.setFilters(filters);
        try {
            Connection conn = this.connectionForThread(this.schema(spaceName));
            ResultSet rs = this.executeSqlQueryWithTimer(spaceName, conn, qry, params, true);
            List<GridQueryFieldMetadata> meta = null;
            if (rs != null) {
                try {
                    meta = IgniteH2Indexing.meta(rs.getMetaData());
                }
                catch (SQLException e) {
                    throw new IgniteCheckedException("Failed to get meta data.", (Throwable)e);
                }
            }
            GridQueryFieldsResultAdapter gridQueryFieldsResultAdapter = new GridQueryFieldsResultAdapter(meta, (GridCloseableIterator)new FieldsIterator(rs));
            return gridQueryFieldsResultAdapter;
        }
        finally {
            this.setFilters(null);
        }
    }

    private static List<GridQueryFieldMetadata> meta(ResultSetMetaData rsMeta) throws SQLException {
        ArrayList<GridQueryFieldMetadata> meta = new ArrayList<GridQueryFieldMetadata>(rsMeta.getColumnCount());
        for (int i = 1; i <= rsMeta.getColumnCount(); ++i) {
            String schemaName = rsMeta.getSchemaName(i);
            String typeName = rsMeta.getTableName(i);
            String name = rsMeta.getColumnLabel(i);
            String type = rsMeta.getColumnClassName(i);
            if (type == null) {
                type = Void.class.getName();
            }
            meta.add(new SqlFieldMetadata(schemaName, typeName, name, type));
        }
        return meta;
    }

    private static int commandType(PreparedStatement stmt) {
        try {
            return ((CommandInterface)COMMAND_FIELD.get(stmt)).getCommandType();
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    private static String schemaNameFromCacheConf(CacheConfiguration<?, ?> ccfg) {
        if (ccfg.getSqlSchema() == null) {
            return IgniteH2Indexing.escapeName(ccfg.getName(), true);
        }
        if (ccfg.getSqlSchema().charAt(0) == '\"') {
            return ccfg.getSqlSchema();
        }
        return ccfg.isSqlEscapeAll() ? IgniteH2Indexing.escapeName(ccfg.getSqlSchema(), true) : ccfg.getSqlSchema().toUpperCase();
    }

    private ResultSet executeSqlQuery(Connection conn, String sql, Collection<Object> params, boolean useStmtCache) throws IgniteCheckedException {
        PreparedStatement stmt;
        try {
            stmt = this.prepareStatement(conn, sql, useStmtCache);
        }
        catch (SQLException e) {
            throw new IgniteCheckedException("Failed to parse SQL query: " + sql, (Throwable)e);
        }
        switch (IgniteH2Indexing.commandType(stmt)) {
            case 21: 
            case 57: 
            case 60: 
            case 66: {
                break;
            }
            default: {
                throw new IgniteCheckedException("Failed to execute non-query SQL statement: " + sql);
            }
        }
        this.bindParameters(stmt, params);
        try {
            return stmt.executeQuery();
        }
        catch (SQLException e) {
            throw new IgniteCheckedException("Failed to execute SQL query.", (Throwable)e);
        }
    }

    public ResultSet executeSqlQueryWithTimer(String space, Connection conn, String sql, @Nullable Collection<Object> params, boolean useStmtCache) throws IgniteCheckedException {
        long start = U.currentTimeMillis();
        try {
            ResultSet rs = this.executeSqlQuery(conn, sql, params, useStmtCache);
            long time = U.currentTimeMillis() - start;
            long longQryExecTimeout = ((Schema)this.schemas.get(this.schema(space))).ccfg.getLongQueryWarningTimeout();
            if (time > longQryExecTimeout) {
                String msg = "Query execution is too long (" + time + " ms): " + sql;
                ResultSet plan = this.executeSqlQuery(conn, "EXPLAIN " + sql, params, false);
                plan.next();
                String longMsg = "Query execution is too long [time=" + time + " ms, sql='" + sql + '\'' + ", plan=" + U.nl() + plan.getString(1) + U.nl() + ", parameters=" + params + "]";
                LT.warn((IgniteLogger)this.log, null, (String)longMsg, (String)msg);
            }
            return rs;
        }
        catch (SQLException e) {
            this.onSqlException();
            throw new IgniteCheckedException((Throwable)e);
        }
    }

    private ResultSet executeQuery(String space, String qry, @Nullable Collection<Object> params, TableDescriptor tbl) throws IgniteCheckedException {
        Connection conn = this.connectionForThread(tbl.schemaName());
        String sql = this.generateQuery(qry, tbl);
        return this.executeSqlQueryWithTimer(space, conn, sql, params, true);
    }

    public void bindParameters(PreparedStatement stmt, @Nullable Collection<Object> params) throws IgniteCheckedException {
        if (!F.isEmpty(params)) {
            int idx = 1;
            for (Object arg : params) {
                this.bindObject(stmt, idx++, arg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V> GridCloseableIterator<IgniteBiTuple<K, V>> query(@Nullable String spaceName, String qry, @Nullable Collection<Object> params, GridQueryTypeDescriptor type, IndexingQueryFilter filters) throws IgniteCheckedException {
        TableDescriptor tbl = this.tableDescriptor(spaceName, type);
        if (tbl == null) {
            throw new CacheException("Failed to find SQL table for type: " + type.name());
        }
        this.setFilters(filters);
        try {
            ResultSet rs = this.executeQuery(spaceName, qry, params, tbl);
            KeyValIterator keyValIterator = new KeyValIterator(rs);
            return keyValIterator;
        }
        finally {
            this.setFilters(null);
        }
    }

    public Iterable<List<?>> queryTwoStep(final GridCacheContext<?, ?> cctx, final GridCacheTwoStepQuery qry, final boolean keepCacheObj) {
        return new Iterable<List<?>>(){

            @Override
            public Iterator<List<?>> iterator() {
                return IgniteH2Indexing.this.rdcQryExec.query(cctx, qry, keepCacheObj);
            }
        };
    }

    public <K, V> QueryCursor<Cache.Entry<K, V>> queryTwoStep(GridCacheContext<?, ?> cctx, SqlQuery qry) {
        String sql;
        String space;
        String type = qry.getType();
        TableDescriptor tblDesc = this.tableDescriptor(type, space = cctx.name());
        if (tblDesc == null) {
            throw new CacheException("Failed to find SQL table for type: " + type);
        }
        try {
            sql = this.generateQuery(qry.getSql(), tblDesc);
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException((Throwable)e);
        }
        SqlFieldsQuery fqry = new SqlFieldsQuery(sql);
        fqry.setArgs(qry.getArgs());
        fqry.setPageSize(qry.getPageSize());
        final QueryCursor<List<?>> res = this.queryTwoStep(cctx, fqry);
        Iterable converted = new Iterable<Cache.Entry<K, V>>(){

            @Override
            public Iterator<Cache.Entry<K, V>> iterator() {
                final Iterator iter0 = res.iterator();
                return new Iterator<Cache.Entry<K, V>>(){

                    @Override
                    public boolean hasNext() {
                        return iter0.hasNext();
                    }

                    @Override
                    public Cache.Entry<K, V> next() {
                        List l = (List)iter0.next();
                        return new CacheEntryImpl(l.get(0), l.get(1));
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
        return new QueryCursorImpl<Cache.Entry<K, V>>(converted){

            public void close() {
                res.close();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryCursor<List<?>> queryTwoStep(GridCacheContext<?, ?> cctx, SqlFieldsQuery qry) {
        List<GridQueryFieldMetadata> meta;
        GridCacheTwoStepQuery twoStepQry;
        String space = cctx.name();
        String sqlQry = qry.getSql();
        Connection c = this.connectionForSpace(space);
        T3 cachedQryKey = new T3((Object)space, (Object)sqlQry, (Object)qry.isCollocated());
        TwoStepCachedQuery cachedQry = (TwoStepCachedQuery)this.twoStepCache.get((Object)cachedQryKey);
        if (cachedQry != null) {
            twoStepQry = cachedQry.twoStepQry.copy(qry.getArgs());
            meta = cachedQry.meta;
        } else {
            PreparedStatement stmt;
            boolean cachesCreated = false;
            while (true) {
                try {
                    stmt = this.prepareStatement(c, sqlQry, false);
                }
                catch (SQLException e) {
                    if (!cachesCreated && e.getErrorCode() == 90079) {
                        try {
                            this.ctx.cache().createMissingCaches();
                        }
                        catch (IgniteCheckedException e1) {
                            throw new CacheException("Failed to create missing caches.", (Throwable)e);
                        }
                        cachesCreated = true;
                        continue;
                    }
                    throw new CacheException("Failed to parse query: " + sqlQry, (Throwable)e);
                }
                break;
            }
            try {
                try {
                    this.bindParameters(stmt, F.asList((Object[])qry.getArgs()));
                }
                catch (IgniteCheckedException e) {
                    throw new CacheException("Failed to bind parameters: [qry=" + sqlQry + ", params=" + Arrays.deepToString(qry.getArgs()) + "]", (Throwable)e);
                }
                try {
                    twoStepQry = GridSqlQuerySplitter.split((JdbcPreparedStatement)stmt, qry.getArgs(), qry.isCollocated(), this);
                    meta = IgniteH2Indexing.meta(stmt.getMetaData());
                }
                catch (SQLException e) {
                    throw new CacheException((Throwable)e);
                }
            }
            finally {
                U.close((AutoCloseable)stmt, (IgniteLogger)this.log);
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Parsed query: `" + sqlQry + "` into two step query: " + twoStepQry);
        }
        twoStepQry.pageSize(qry.getPageSize());
        QueryCursorImpl cursor = new QueryCursorImpl(this.queryTwoStep(cctx, twoStepQry, cctx.keepBinary()));
        cursor.fieldsMeta(meta);
        if (cachedQry == null && !twoStepQry.explain()) {
            cachedQry = new TwoStepCachedQuery(meta, twoStepQry.copy(null));
            this.twoStepCache.putIfAbsent((Object)cachedQryKey, (Object)cachedQry);
        }
        return cursor;
    }

    public void setFilters(@Nullable IndexingQueryFilter filters) {
        GridH2IndexBase.setFiltersForThread(filters);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String generateQuery(String qry, TableDescriptor tbl) throws IgniteCheckedException {
        assert (tbl != null);
        String qry0 = qry;
        String t = tbl.fullTableName();
        String from = " ";
        String upper = (qry = qry.trim()).toUpperCase();
        if (upper.startsWith("SELECT")) {
            int star = (qry = qry.substring(6).trim()).indexOf(42);
            if (star == 0) {
                qry = qry.substring(1).trim();
            } else {
                if (star <= 0) throw new IgniteCheckedException("Only queries starting with 'SELECT *' and 'SELECT alias.*' are supported (rewrite your query or use SqlFieldsQuery instead): " + qry0);
                if (!F.eq((Object)Character.valueOf('.'), (Object)Character.valueOf(qry.charAt(star - 1)))) throw new IgniteCheckedException("Invalid query (missing alias before asterisk): " + qry0);
                t = qry.substring(0, star - 1);
                qry = qry.substring(star + 1).trim();
            }
            upper = qry.toUpperCase();
        }
        if (upper.startsWith("FROM")) return "SELECT " + t + "." + KEY_FIELD_NAME + ", " + t + "." + VAL_FIELD_NAME + from + qry;
        from = " FROM " + t + (upper.startsWith("WHERE") || upper.startsWith("ORDER") || upper.startsWith("LIMIT") ? " " : " WHERE ");
        return "SELECT " + t + "." + KEY_FIELD_NAME + ", " + t + "." + VAL_FIELD_NAME + from + qry;
    }

    public boolean registerType(@Nullable String spaceName, GridQueryTypeDescriptor type) throws IgniteCheckedException {
        if (!this.validateTypeDescriptor(type)) {
            return false;
        }
        String schemaName = this.schema(spaceName);
        Schema schema = (Schema)this.schemas.get(schemaName);
        TableDescriptor tbl = new TableDescriptor(schema, type);
        try {
            Connection conn = this.connectionForThread(schemaName);
            this.createTable(schema, tbl, conn);
            schema.add(tbl);
        }
        catch (SQLException e) {
            this.onSqlException();
            throw new IgniteCheckedException("Failed to register query type: " + type, (Throwable)e);
        }
        return true;
    }

    private boolean validateTypeDescriptor(GridQueryTypeDescriptor type) throws IgniteCheckedException {
        assert (type != null);
        HashSet names = new HashSet();
        names.addAll(type.fields().keySet());
        if (names.size() < type.fields().size()) {
            throw new IgniteCheckedException("Found duplicated properties with the same name [keyType=" + type.keyClass().getName() + ", valueType=" + type.valueClass().getName() + "]");
        }
        String ptrn = "Name ''{0}'' is reserved and cannot be used as a field name [type=" + type.name() + "]";
        for (String name : names) {
            if (!name.equals(KEY_FIELD_NAME) && !name.equals(VAL_FIELD_NAME)) continue;
            throw new IgniteCheckedException(MessageFormat.format(ptrn, name));
        }
        return true;
    }

    private static String emptyIfNull(String nullableString) {
        return nullableString == null ? "" : nullableString;
    }

    private static String escapeName(String name, boolean escapeAll) {
        if (name == null) {
            return ESC_STR;
        }
        if (escapeAll) {
            return '\"' + name + '\"';
        }
        SB sb = null;
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (Character.isLetter(ch) || Character.isDigit(ch) || ch == '_' || ch == '\"' && (i == 0 || i == name.length() - 1) || ch == '-') continue;
            assert (ch == '$' || ch == '.');
            if (sb == null) {
                sb = new SB();
            }
            sb.a(name.substring(sb.length(), i));
            sb.a('_');
        }
        if (sb == null) {
            return name;
        }
        sb.a(name.substring(sb.length(), name.length()));
        return sb.toString();
    }

    private void createTable(Schema schema, TableDescriptor tbl, Connection conn) throws SQLException {
        assert (schema != null);
        assert (tbl != null);
        boolean escapeAll = schema.escapeAll();
        String keyType = this.dbTypeFromClass(tbl.type().keyClass());
        String valTypeStr = this.dbTypeFromClass(tbl.type().valueClass());
        SB sql = new SB();
        sql.a("CREATE TABLE ").a(tbl.fullTableName()).a(" (").a(KEY_FIELD_NAME).a(' ').a(keyType).a(" NOT NULL");
        sql.a(',').a(VAL_FIELD_NAME).a(' ').a(valTypeStr);
        for (Map.Entry e : tbl.type().fields().entrySet()) {
            sql.a(',').a(IgniteH2Indexing.escapeName((String)e.getKey(), escapeAll)).a(' ').a(this.dbTypeFromClass((Class)e.getValue()));
        }
        sql.a(')');
        if (this.log.isDebugEnabled()) {
            this.log.debug("Creating DB table with SQL: " + sql);
        }
        RowDescriptor desc = new RowDescriptor(tbl.type(), schema);
        GridH2Table.Engine.createTable(conn, sql.toString(), desc, tbl, tbl.schema.spaceName);
    }

    private String dbTypeFromClass(Class<?> cls) {
        return DBTypeEnum.fromClass(cls).dBTypeAsString();
    }

    @Nullable
    private TableDescriptor tableDescriptor(@Nullable String spaceName, GridQueryTypeDescriptor type) {
        return this.tableDescriptor(type.name(), spaceName);
    }

    @Nullable
    private TableDescriptor tableDescriptor(String type, @Nullable String space) {
        Schema s = (Schema)this.schemas.get(this.schema(space));
        if (s == null) {
            return null;
        }
        return (TableDescriptor)s.tbls.get(type);
    }

    private Collection<TableDescriptor> tables(String schema) {
        Schema s = (Schema)this.schemas.get(schema);
        if (s == null) {
            return Collections.emptySet();
        }
        return s.tbls.values();
    }

    private String schema(@Nullable String space) {
        return IgniteH2Indexing.emptyIfNull(this.space2schema.get(IgniteH2Indexing.emptyIfNull(space)));
    }

    private void cleanupStatementCache() {
        long cur = U.currentTimeMillis();
        Iterator<Map.Entry<Thread, StatementCache>> it = this.stmtCache.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Thread, StatementCache> entry = it.next();
            Thread t = entry.getKey();
            if (t.getState() != Thread.State.TERMINATED && cur - entry.getValue().lastUsage() <= this.STATEMENT_CACHE_THREAD_USAGE_TIMEOUT) continue;
            it.remove();
        }
    }

    public String space(String schemaName) {
        assert (schemaName != null);
        Schema schema = (Schema)this.schemas.get(schemaName);
        if (schema == null) {
            assert (schemaName.isEmpty() || schemaName.charAt(0) != '\"');
            schema = (Schema)this.schemas.get(IgniteH2Indexing.escapeName(schemaName, true));
        }
        return schema.spaceName;
    }

    public void rebuildIndexes(@Nullable String spaceName, GridQueryTypeDescriptor type) {
        TableDescriptor tbl = this.tableDescriptor(spaceName, type);
        if (tbl == null) {
            return;
        }
        if (tbl.schema.offheap != null) {
            throw new UnsupportedOperationException("Index rebuilding is not supported when off-heap memory is used");
        }
        tbl.tbl.rebuildIndexes();
    }

    public long size(@Nullable String spaceName, GridQueryTypeDescriptor type, IndexingQueryFilter filters) throws IgniteCheckedException {
        TableDescriptor tbl = this.tableDescriptor(spaceName, type);
        if (tbl == null) {
            return -1L;
        }
        IgniteSpiCloseableIterator iter = this.queryFields(spaceName, "SELECT COUNT(*) FROM " + tbl.fullTableName(), null, null).iterator();
        return ((Number)((List)iter.next()).get(0)).longValue();
    }

    public GridMapQueryExecutor mapQueryExecutor() {
        return this.mapQryExec;
    }

    public GridReduceQueryExecutor reduceQueryExecutor() {
        return this.rdcQryExec;
    }

    public void start(GridKernalContext ctx, GridSpinBusyLock busyLock) throws IgniteCheckedException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Starting cache query index...");
        }
        System.setProperty("h2.serializeJavaObject", "false");
        System.setProperty("h2.objectCacheMaxPerElementSize", "0");
        if (SysProperties.serializeJavaObject) {
            U.warn((IgniteLogger)this.log, (Object)"Serialization of Java objects in H2 was enabled.");
            SysProperties.serializeJavaObject = false;
        }
        if (Utils.serializer != null) {
            U.warn((IgniteLogger)this.log, (Object)"Custom H2 serialization is already configured, will override.");
        }
        Utils.serializer = this.h2Serializer();
        String dbName = (ctx != null ? ctx.localNodeId() : UUID.randomUUID()).toString();
        this.dbUrl = "jdbc:h2:mem:" + dbName + DB_OPTIONS;
        Driver.load();
        try {
            if (IgniteSystemProperties.getString((String)"IGNITE_H2_DEBUG_CONSOLE") != null) {
                Connection c = DriverManager.getConnection(this.dbUrl);
                WebServer webSrv = new WebServer();
                Server web = new Server((Service)webSrv, new String[]{"-webPort", "0"});
                web.start();
                String url = webSrv.addSession(c);
                try {
                    Server.openBrowser((String)url);
                }
                catch (Exception e) {
                    U.warn((IgniteLogger)this.log, (Object)("Failed to open browser: " + e.getMessage()));
                }
            }
        }
        catch (SQLException e) {
            throw new IgniteCheckedException((Throwable)e);
        }
        if (ctx == null) {
            this.marshaller = new JdkMarshaller();
        } else {
            this.ctx = ctx;
            this.nodeId = ctx.localNodeId();
            this.marshaller = ctx.config().getMarshaller();
            this.mapQryExec = new GridMapQueryExecutor(busyLock);
            this.rdcQryExec = new GridReduceQueryExecutor(busyLock);
            this.mapQryExec.start(ctx, this);
            this.rdcQryExec.start(ctx, this);
            this.stmtCacheCleanupTask = ctx.timeout().schedule(new Runnable(){

                @Override
                public void run() {
                    IgniteH2Indexing.this.cleanupStatementCache();
                }
            }, this.CLEANUP_STMT_CACHE_PERIOD.longValue(), this.CLEANUP_STMT_CACHE_PERIOD.longValue());
        }
    }

    protected JavaObjectSerializer h2Serializer() {
        return new JavaObjectSerializer(){

            public byte[] serialize(Object obj) throws Exception {
                return IgniteH2Indexing.this.marshaller.marshal(obj);
            }

            public Object deserialize(byte[] bytes) throws Exception {
                ClassLoader clsLdr = IgniteH2Indexing.this.ctx != null ? U.resolveClassLoader((IgniteConfiguration)IgniteH2Indexing.this.ctx.config()) : null;
                return IgniteH2Indexing.this.marshaller.unmarshal(bytes, clsLdr);
            }
        };
    }

    private void createSqlFunctions(String schema, Class<?>[] clss) throws IgniteCheckedException {
        if (F.isEmpty((Object[])clss)) {
            return;
        }
        for (Class<?> cls : clss) {
            for (Method m : cls.getDeclaredMethods()) {
                QuerySqlFunction ann = m.getAnnotation(QuerySqlFunction.class);
                if (ann == null) continue;
                int modifiers = m.getModifiers();
                if (!Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers)) {
                    throw new IgniteCheckedException("Method " + m.getName() + " must be public static.");
                }
                String alias = ann.alias().isEmpty() ? m.getName() : ann.alias();
                String clause = "CREATE ALIAS IF NOT EXISTS " + alias + (ann.deterministic() ? " DETERMINISTIC FOR \"" : " FOR \"") + cls.getName() + '.' + m.getName() + '\"';
                this.executeStatement(schema, clause);
            }
        }
    }

    public void stop() throws IgniteCheckedException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Stopping cache query index...");
        }
        for (Schema schema : this.schemas.values()) {
            for (TableDescriptor desc : schema.tbls.values()) {
                desc.tbl.close();
                if (desc.luceneIdx == null) continue;
                U.closeQuiet((AutoCloseable)desc.luceneIdx);
            }
        }
        for (Connection c : this.conns) {
            U.close((AutoCloseable)c, (IgniteLogger)this.log);
        }
        this.conns.clear();
        this.schemas.clear();
        this.space2schema.clear();
        try (Connection c = DriverManager.getConnection(this.dbUrl);
             Statement s = c.createStatement();){
            s.execute("SHUTDOWN");
        }
        catch (SQLException e) {
            U.error((IgniteLogger)this.log, (Object)"Failed to shutdown database.", (Throwable)e);
        }
        if (this.stmtCacheCleanupTask != null) {
            this.stmtCacheCleanupTask.close();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Cache query index stopped.");
        }
    }

    public void registerCache(CacheConfiguration<?, ?> ccfg) throws IgniteCheckedException {
        String schema = IgniteH2Indexing.schemaNameFromCacheConf(ccfg);
        if (this.schemas.putIfAbsent(schema, new Schema(ccfg.getName(), schema, (GridUnsafeMemory)(ccfg.getOffHeapMaxMemory() >= 0L || ccfg.getMemoryMode() == CacheMemoryMode.OFFHEAP_TIERED ? new GridUnsafeMemory(0L) : null), ccfg)) != null) {
            throw new IgniteCheckedException("Schema for cache already registered: " + U.maskName((String)ccfg.getName()));
        }
        this.space2schema.put(IgniteH2Indexing.emptyIfNull(ccfg.getName()), schema);
        this.createSchema(schema);
        this.createSqlFunctions(schema, ccfg.getSqlFunctionClasses());
    }

    public void unregisterCache(CacheConfiguration<?, ?> ccfg) {
        String schema = this.schema(ccfg.getName());
        Schema rmv = (Schema)this.schemas.remove(schema);
        if (rmv != null) {
            this.space2schema.remove(IgniteH2Indexing.emptyIfNull(rmv.spaceName));
            this.mapQryExec.onCacheStop(ccfg.getName());
            try {
                this.dropSchema(schema);
            }
            catch (IgniteCheckedException e) {
                U.error((IgniteLogger)this.log, (Object)("Failed to drop schema on cache stop (will ignore): " + U.maskName((String)ccfg.getName())), (Throwable)e);
            }
            Iterator it = this.twoStepCache.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry e = (Map.Entry)it.next();
                if (!F.eq((Object)((T3)e.getKey()).get1(), (Object)ccfg.getName())) continue;
                it.remove();
            }
        }
    }

    public IndexingQueryFilter backupFilter(@Nullable List<String> caches, @Nullable AffinityTopologyVersion topVer, final @Nullable int[] parts) {
        final AffinityTopologyVersion topVer0 = topVer != null ? topVer : AffinityTopologyVersion.NONE;
        return new IndexingQueryFilter(){

            @Nullable
            public <K, V> IgniteBiPredicate<K, V> forSpace(String spaceName) {
                GridCacheAdapter cache = IgniteH2Indexing.this.ctx.cache().internalCache(spaceName);
                if (cache.context().isReplicated()) {
                    return null;
                }
                final GridCacheAffinityManager aff = cache.context().affinity();
                if (parts != null) {
                    if (parts.length < 64) {
                        return new IgniteBiPredicate<K, V>(){

                            public boolean apply(K k, V v) {
                                int p = aff.partition(k);
                                for (int p0 : parts) {
                                    if (p0 == p) {
                                        return true;
                                    }
                                    if (p0 <= p) continue;
                                    return false;
                                }
                                return false;
                            }
                        };
                    }
                    return new IgniteBiPredicate<K, V>(){

                        public boolean apply(K k, V v) {
                            int p = aff.partition(k);
                            return Arrays.binarySearch(parts, p) >= 0;
                        }
                    };
                }
                final ClusterNode locNode = IgniteH2Indexing.this.ctx.discovery().localNode();
                return new IgniteBiPredicate<K, V>(){

                    public boolean apply(K k, V v) {
                        return aff.primary(locNode, k, topVer0);
                    }
                };
            }

            public boolean isValueRequired() {
                return false;
            }
        };
    }

    public AffinityTopologyVersion readyTopologyVersion() {
        return this.ctx.cache().context().exchange().readyAffinityVersion();
    }

    public void awaitForReadyTopologyVersion(AffinityTopologyVersion topVer) throws IgniteCheckedException {
        IgniteInternalFuture fut = this.ctx.cache().context().exchange().affinityReadyFuture(topVer);
        if (fut != null) {
            fut.get();
        }
    }

    public void onDisconnected(IgniteFuture<?> reconnectFut) {
        this.rdcQryExec.onDisconnected(reconnectFut);
    }

    static {
        try {
            System.setProperty("h2.objectCache", "false");
            COMMAND_FIELD = JdbcPreparedStatement.class.getDeclaredField("command");
            COMMAND_FIELD.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException("Check H2 version in classpath.", e);
        }
    }

    private static class StatementCache
    extends LinkedHashMap<String, PreparedStatement> {
        private int size;
        private volatile long lastUsage;

        private StatementCache(int size) {
            super(size, 0.75f, true);
            this.size = size;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, PreparedStatement> eldest) {
            boolean rmv;
            boolean bl = rmv = this.size() > this.size;
            if (rmv) {
                PreparedStatement stmt = eldest.getValue();
                U.closeQuiet((AutoCloseable)stmt);
            }
            return rmv;
        }

        private long lastUsage() {
            return this.lastUsage;
        }

        private void updateLastUsage() {
            this.lastUsage = U.currentTimeMillis();
        }
    }

    private class RowDescriptor
    implements GridH2RowDescriptor {
        private final GridQueryTypeDescriptor type;
        private final String[] fields;
        private final int[] fieldTypes;
        private final int keyType;
        private final int valType;
        private final Schema schema;
        private final GridUnsafeGuard guard;
        private final boolean preferSwapVal;
        private final boolean snapshotableIdx;
        private final GridQueryProperty[] props;

        RowDescriptor(GridQueryTypeDescriptor type, Schema schema) {
            int i;
            assert (type != null);
            assert (schema != null);
            this.type = type;
            this.schema = schema;
            this.guard = schema.offheap == null ? null : new GridUnsafeGuard();
            LinkedHashMap allFields = new LinkedHashMap();
            allFields.putAll(type.fields());
            this.fields = allFields.keySet().toArray(new String[allFields.size()]);
            this.fieldTypes = new int[this.fields.length];
            Class[] classes = allFields.values().toArray(new Class[this.fields.length]);
            for (i = 0; i < this.fieldTypes.length; ++i) {
                this.fieldTypes[i] = DataType.getTypeFromClass((Class)classes[i]);
            }
            this.keyType = DataType.getTypeFromClass((Class)type.keyClass());
            this.valType = DataType.getTypeFromClass((Class)type.valueClass());
            this.props = new GridQueryProperty[this.fields.length];
            for (i = 0; i < this.fields.length; ++i) {
                GridQueryProperty p = type.property(this.fields[i]);
                assert (p != null) : this.fields[i];
                this.props[i] = p;
            }
            this.preferSwapVal = schema.ccfg.getMemoryMode() == CacheMemoryMode.OFFHEAP_TIERED;
            this.snapshotableIdx = schema.ccfg.isSnapshotableIndex() || schema.offheap != null;
        }

        @Override
        public GridUnsafeGuard guard() {
            return this.guard;
        }

        @Override
        public void cache(GridH2KeyValueRowOffheap row) {
            long ptr = row.pointer();
            assert (ptr > 0L) : ptr;
            this.schema.rowCache.put(ptr, (Object)row);
        }

        @Override
        public void uncache(long ptr) {
            this.schema.rowCache.remove(ptr);
        }

        @Override
        public GridUnsafeMemory memory() {
            return this.schema.offheap;
        }

        @Override
        public IgniteH2Indexing owner() {
            return IgniteH2Indexing.this;
        }

        @Override
        public Value wrap(Object obj, int type) throws IgniteCheckedException {
            assert (obj != null);
            if (obj instanceof CacheObject) {
                CacheObject co = (CacheObject)obj;
                if (type == 19) {
                    return new GridH2ValueCacheObject(IgniteH2Indexing.this.cacheContext(this.schema.spaceName), co);
                }
                obj = co.value(IgniteH2Indexing.this.objectContext(this.schema.spaceName), false);
            }
            switch (type) {
                case 1: {
                    return ValueBoolean.get((boolean)((Boolean)obj));
                }
                case 2: {
                    return ValueByte.get((byte)((Byte)obj));
                }
                case 3: {
                    return ValueShort.get((short)((Short)obj));
                }
                case 4: {
                    return ValueInt.get((int)((Integer)obj));
                }
                case 8: {
                    return ValueFloat.get((float)((Float)obj).floatValue());
                }
                case 5: {
                    return ValueLong.get((long)((Long)obj));
                }
                case 7: {
                    return ValueDouble.get((double)((Double)obj));
                }
                case 20: {
                    UUID uuid = (UUID)obj;
                    return ValueUuid.get((long)uuid.getMostSignificantBits(), (long)uuid.getLeastSignificantBits());
                }
                case 10: {
                    return ValueDate.get((java.sql.Date)((java.sql.Date)obj));
                }
                case 9: {
                    return ValueTime.get((Time)((Time)obj));
                }
                case 11: {
                    if (obj instanceof Date && !(obj instanceof Timestamp)) {
                        obj = new Timestamp(((Date)obj).getTime());
                    }
                    return GridH2Utils.toValueTimestamp((Timestamp)obj);
                }
                case 6: {
                    return ValueDecimal.get((BigDecimal)((BigDecimal)obj));
                }
                case 13: {
                    return ValueString.get((String)obj.toString());
                }
                case 12: {
                    return ValueBytes.get((byte[])((byte[])obj));
                }
                case 19: {
                    return ValueJavaObject.getNoCopy((Object)obj, null, null);
                }
                case 17: {
                    Object[] arr = (Object[])obj;
                    Value[] valArr = new Value[arr.length];
                    for (int i = 0; i < arr.length; ++i) {
                        Object o = arr[i];
                        valArr[i] = o == null ? ValueNull.INSTANCE : this.wrap(o, DataType.getTypeFromClass(o.getClass()));
                    }
                    return ValueArray.get((Value[])valArr);
                }
                case 22: {
                    return ValueGeometry.getFromGeometry((Object)obj);
                }
            }
            throw new IgniteCheckedException("Failed to wrap value[type=" + type + ", value=" + obj + "]");
        }

        @Override
        public GridH2Row createRow(CacheObject key, @Nullable CacheObject val, long expirationTime) throws IgniteCheckedException {
            try {
                if (val == null) {
                    return new GridH2Row(this.wrap(key, this.keyType), null);
                }
                return this.schema.offheap == null ? new GridH2KeyValueRowOnheap(this, key, this.keyType, val, this.valType, expirationTime) : new GridH2KeyValueRowOffheap(this, key, this.keyType, val, this.valType, expirationTime);
            }
            catch (ClassCastException e) {
                throw new IgniteCheckedException("Failed to convert key to SQL type. Please make sure that you always store each value type with the same key type or configure key type as common super class for all actual keys for this value type.", (Throwable)e);
            }
        }

        @Override
        public Object readFromSwap(Object key) throws IgniteCheckedException {
            CacheObject v;
            IgniteInternalCache cache = IgniteH2Indexing.this.ctx.cache().cache(this.schema.spaceName);
            GridCacheContext cctx = cache.context();
            if (cctx.isNear()) {
                cctx = cctx.near().dht().context();
            }
            if ((v = cctx.swap().readValue(cctx.toCacheKeyObject(key), true, true)) == null) {
                return null;
            }
            return v;
        }

        @Override
        public int valueType() {
            return this.valType;
        }

        @Override
        public int fieldsCount() {
            return this.fields.length;
        }

        @Override
        public int fieldType(int col) {
            return this.fieldTypes[col];
        }

        @Override
        public Object columnValue(Object key, Object val, int col) {
            try {
                return this.props[col].value(key, val);
            }
            catch (IgniteCheckedException e) {
                throw DbException.convert((Throwable)e);
            }
        }

        public GridH2KeyValueRowOffheap createPointer(long ptr) {
            GridH2KeyValueRowOffheap row = (GridH2KeyValueRowOffheap)this.schema.rowCache.get(ptr);
            if (row != null) {
                assert (row.pointer() == ptr) : ptr + " " + row.pointer();
                return row;
            }
            return new GridH2KeyValueRowOffheap(this, ptr);
        }

        @Override
        public boolean preferSwapValue() {
            return this.preferSwapVal;
        }

        @Override
        public boolean snapshotableIndex() {
            return this.snapshotableIdx;
        }
    }

    private static class Schema {
        private static final long serialVersionUID = 0L;
        private final String spaceName;
        private final String schemaName;
        private final GridUnsafeMemory offheap;
        private final ConcurrentMap<String, TableDescriptor> tbls = new ConcurrentHashMap8();
        private final CacheLongKeyLIRS<GridH2KeyValueRowOffheap> rowCache;
        private final CacheConfiguration<?, ?> ccfg;

        private Schema(@Nullable String spaceName, String schemaName, GridUnsafeMemory offheap, CacheConfiguration<?, ?> ccfg) {
            this.spaceName = spaceName;
            this.schemaName = schemaName;
            this.offheap = offheap;
            this.ccfg = ccfg;
            this.rowCache = offheap != null ? new CacheLongKeyLIRS((long)ccfg.getSqlOnheapRowCacheSize(), 1, 128, 256) : null;
        }

        public void add(TableDescriptor tbl) {
            if (this.tbls.putIfAbsent(tbl.name(), tbl) != null) {
                throw new IllegalStateException("Table already registered: " + tbl.name());
            }
        }

        public boolean escapeAll() {
            return this.ccfg.isSqlEscapeAll();
        }
    }

    private static class SqlFieldMetadata
    implements GridQueryFieldMetadata {
        private static final long serialVersionUID = 0L;
        private String schemaName;
        private String typeName;
        private String name;
        private String type;

        public SqlFieldMetadata() {
        }

        SqlFieldMetadata(@Nullable String schemaName, @Nullable String typeName, String name, String type) {
            assert (name != null && type != null) : schemaName + " | " + typeName + " | " + name + " | " + type;
            this.schemaName = schemaName;
            this.typeName = typeName;
            this.name = name;
            this.type = type;
        }

        public String schemaName() {
            return this.schemaName;
        }

        public String typeName() {
            return this.typeName;
        }

        public String fieldName() {
            return this.name;
        }

        public String fieldTypeName() {
            return this.type;
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            U.writeString((DataOutput)out, (String)this.schemaName);
            U.writeString((DataOutput)out, (String)this.typeName);
            U.writeString((DataOutput)out, (String)this.name);
            U.writeString((DataOutput)out, (String)this.type);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.schemaName = U.readString((DataInput)in);
            this.typeName = U.readString((DataInput)in);
            this.name = U.readString((DataInput)in);
            this.type = U.readString((DataInput)in);
        }

        public String toString() {
            return S.toString(SqlFieldMetadata.class, (Object)this);
        }
    }

    private static class KeyValIterator<K, V>
    extends GridH2ResultSetIterator<IgniteBiTuple<K, V>> {
        private static final long serialVersionUID = 0L;

        protected KeyValIterator(ResultSet data) throws IgniteCheckedException {
            super(data, false);
        }

        @Override
        protected IgniteBiTuple<K, V> createRow() {
            Object key = this.row[0];
            Object val = this.row[1];
            return new IgniteBiTuple(key, val);
        }
    }

    private static class FieldsIterator
    extends GridH2ResultSetIterator<List<?>> {
        private static final long serialVersionUID = 0L;

        protected FieldsIterator(ResultSet data) throws IgniteCheckedException {
            super(data, false);
        }

        @Override
        protected List<?> createRow() {
            ArrayList res = new ArrayList(this.row.length);
            Collections.addAll(res, this.row);
            return res;
        }
    }

    private class TableDescriptor
    implements GridH2Table.IndexesFactory {
        private final String fullTblName;
        private final GridQueryTypeDescriptor type;
        private final Schema schema;
        private GridH2Table tbl;
        private GridLuceneIndex luceneIdx;

        TableDescriptor(Schema schema, GridQueryTypeDescriptor type) {
            this.type = type;
            this.schema = schema;
            this.fullTblName = schema.schemaName + "." + IgniteH2Indexing.escapeName(type.name(), schema.escapeAll());
        }

        public String schemaName() {
            return this.schema.schemaName;
        }

        String fullTableName() {
            return this.fullTblName;
        }

        String name() {
            return this.type.name();
        }

        GridQueryTypeDescriptor type() {
            return this.type;
        }

        public String toString() {
            return S.toString(TableDescriptor.class, (Object)this);
        }

        @Override
        public ArrayList<Index> createIndexes(GridH2Table tbl) {
            this.tbl = tbl;
            ArrayList<Index> idxs = new ArrayList<Index>();
            idxs.add((Index)new GridH2TreeIndex("_key_PK", tbl, true, 0, 1, tbl.indexColumn(0, 0)));
            if (this.type().valueClass() == String.class) {
                try {
                    this.luceneIdx = new GridLuceneIndex(IgniteH2Indexing.this.ctx, this.schema.offheap, this.schema.spaceName, this.type);
                }
                catch (IgniteCheckedException e1) {
                    throw new IgniteException((Throwable)e1);
                }
            }
            for (Map.Entry e : this.type.indexes().entrySet()) {
                String name = (String)e.getKey();
                GridQueryIndexDescriptor idx = (GridQueryIndexDescriptor)e.getValue();
                if (idx.type() == GridQueryIndexType.FULLTEXT) {
                    try {
                        this.luceneIdx = new GridLuceneIndex(IgniteH2Indexing.this.ctx, this.schema.offheap, this.schema.spaceName, this.type);
                        continue;
                    }
                    catch (IgniteCheckedException e1) {
                        throw new IgniteException((Throwable)e1);
                    }
                }
                IndexColumn[] cols = new IndexColumn[idx.fields().size()];
                int i = 0;
                boolean escapeAll = this.schema.escapeAll();
                for (String field : idx.fields()) {
                    String fieldName = escapeAll ? field : IgniteH2Indexing.escapeName(field, false).toUpperCase();
                    Column col = tbl.getColumn(fieldName);
                    cols[i++] = tbl.indexColumn(col.getColumnId(), idx.descending(field) ? 1 : 0);
                }
                if (idx.type() == GridQueryIndexType.SORTED) {
                    idxs.add((Index)new GridH2TreeIndex(name, tbl, false, 0, 1, cols));
                    continue;
                }
                if (idx.type() == GridQueryIndexType.GEO_SPATIAL) {
                    idxs.add((Index)this.createH2SpatialIndex((Table)tbl, name, cols, 0, 1));
                    continue;
                }
                throw new IllegalStateException();
            }
            return idxs;
        }

        private SpatialIndex createH2SpatialIndex(Table tbl, String idxName, IndexColumn[] cols, int keyCol, int valCol) {
            String className = "org.apache.ignite.internal.processors.query.h2.opt.GridH2SpatialIndex";
            try {
                Class<?> cls = Class.forName(className);
                Constructor<?> ctor = cls.getConstructor(Table.class, String.class, IndexColumn[].class, Integer.TYPE, Integer.TYPE);
                if (!ctor.isAccessible()) {
                    ctor.setAccessible(true);
                }
                return (SpatialIndex)ctor.newInstance(tbl, idxName, cols, keyCol, valCol);
            }
            catch (Exception e) {
                throw new IgniteException("Failed to instantiate: " + className, (Throwable)e);
            }
        }
    }

    private static enum DBTypeEnum {
        INT("INT"),
        BOOL("BOOL"),
        TINYINT("TINYINT"),
        SMALLINT("SMALLINT"),
        BIGINT("BIGINT"),
        DECIMAL("DECIMAL"),
        DOUBLE("DOUBLE"),
        REAL("REAL"),
        TIME("TIME"),
        TIMESTAMP("TIMESTAMP"),
        DATE("DATE"),
        VARCHAR("VARCHAR"),
        CHAR("CHAR"),
        BINARY("BINARY"),
        UUID("UUID"),
        ARRAY("ARRAY"),
        GEOMETRY("GEOMETRY"),
        OTHER("OTHER");

        private static final Map<Class<?>, DBTypeEnum> map;
        private final String dbType;

        private DBTypeEnum(String dbType) {
            this.dbType = dbType;
        }

        public static DBTypeEnum fromClass(Class<?> cls) {
            DBTypeEnum res = map.get(cls);
            if (res != null) {
                return res;
            }
            if (DataType.isGeometryClass(cls)) {
                return GEOMETRY;
            }
            return cls.isArray() && !cls.getComponentType().isPrimitive() ? ARRAY : OTHER;
        }

        public String dBTypeAsString() {
            return this.dbType;
        }

        public String toString() {
            return S.toString(DBTypeEnum.class, (Object)((Object)this));
        }

        static {
            map = new HashMap();
            map.put(Integer.TYPE, INT);
            map.put(Integer.class, INT);
            map.put(Boolean.TYPE, BOOL);
            map.put(Boolean.class, BOOL);
            map.put(Byte.TYPE, TINYINT);
            map.put(Byte.class, TINYINT);
            map.put(Short.TYPE, SMALLINT);
            map.put(Short.class, SMALLINT);
            map.put(Long.TYPE, BIGINT);
            map.put(Long.class, BIGINT);
            map.put(BigDecimal.class, DECIMAL);
            map.put(Double.TYPE, DOUBLE);
            map.put(Double.class, DOUBLE);
            map.put(Float.TYPE, REAL);
            map.put(Float.class, REAL);
            map.put(Time.class, TIME);
            map.put(Timestamp.class, TIMESTAMP);
            map.put(Date.class, TIMESTAMP);
            map.put(java.sql.Date.class, DATE);
            map.put(String.class, VARCHAR);
            map.put(UUID.class, UUID);
            map.put(byte[].class, BINARY);
        }
    }

    private static class ConnectionWrapper {
        private Connection conn;
        private volatile String schema;

        ConnectionWrapper(Connection conn) {
            this.conn = conn;
        }

        public String schema() {
            return this.schema;
        }

        public void schema(@Nullable String schema) {
            this.schema = schema;
        }

        public Connection connection() {
            return this.conn;
        }

        public String toString() {
            return S.toString(ConnectionWrapper.class, (Object)this);
        }
    }

    private static final class TwoStepCachedQuery {
        final List<GridQueryFieldMetadata> meta;
        final GridCacheTwoStepQuery twoStepQry;

        public TwoStepCachedQuery(List<GridQueryFieldMetadata> meta, GridCacheTwoStepQuery twoStepQry) {
            this.meta = meta;
            this.twoStepQry = twoStepQry;
        }

        public String toString() {
            return S.toString(TwoStepCachedQuery.class, (Object)this);
        }
    }
}

