/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.webproxy;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.http.HttpServer2;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.server.webproxy.AppReportFetcher;
import org.apache.hadoop.yarn.server.webproxy.WebAppProxyServlet;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;

public class WebAppProxy
extends AbstractService {
    public static final String FETCHER_ATTRIBUTE = "AppUrlFetcher";
    public static final String IS_SECURITY_ENABLED_ATTRIBUTE = "IsSecurityEnabled";
    public static final String PROXY_HOST_ATTRIBUTE = "proxyHost";
    private static final Log LOG = LogFactory.getLog(WebAppProxy.class);
    private HttpServer2 proxyServer = null;
    private String bindAddress = null;
    private int port = 0;
    private AccessControlList acl = null;
    private AppReportFetcher fetcher = null;
    private boolean isSecurityEnabled = false;
    private String proxyHost = null;

    public WebAppProxy() {
        super(WebAppProxy.class.getName());
    }

    protected void serviceInit(Configuration conf) throws Exception {
        String auth = conf.get("hadoop.security.authentication");
        if (auth == null || "simple".equals(auth)) {
            this.isSecurityEnabled = false;
        } else if ("kerberos".equals(auth)) {
            this.isSecurityEnabled = true;
        } else {
            LOG.warn((Object)("Unrecongized attribute value for hadoop.security.authentication of " + auth));
        }
        String proxy = WebAppUtils.getProxyHostAndPort((Configuration)conf);
        String[] proxyParts = proxy.split(":");
        this.proxyHost = proxyParts[0];
        this.fetcher = new AppReportFetcher(conf);
        this.bindAddress = conf.get("yarn.web-proxy.address");
        if (this.bindAddress == null || this.bindAddress.isEmpty()) {
            throw new YarnRuntimeException("yarn.web-proxy.address is not set so the proxy will not run.");
        }
        LOG.info((Object)("Instantiating Proxy at " + this.bindAddress));
        String[] parts = StringUtils.split((String)this.bindAddress, (char)':');
        this.port = 0;
        if (parts.length == 2) {
            this.bindAddress = parts[0];
            this.port = Integer.parseInt(parts[1]);
        }
        this.acl = new AccessControlList(conf.get("yarn.admin.acl", "*"));
        super.serviceInit(conf);
    }

    protected void serviceStart() throws Exception {
        try {
            this.proxyServer = new HttpServer2.Builder().setName("proxy").addEndpoint(URI.create("http://" + this.bindAddress + ":" + this.port)).setFindPort(this.port == 0).setConf(this.getConfig()).setACL(this.acl).build();
            this.proxyServer.addServlet("proxy", "/proxy/*", WebAppProxyServlet.class);
            this.proxyServer.setAttribute(FETCHER_ATTRIBUTE, (Object)this.fetcher);
            this.proxyServer.setAttribute(IS_SECURITY_ENABLED_ATTRIBUTE, (Object)this.isSecurityEnabled);
            this.proxyServer.setAttribute(PROXY_HOST_ATTRIBUTE, (Object)this.proxyHost);
            this.proxyServer.start();
        }
        catch (IOException e) {
            LOG.fatal((Object)"Could not start proxy web server", (Throwable)e);
            throw new YarnRuntimeException("Could not start proxy web server", (Throwable)e);
        }
        super.serviceStart();
    }

    protected void serviceStop() throws Exception {
        if (this.proxyServer != null) {
            try {
                this.proxyServer.stop();
            }
            catch (Exception e) {
                LOG.fatal((Object)"Error stopping proxy web server", (Throwable)e);
                throw new YarnRuntimeException("Error stopping proxy web server", (Throwable)e);
            }
        }
        if (this.fetcher != null) {
            this.fetcher.stop();
        }
        super.serviceStop();
    }

    public void join() {
        if (this.proxyServer != null) {
            try {
                this.proxyServer.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    @VisibleForTesting
    String getBindAddress() {
        return this.bindAddress + ":" + this.port;
    }
}

