/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.aggregate;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.apache.flink.api.common.state.MapState;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.ListTypeInfo;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.ProcessFunction;
import org.apache.flink.streaming.api.operators.TimestampedCollector;
import org.apache.flink.table.api.StreamQueryConfig;
import org.apache.flink.table.codegen.Compiler;
import org.apache.flink.table.codegen.Compiler$class;
import org.apache.flink.table.codegen.GeneratedAggregationsFunction;
import org.apache.flink.table.runtime.aggregate.GeneratedAggregations;
import org.apache.flink.table.runtime.aggregate.ProcessFunctionWithCleanupState;
import org.apache.flink.table.runtime.types.CRow;
import org.apache.flink.table.runtime.types.CRowTypeInfo;
import org.apache.flink.types.Row;
import org.apache.flink.util.Collector;
import org.apache.flink.util.Preconditions;
import org.codehaus.commons.compiler.CompileException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005mf!B\u0001\u0003\u0003\u0003y!\u0001\u0006*poRKW.Z+oE>,h\u000eZ3e\u001fZ,'O\u0003\u0002\u0004\t\u0005I\u0011mZ4sK\u001e\fG/\u001a\u0006\u0003\u000b\u0019\tqA];oi&lWM\u0003\u0002\b\u0011\u0005)A/\u00192mK*\u0011\u0011BC\u0001\u0006M2Lgn\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001\u0001\"\u0004\u0005\u0003\u0012%Q!R\"\u0001\u0002\n\u0005M\u0011!a\b)s_\u000e,7o\u001d$v]\u000e$\u0018n\u001c8XSRD7\t\\3b]V\u00048\u000b^1uKB\u0011Q\u0003G\u0007\u0002-)\u0011q\u0003B\u0001\u0006if\u0004Xm]\u0005\u00033Y\u0011Aa\u0011*poB\u00191D\b\u0011\u000e\u0003qQ!!\b\u0004\u0002\u000f\r|G-Z4f]&\u0011q\u0004\b\u0002\t\u0007>l\u0007/\u001b7feB\u0011\u0011#I\u0005\u0003E\t\u0011QcR3oKJ\fG/\u001a3BO\u001e\u0014XmZ1uS>t7\u000f\u0003\u0005%\u0001\t\u0005\t\u0015!\u0003&\u0003=9WM\\!hOJ,w-\u0019;j_:\u001c\bCA\u000e'\u0013\t9CDA\u000fHK:,'/\u0019;fI\u0006;wM]3hCRLwN\\:Gk:\u001cG/[8o\u0011!I\u0003A!A!\u0002\u0013Q\u0013\u0001E5oi\u0016\u0014X.\u001a3jCR,G+\u001f9f!\rY#\u0007N\u0007\u0002Y)\u0011QFL\u0001\tif\u0004X-\u001b8g_*\u0011q\u0006M\u0001\u0007G>lWn\u001c8\u000b\u0005EB\u0011aA1qS&\u00111\u0007\f\u0002\u0010)f\u0004X-\u00138g_Jl\u0017\r^5p]B\u0011QgN\u0007\u0002m)\u0011q\u0003C\u0005\u0003qY\u00121AU8x\u0011!Q\u0004A!A!\u0002\u0013Y\u0014!C5oaV$H+\u001f9f!\rY#\u0007\u0006\u0005\t{\u0001\u0011\t\u0011)A\u0005}\u0005Y\u0011/^3ss\u000e{gNZ5h!\ty\u0014)D\u0001A\u0015\t\td!\u0003\u0002C\u0001\n\t2\u000b\u001e:fC6\fV/\u001a:z\u0007>tg-[4\t\u000b\u0011\u0003A\u0011A#\u0002\rqJg.\u001b;?)\u00151u\tS%K!\t\t\u0002\u0001C\u0003%\u0007\u0002\u0007Q\u0005C\u0003*\u0007\u0002\u0007!\u0006C\u0003;\u0007\u0002\u00071\bC\u0003>\u0007\u0002\u0007a\bC\u0005M\u0001\u0001\u0007\t\u0019!C\t\u001b\u00061q.\u001e;qkR,\u0012\u0001\u0006\u0005\n\u001f\u0002\u0001\r\u00111A\u0005\u0012A\u000b!b\\;uaV$x\fJ3r)\t\tv\u000b\u0005\u0002S+6\t1KC\u0001U\u0003\u0015\u00198-\u00197b\u0013\t16K\u0001\u0003V]&$\bb\u0002-O\u0003\u0003\u0005\r\u0001F\u0001\u0004q\u0012\n\u0004B\u0002.\u0001A\u0003&A#A\u0004pkR\u0004X\u000f\u001e\u0011\t\u0013q\u0003\u0001\u0019!a\u0001\n\u0013i\u0016\u0001E1dGVlW\u000f\\1u_J\u001cF/\u0019;f+\u0005q\u0006cA0ci5\t\u0001M\u0003\u0002b]\u0005)1\u000f^1uK&\u00111\r\u0019\u0002\u000b-\u0006dW/Z*uCR,\u0007\"C3\u0001\u0001\u0004\u0005\r\u0011\"\u0003g\u0003Q\t7mY;nk2\fGo\u001c:Ti\u0006$Xm\u0018\u0013fcR\u0011\u0011k\u001a\u0005\b1\u0012\f\t\u00111\u0001_\u0011\u0019I\u0007\u0001)Q\u0005=\u0006\t\u0012mY2v[Vd\u0017\r^8s'R\fG/\u001a\u0011\t\u0013-\u0004\u0001\u0019!a\u0001\n\u0013a\u0017a\u0003:po6\u000b\u0007o\u0015;bi\u0016,\u0012!\u001c\t\u0005?:\u00048/\u0003\u0002pA\nAQ*\u00199Ti\u0006$X\r\u0005\u0002Sc&\u0011!o\u0015\u0002\u0005\u0019>tw\rE\u0002usRj\u0011!\u001e\u0006\u0003m^\fA!\u001e;jY*\t\u00010\u0001\u0003kCZ\f\u0017B\u0001>v\u0005\u0011a\u0015n\u001d;\t\u0013q\u0004\u0001\u0019!a\u0001\n\u0013i\u0018a\u0004:po6\u000b\u0007o\u0015;bi\u0016|F%Z9\u0015\u0005Es\bb\u0002-|\u0003\u0003\u0005\r!\u001c\u0005\b\u0003\u0003\u0001\u0001\u0015)\u0003n\u00031\u0011xn^'baN#\u0018\r^3!\u0011-\t)\u0001\u0001a\u0001\u0002\u0004%I!a\u0002\u0002!M|'\u000f^3e)&lWm\u001d;b[B\u001cXCAA\u0005!\u0011!\u00181\u00029\n\u0007\u00055QO\u0001\u0006MS:\\W\r\u001a'jgRD1\"!\u0005\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\u0014\u0005!2o\u001c:uK\u0012$\u0016.\\3ti\u0006l\u0007o]0%KF$2!UA\u000b\u0011%A\u0016qBA\u0001\u0002\u0004\tI\u0001\u0003\u0005\u0002\u001a\u0001\u0001\u000b\u0015BA\u0005\u0003E\u0019xN\u001d;fIRKW.Z:uC6\u00048\u000f\t\u0005\n\u0003;\u0001!\u0019!C\u0001\u0003?\t1\u0001T(H+\t\t\t\u0003\u0005\u0003\u0002$\u0005%RBAA\u0013\u0015\r\t9\u0003D\u0001\u0006g24GG[\u0005\u0005\u0003W\t)C\u0001\u0004M_\u001e<WM\u001d\u0005\t\u0003_\u0001\u0001\u0015!\u0003\u0002\"\u0005!AjT$!\u0011-\t\u0019\u0004\u0001a\u0001\u0002\u0004%\t\"!\u000e\u0002\u0011\u0019,hn\u0019;j_:,\u0012\u0001\t\u0005\f\u0003s\u0001\u0001\u0019!a\u0001\n#\tY$\u0001\u0007gk:\u001cG/[8o?\u0012*\u0017\u000fF\u0002R\u0003{A\u0001\u0002WA\u001c\u0003\u0003\u0005\r\u0001\t\u0005\b\u0003\u0003\u0002\u0001\u0015)\u0003!\u0003%1WO\\2uS>t\u0007\u0005C\u0004\u0002F\u0001!\t%a\u0012\u0002\t=\u0004XM\u001c\u000b\u0004#\u0006%\u0003\u0002CA&\u0003\u0007\u0002\r!!\u0014\u0002\r\r|gNZ5h!\u0011\ty%!\u0016\u000e\u0005\u0005E#bAA*\u0011\u0005i1m\u001c8gS\u001e,(/\u0019;j_:LA!a\u0016\u0002R\ti1i\u001c8gS\u001e,(/\u0019;j_:Dq!a\u0017\u0001\t\u0003\ni&\u0001\bqe>\u001cWm]:FY\u0016lWM\u001c;\u0015\u000fE\u000by&a\u0019\u0002\u0000!9\u0011\u0011MA-\u0001\u0004!\u0012AB5oaV$8\t\u0003\u0005\u0002f\u0005e\u0003\u0019AA4\u0003\r\u0019G\u000f\u001f\t\u0005\u0003S\nY\b\u0005\u0004\u0002l\u0005]D\u0003F\u0007\u0003\u0003[RA!a\u001c\u0002r\u0005Ia-\u001e8di&|gn\u001d\u0006\u0004c\u0005M$bAA;\u0011\u0005I1\u000f\u001e:fC6LgnZ\u0005\u0005\u0003s\niGA\bQe>\u001cWm]:Gk:\u001cG/[8o\u0013\u0011\ti(a\u001e\u0003\u000f\r{g\u000e^3yi\"A\u0011\u0011QA-\u0001\u0004\t\u0019)A\u0002pkR\u0004R!!\"\u0002\nRi!!a\"\u000b\u0005YD\u0011\u0002BAF\u0003\u000f\u0013\u0011bQ8mY\u0016\u001cGo\u001c:\t\u000f\u0005=\u0005\u0001\"\u0011\u0002\u0012\u00069qN\u001c+j[\u0016\u0014HcB)\u0002\u0014\u0006]\u0015q\u0014\u0005\b\u0003+\u000bi\t1\u0001q\u0003%!\u0018.\\3ti\u0006l\u0007\u000f\u0003\u0005\u0002f\u00055\u0005\u0019AAM!\u0011\tI'a'\n\t\u0005u\u0015q\u000f\u0002\u000f\u001f:$\u0016.\\3s\u0007>tG/\u001a=u\u0011!\t\t)!$A\u0002\u0005\r\u0005bBAR\u0001\u0011%\u0011QU\u0001\u0013S:\u001cXM\u001d;U_N{'\u000f^3e\u0019&\u001cH\u000fF\u0002R\u0003OCq!!+\u0002\"\u0002\u0007\u0001/A\bsK\u000e|'\u000f\u001a+j[\u0016\u001cH/Y7q\u0011\u001d\ti\u000b\u0001D\u0001\u0003_\u000b\u0001\u0005\u001d:pG\u0016\u001c8/\u00127f[\u0016tGo],ji\"\u001c\u0016-\\3US6,7\u000f^1naR9\u0011+!-\u00026\u0006e\u0006bBAZ\u0003W\u0003\ra]\u0001\u000bGV\u0014(k\\<MSN$\bbBA\\\u0003W\u0003\r\u0001N\u0001\u0010Y\u0006\u001cH/Q2dk6,H.\u0019;pe\"A\u0011\u0011QAV\u0001\u0004\t\u0019\t")
public abstract class RowTimeUnboundedOver
extends ProcessFunctionWithCleanupState<CRow, CRow>
implements Compiler<GeneratedAggregations> {
    private final GeneratedAggregationsFunction genAggregations;
    private final TypeInformation<Row> intermediateType;
    private final TypeInformation<CRow> inputType;
    private CRow output;
    private ValueState<Row> accumulatorState;
    private MapState<Object, List<Row>> rowMapState;
    private LinkedList<Object> sortedTimestamps;
    private final Logger LOG;
    private GeneratedAggregations function;

    @Override
    public Class<GeneratedAggregations> compile(ClassLoader cl, String name, String code) throws CompileException {
        return Compiler$class.compile(this, cl, name, code);
    }

    public CRow output() {
        return this.output;
    }

    public void output_$eq(CRow x$1) {
        this.output = x$1;
    }

    private ValueState<Row> accumulatorState() {
        return this.accumulatorState;
    }

    private void accumulatorState_$eq(ValueState<Row> x$1) {
        this.accumulatorState = x$1;
    }

    private MapState<Object, List<Row>> rowMapState() {
        return this.rowMapState;
    }

    private void rowMapState_$eq(MapState<Object, List<Row>> x$1) {
        this.rowMapState = x$1;
    }

    private LinkedList<Object> sortedTimestamps() {
        return this.sortedTimestamps;
    }

    private void sortedTimestamps_$eq(LinkedList<Object> x$1) {
        this.sortedTimestamps = x$1;
    }

    public Logger LOG() {
        return this.LOG;
    }

    public GeneratedAggregations function() {
        return this.function;
    }

    public void function_$eq(GeneratedAggregations x$1) {
        this.function = x$1;
    }

    public void open(Configuration config) {
        this.LOG().debug(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Compiling AggregateHelper: ", " \\n\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.genAggregations.name()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Code:\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.genAggregations.code()}))).toString());
        Class<GeneratedAggregations> clazz = this.compile(this.getRuntimeContext().getUserCodeClassLoader(), this.genAggregations.name(), this.genAggregations.code());
        this.LOG().debug("Instantiating AggregateHelper.");
        this.function_$eq(clazz.newInstance());
        this.output_$eq(new CRow(this.function().createOutputRow(), true));
        this.sortedTimestamps_$eq(new LinkedList<Object>());
        ValueStateDescriptor accDescriptor = new ValueStateDescriptor("accumulatorstate", this.intermediateType);
        this.accumulatorState_$eq((ValueState<Row>)this.getRuntimeContext().getState(accDescriptor));
        ListTypeInfo rowListTypeInfo = new ListTypeInfo((TypeInformation)((CRowTypeInfo)this.inputType).rowType());
        MapStateDescriptor mapStateDescriptor = new MapStateDescriptor("rowmapstate", (TypeInformation)BasicTypeInfo.LONG_TYPE_INFO, (TypeInformation)rowListTypeInfo);
        this.rowMapState_$eq((MapState<Object, List<Row>>)this.getRuntimeContext().getMapState(mapStateDescriptor));
        this.initCleanupTimeState("RowTimeUnboundedOverCleanupTime");
    }

    public void processElement(CRow inputC, ProcessFunction.Context ctx, Collector<CRow> out) {
        Row input = inputC.row();
        this.registerProcessingCleanupTimer(ctx, ctx.timerService().currentProcessingTime());
        Long timestamp = ctx.timestamp();
        long curWatermark = ctx.timerService().currentWatermark();
        if (Predef$.MODULE$.Long2long(timestamp) >= curWatermark) {
            ctx.timerService().registerEventTimeTimer(curWatermark + 1L);
            ArrayList<Row> rowList = (ArrayList<Row>)this.rowMapState().get((Object)BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(timestamp)));
            if (rowList == null) {
                rowList = new ArrayList<Row>();
            }
            rowList.add(input);
            this.rowMapState().put((Object)BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(timestamp)), rowList);
        }
    }

    public void onTimer(long timestamp, ProcessFunction.OnTimerContext ctx, Collector<CRow> out) {
        if (this.isProcessingTimeTimer(ctx)) {
            if (this.needToCleanupState(timestamp)) {
                boolean noRecordsToProcess;
                boolean bl = noRecordsToProcess = !this.rowMapState().keys().iterator().hasNext();
                if (noRecordsToProcess) {
                    this.cleanupState((Seq<State>)Predef$.MODULE$.wrapRefArray((Object[])new State[]{this.rowMapState(), this.accumulatorState()}));
                } else {
                    this.registerProcessingCleanupTimer((ProcessFunction.Context)ctx, ctx.timerService().currentProcessingTime());
                }
            }
            return;
        }
        Preconditions.checkArgument((boolean)(out instanceof TimestampedCollector));
        TimestampedCollector collector = (TimestampedCollector)out;
        Iterator keyIterator = this.rowMapState().keys().iterator();
        if (keyIterator.hasNext()) {
            long curWatermark = ctx.timerService().currentWatermark();
            boolean existEarlyRecord = false;
            do {
                long recordTime;
                if ((recordTime = BoxesRunTime.unboxToLong(keyIterator.next())) <= curWatermark) {
                    this.insertToSortedList(recordTime);
                    continue;
                }
                existEarlyRecord = true;
            } while (keyIterator.hasNext());
            Row lastAccumulator = (Row)this.accumulatorState().value();
            if (lastAccumulator == null) {
                lastAccumulator = this.function().createAccumulators();
            }
            while (true) {
                if (this.sortedTimestamps().isEmpty()) {
                    this.accumulatorState().update((Object)lastAccumulator);
                    if (!existEarlyRecord) break;
                    ctx.timerService().registerEventTimeTimer(curWatermark + 1L);
                    break;
                }
                long curTimestamp = BoxesRunTime.unboxToLong((Object)this.sortedTimestamps().removeFirst());
                List curRowList = (List)this.rowMapState().get((Object)BoxesRunTime.boxToLong((long)curTimestamp));
                collector.setAbsoluteTimestamp(curTimestamp);
                this.processElementsWithSameTimestamp(curRowList, lastAccumulator, (Collector<CRow>)collector);
                this.rowMapState().remove((Object)BoxesRunTime.boxToLong((long)curTimestamp));
            }
        }
        this.registerProcessingCleanupTimer((ProcessFunction.Context)ctx, ctx.timerService().currentProcessingTime());
    }

    private void insertToSortedList(long recordTimestamp) {
        ListIterator<Object> listIterator = this.sortedTimestamps().listIterator(this.sortedTimestamps().size());
        boolean bl = true;
        while (listIterator.hasPrevious() && bl) {
            long timestamp = BoxesRunTime.unboxToLong((Object)listIterator.previous());
            if (recordTimestamp < timestamp) continue;
            listIterator.next();
            listIterator.add(BoxesRunTime.boxToLong((long)recordTimestamp));
            bl = false;
        }
        if (bl) {
            this.sortedTimestamps().addFirst(BoxesRunTime.boxToLong((long)recordTimestamp));
        }
    }

    public abstract void processElementsWithSameTimestamp(List<Row> var1, Row var2, Collector<CRow> var3);

    public RowTimeUnboundedOver(GeneratedAggregationsFunction genAggregations, TypeInformation<Row> intermediateType, TypeInformation<CRow> inputType, StreamQueryConfig queryConfig) {
        this.genAggregations = genAggregations;
        this.intermediateType = intermediateType;
        this.inputType = inputType;
        super(queryConfig);
        Compiler$class.$init$(this);
        this.LOG = LoggerFactory.getLogger(this.getClass());
    }
}

