/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.aggregate;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.api.common.state.MapState;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.ListTypeInfo;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.ProcessFunction;
import org.apache.flink.table.api.StreamQueryConfig;
import org.apache.flink.table.codegen.Compiler;
import org.apache.flink.table.codegen.Compiler$class;
import org.apache.flink.table.codegen.GeneratedAggregationsFunction;
import org.apache.flink.table.runtime.aggregate.GeneratedAggregations;
import org.apache.flink.table.runtime.aggregate.ProcessFunctionWithCleanupState;
import org.apache.flink.table.runtime.types.CRow;
import org.apache.flink.table.runtime.types.CRowTypeInfo;
import org.apache.flink.types.Row;
import org.apache.flink.util.Collector;
import org.apache.flink.util.Preconditions;
import org.codehaus.commons.compiler.CompileException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005%f\u0001B\u0001\u0003\u0001=\u0011qCU8x)&lWMQ8v]\u0012,GMU1oO\u0016|e/\u001a:\u000b\u0005\r!\u0011!C1hOJ,w-\u0019;f\u0015\t)a!A\u0004sk:$\u0018.\\3\u000b\u0005\u001dA\u0011!\u0002;bE2,'BA\u0005\u000b\u0003\u00151G.\u001b8l\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001M\u0019\u0001\u0001\u0005\u000e\u0011\tE\u0011B\u0003F\u0007\u0002\u0005%\u00111C\u0001\u0002 !J|7-Z:t\rVt7\r^5p]^KG\u000f[\"mK\u0006tW\u000f]*uCR,\u0007CA\u000b\u0019\u001b\u00051\"BA\f\u0005\u0003\u0015!\u0018\u0010]3t\u0013\tIbC\u0001\u0003D%><\bcA\u000e\u001fA5\tAD\u0003\u0002\u001e\r\u000591m\u001c3fO\u0016t\u0017BA\u0010\u001d\u0005!\u0019u.\u001c9jY\u0016\u0014\bCA\t\"\u0013\t\u0011#AA\u000bHK:,'/\u0019;fI\u0006;wM]3hCRLwN\\:\t\u0011\u0011\u0002!\u0011!Q\u0001\n\u0015\nqbZ3o\u0003\u001e<'/Z4bi&|gn\u001d\t\u00037\u0019J!a\n\u000f\u0003;\u001d+g.\u001a:bi\u0016$\u0017iZ4sK\u001e\fG/[8og\u001a+hn\u0019;j_:D\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006IAK\u0001\u0015C\u001e<'/Z4bi&|gn\u0015;bi\u0016$\u0016\u0010]3\u0011\u0005-\u0012T\"\u0001\u0017\u000b\u00055r\u0013!\u0003;za\u0016,H/\u001b7t\u0015\ty\u0003'\u0001\u0003kCZ\f'BA\u0019\t\u0003\r\t\u0007/[\u0005\u0003g1\u00121BU8x)f\u0004X-\u00138g_\"AQ\u0007\u0001B\u0001B\u0003%a'\u0001\u0007j]B,HOU8x)f\u0004X\r\u0005\u0002\u0016o%\u0011\u0001H\u0006\u0002\r\u0007J{w\u000fV=qK&sgm\u001c\u0005\tu\u0001\u0011\t\u0011)A\u0005w\u0005y\u0001O]3dK\u0012LgnZ(gMN,G\u000f\u0005\u0002=\u007f5\tQHC\u0001?\u0003\u0015\u00198-\u00197b\u0013\t\u0001UH\u0001\u0003M_:<\u0007\u0002\u0003\"\u0001\u0005\u0003\u0005\u000b\u0011B\"\u0002\u0017E,XM]=D_:4\u0017n\u001a\t\u0003\t\u001ak\u0011!\u0012\u0006\u0003c\u0019I!aR#\u0003#M#(/Z1n#V,'/_\"p]\u001aLw\rC\u0003J\u0001\u0011\u0005!*\u0001\u0004=S:LGO\u0010\u000b\u0007\u00172kej\u0014)\u0011\u0005E\u0001\u0001\"\u0002\u0013I\u0001\u0004)\u0003\"B\u0015I\u0001\u0004Q\u0003\"B\u001bI\u0001\u00041\u0004\"\u0002\u001eI\u0001\u0004Y\u0004\"\u0002\"I\u0001\u0004\u0019\u0005\"\u0003*\u0001\u0001\u0004\u0005\r\u0011\"\u0003T\u0003\u0019yW\u000f\u001e9viV\tA\u0003C\u0005V\u0001\u0001\u0007\t\u0019!C\u0005-\u0006Qq.\u001e;qkR|F%Z9\u0015\u0005]S\u0006C\u0001\u001fY\u0013\tIVH\u0001\u0003V]&$\bbB.U\u0003\u0003\u0005\r\u0001F\u0001\u0004q\u0012\n\u0004BB/\u0001A\u0003&A#A\u0004pkR\u0004X\u000f\u001e\u0011\t\u0013}\u0003\u0001\u0019!a\u0001\n\u0013\u0001\u0017!\u00067bgR$&/[4hKJLgn\u001a+t'R\fG/Z\u000b\u0002CB\u0019!mZ\u001e\u000e\u0003\rT!\u0001Z3\u0002\u000bM$\u0018\r^3\u000b\u0005\u0019\u0004\u0014AB2p[6|g.\u0003\u0002iG\nQa+\u00197vKN#\u0018\r^3\t\u0013)\u0004\u0001\u0019!a\u0001\n\u0013Y\u0017!\u00077bgR$&/[4hKJLgn\u001a+t'R\fG/Z0%KF$\"a\u00167\t\u000fmK\u0017\u0011!a\u0001C\"1a\u000e\u0001Q!\n\u0005\fa\u0003\\1tiR\u0013\u0018nZ4fe&tw\rV:Ti\u0006$X\r\t\u0005\na\u0002\u0001\r\u00111A\u0005\nE\f\u0001#Y2dk6,H.\u0019;peN#\u0018\r^3\u0016\u0003I\u00042AY4t!\t!h/D\u0001v\u0015\t9\u0002\"\u0003\u0002xk\n\u0019!k\\<\t\u0013e\u0004\u0001\u0019!a\u0001\n\u0013Q\u0018\u0001F1dGVlW\u000f\\1u_J\u001cF/\u0019;f?\u0012*\u0017\u000f\u0006\u0002Xw\"91\f_A\u0001\u0002\u0004\u0011\bBB?\u0001A\u0003&!/A\tbG\u000e,X.\u001e7bi>\u00148\u000b^1uK\u0002B!b \u0001A\u0002\u0003\u0007I\u0011BA\u0001\u0003%!\u0017\r^1Ti\u0006$X-\u0006\u0002\u0002\u0004A1!-!\u0002<\u0003\u0013I1!a\u0002d\u0005!i\u0015\r]*uCR,\u0007#BA\u0006\u0003'\u0019XBAA\u0007\u0015\u0011\ty!!\u0005\u0002\tU$\u0018\u000e\u001c\u0006\u0002_%!\u0011QCA\u0007\u0005\u0011a\u0015n\u001d;\t\u0017\u0005e\u0001\u00011AA\u0002\u0013%\u00111D\u0001\u000eI\u0006$\u0018m\u0015;bi\u0016|F%Z9\u0015\u0007]\u000bi\u0002C\u0005\\\u0003/\t\t\u00111\u0001\u0002\u0004!A\u0011\u0011\u0005\u0001!B\u0013\t\u0019!\u0001\u0006eCR\f7\u000b^1uK\u0002B\u0011\"!\n\u0001\u0005\u0004%\t!a\n\u0002\u00071{u)\u0006\u0002\u0002*A!\u00111FA\u0019\u001b\t\tiCC\u0002\u000201\tQa\u001d7gi)LA!a\r\u0002.\t1Aj\\4hKJD\u0001\"a\u000e\u0001A\u0003%\u0011\u0011F\u0001\u0005\u0019>;\u0005\u0005C\u0006\u0002<\u0001\u0001\r\u00111A\u0005\n\u0005u\u0012\u0001\u00034v]\u000e$\u0018n\u001c8\u0016\u0003\u0001B1\"!\u0011\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002D\u0005aa-\u001e8di&|gn\u0018\u0013fcR\u0019q+!\u0012\t\u0011m\u000by$!AA\u0002\u0001Bq!!\u0013\u0001A\u0003&\u0001%A\u0005gk:\u001cG/[8oA!9\u0011Q\n\u0001\u0005B\u0005=\u0013\u0001B8qK:$2aVA)\u0011!\t\u0019&a\u0013A\u0002\u0005U\u0013AB2p]\u001aLw\r\u0005\u0003\u0002X\u0005uSBAA-\u0015\r\tY\u0006C\u0001\u000eG>tg-[4ve\u0006$\u0018n\u001c8\n\t\u0005}\u0013\u0011\f\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\t\u000f\u0005\r\u0004\u0001\"\u0011\u0002f\u0005q\u0001O]8dKN\u001cX\t\\3nK:$HcB,\u0002h\u0005-\u0014q\u0011\u0005\b\u0003S\n\t\u00071\u0001\u0015\u0003\u0019Ig\u000e];u\u0007\"A\u0011QNA1\u0001\u0004\ty'A\u0002dib\u0004B!!\u001d\u0002\u0004B1\u00111OA@)Qi!!!\u001e\u000b\t\u0005]\u0014\u0011P\u0001\nMVt7\r^5p]NT1!MA>\u0015\r\ti\bC\u0001\ngR\u0014X-Y7j]\u001eLA!!!\u0002v\ty\u0001K]8dKN\u001ch)\u001e8di&|g.\u0003\u0003\u0002\u0006\u0006}$aB\"p]R,\u0007\u0010\u001e\u0005\t\u0003\u0013\u000b\t\u00071\u0001\u0002\f\u0006\u0019q.\u001e;\u0011\u000b\u00055\u0015\u0011\u0013\u000b\u000e\u0005\u0005=%bAA\b\u0011%!\u00111SAH\u0005%\u0019u\u000e\u001c7fGR|'\u000fC\u0004\u0002\u0018\u0002!\t%!'\u0002\u000f=tG+[7feR9q+a'\u0002 \u0006\u001d\u0006bBAO\u0003+\u0003\raO\u0001\ni&lWm\u001d;b[BD\u0001\"!\u001c\u0002\u0016\u0002\u0007\u0011\u0011\u0015\t\u0005\u0003c\n\u0019+\u0003\u0003\u0002&\u0006}$AD(o)&lWM]\"p]R,\u0007\u0010\u001e\u0005\t\u0003\u0013\u000b)\n1\u0001\u0002\f\u0002")
public class RowTimeBoundedRangeOver
extends ProcessFunctionWithCleanupState<CRow, CRow>
implements Compiler<GeneratedAggregations> {
    private final GeneratedAggregationsFunction genAggregations;
    private final RowTypeInfo aggregationStateType;
    private final CRowTypeInfo inputRowType;
    private final long precedingOffset;
    private CRow output;
    private ValueState<Object> lastTriggeringTsState;
    private ValueState<Row> accumulatorState;
    private MapState<Object, List<Row>> dataState;
    private final Logger LOG;
    private GeneratedAggregations function;

    @Override
    public Class<GeneratedAggregations> compile(ClassLoader cl, String name, String code) throws CompileException {
        return Compiler$class.compile(this, cl, name, code);
    }

    private CRow output() {
        return this.output;
    }

    private void output_$eq(CRow x$1) {
        this.output = x$1;
    }

    private ValueState<Object> lastTriggeringTsState() {
        return this.lastTriggeringTsState;
    }

    private void lastTriggeringTsState_$eq(ValueState<Object> x$1) {
        this.lastTriggeringTsState = x$1;
    }

    private ValueState<Row> accumulatorState() {
        return this.accumulatorState;
    }

    private void accumulatorState_$eq(ValueState<Row> x$1) {
        this.accumulatorState = x$1;
    }

    private MapState<Object, List<Row>> dataState() {
        return this.dataState;
    }

    private void dataState_$eq(MapState<Object, List<Row>> x$1) {
        this.dataState = x$1;
    }

    public Logger LOG() {
        return this.LOG;
    }

    private GeneratedAggregations function() {
        return this.function;
    }

    private void function_$eq(GeneratedAggregations x$1) {
        this.function = x$1;
    }

    public void open(Configuration config) {
        this.LOG().debug(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Compiling AggregateHelper: ", " \\n\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.genAggregations.name()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Code:\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.genAggregations.code()}))).toString());
        Class<GeneratedAggregations> clazz = this.compile(this.getRuntimeContext().getUserCodeClassLoader(), this.genAggregations.name(), this.genAggregations.code());
        this.LOG().debug("Instantiating AggregateHelper.");
        this.function_$eq(clazz.newInstance());
        this.output_$eq(new CRow(this.function().createOutputRow(), true));
        ValueStateDescriptor lastTriggeringTsDescriptor = new ValueStateDescriptor("lastTriggeringTsState", Long.TYPE);
        this.lastTriggeringTsState_$eq((ValueState<Object>)this.getRuntimeContext().getState(lastTriggeringTsDescriptor));
        ValueStateDescriptor accumulatorStateDescriptor = new ValueStateDescriptor("accumulatorState", (TypeInformation)this.aggregationStateType);
        this.accumulatorState_$eq((ValueState<Row>)this.getRuntimeContext().getState(accumulatorStateDescriptor));
        BasicTypeInfo keyTypeInformation = BasicTypeInfo.LONG_TYPE_INFO;
        ListTypeInfo valueTypeInformation = new ListTypeInfo((TypeInformation)this.inputRowType.rowType());
        MapStateDescriptor mapStateDescriptor = new MapStateDescriptor("dataState", (TypeInformation)keyTypeInformation, (TypeInformation)valueTypeInformation);
        this.dataState_$eq((MapState<Object, List<Row>>)this.getRuntimeContext().getMapState(mapStateDescriptor));
        this.initCleanupTimeState("RowTimeBoundedRangeOverCleanupTime");
    }

    public void processElement(CRow inputC, ProcessFunction.Context ctx, Collector<CRow> out) {
        Row input = inputC.row();
        this.registerProcessingCleanupTimer(ctx, ctx.timerService().currentProcessingTime());
        Long triggeringTs = ctx.timestamp();
        long lastTriggeringTs = BoxesRunTime.unboxToLong((Object)this.lastTriggeringTsState().value());
        if (Predef$.MODULE$.Long2long(triggeringTs) > lastTriggeringTs) {
            List data = (List)this.dataState().get((Object)BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(triggeringTs)));
            if (data == null) {
                ArrayList<Row> data2 = new ArrayList<Row>();
                data2.add(input);
                this.dataState().put((Object)BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(triggeringTs)), data2);
                ctx.timerService().registerEventTimeTimer(Predef$.MODULE$.Long2long(triggeringTs));
            } else {
                data.add(input);
                this.dataState().put((Object)BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(triggeringTs)), (Object)data);
            }
        }
    }

    public void onTimer(long timestamp, ProcessFunction.OnTimerContext ctx, Collector<CRow> out) {
        if (this.isProcessingTimeTimer(ctx)) {
            if (this.needToCleanupState(timestamp)) {
                Iterator keysIt = this.dataState().keys().iterator();
                long lastProcessedTime = BoxesRunTime.unboxToLong((Object)this.lastTriggeringTsState().value());
                boolean noRecordsToProcess = true;
                while (keysIt.hasNext() && noRecordsToProcess) {
                    if (BoxesRunTime.unboxToLong(keysIt.next()) <= lastProcessedTime) continue;
                    noRecordsToProcess = false;
                }
                if (noRecordsToProcess) {
                    this.cleanupState((Seq<State>)Predef$.MODULE$.wrapRefArray((Object[])new State[]{this.dataState(), this.accumulatorState(), this.lastTriggeringTsState()}));
                } else {
                    this.registerProcessingCleanupTimer((ProcessFunction.Context)ctx, ctx.timerService().currentProcessingTime());
                }
            }
            return;
        }
        List inputs = (List)this.dataState().get((Object)BoxesRunTime.boxToLong((long)timestamp));
        if (inputs != null) {
            Row accumulators = (Row)this.accumulatorState().value();
            int dataListIndex = 0;
            boolean aggregatesIndex = false;
            if (accumulators == null) {
                accumulators = this.function().createAccumulators();
                aggregatesIndex = false;
            }
            ArrayList<Long> retractTsList = new ArrayList<Long>();
            Iterator dataTimestampIt = this.dataState().keys().iterator();
            while (dataTimestampIt.hasNext()) {
                Object object;
                long dataTs = BoxesRunTime.unboxToLong(dataTimestampIt.next());
                long offset = timestamp - dataTs;
                if (offset > this.precedingOffset) {
                    List retractDataList = (List)this.dataState().get((Object)BoxesRunTime.boxToLong((long)dataTs));
                    for (dataListIndex = 0; dataListIndex < retractDataList.size(); ++dataListIndex) {
                        Row retractRow = (Row)retractDataList.get(dataListIndex);
                        this.function().retract(accumulators, retractRow);
                    }
                    object = BoxesRunTime.boxToBoolean((boolean)retractTsList.add(BoxesRunTime.boxToLong((long)dataTs)));
                    continue;
                }
                object = BoxedUnit.UNIT;
            }
            for (dataListIndex = 0; dataListIndex < inputs.size(); ++dataListIndex) {
                Row curRow = (Row)inputs.get(dataListIndex);
                this.function().accumulate(accumulators, curRow);
            }
            this.function().setAggregationResults(accumulators, this.output().row());
            for (dataListIndex = 0; dataListIndex < inputs.size(); ++dataListIndex) {
                aggregatesIndex = false;
                this.function().setForwardedFields((Row)inputs.get(dataListIndex), this.output().row());
                out.collect((Object)this.output());
            }
            for (dataListIndex = 0; dataListIndex < retractTsList.size(); ++dataListIndex) {
                this.dataState().remove(retractTsList.get(dataListIndex));
            }
            this.accumulatorState().update((Object)accumulators);
        }
        this.lastTriggeringTsState().update((Object)BoxesRunTime.boxToLong((long)timestamp));
        this.registerProcessingCleanupTimer((ProcessFunction.Context)ctx, ctx.timerService().currentProcessingTime());
    }

    public RowTimeBoundedRangeOver(GeneratedAggregationsFunction genAggregations, RowTypeInfo aggregationStateType, CRowTypeInfo inputRowType, long precedingOffset, StreamQueryConfig queryConfig) {
        this.genAggregations = genAggregations;
        this.aggregationStateType = aggregationStateType;
        this.inputRowType = inputRowType;
        this.precedingOffset = precedingOffset;
        super(queryConfig);
        Compiler$class.$init$(this);
        Preconditions.checkNotNull((Object)aggregationStateType);
        Preconditions.checkNotNull((Object)BoxesRunTime.boxToLong((long)precedingOffset));
        this.LOG = LoggerFactory.getLogger(this.getClass());
    }
}

