/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.aggregate;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.api.common.state.MapState;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.ListTypeInfo;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.ProcessFunction;
import org.apache.flink.table.api.StreamQueryConfig;
import org.apache.flink.table.codegen.Compiler;
import org.apache.flink.table.codegen.Compiler$class;
import org.apache.flink.table.codegen.GeneratedAggregationsFunction;
import org.apache.flink.table.runtime.aggregate.GeneratedAggregations;
import org.apache.flink.table.runtime.aggregate.ProcessFunctionWithCleanupState;
import org.apache.flink.table.runtime.types.CRow;
import org.apache.flink.table.runtime.types.CRowTypeInfo;
import org.apache.flink.types.Row;
import org.apache.flink.util.Collector;
import org.apache.flink.util.Preconditions;
import org.codehaus.commons.compiler.CompileException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005}f\u0001B\u0001\u0003\u0001=\u0011q\u0003\u0015:pGRKW.\u001a\"pk:$W\r\u001a*poN|e/\u001a:\u000b\u0005\r!\u0011!C1hOJ,w-\u0019;f\u0015\t)a!A\u0004sk:$\u0018.\\3\u000b\u0005\u001dA\u0011!\u0002;bE2,'BA\u0005\u000b\u0003\u00151G.\u001b8l\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001M\u0019\u0001\u0001\u0005\u000e\u0011\tE\u0011B\u0003F\u0007\u0002\u0005%\u00111C\u0001\u0002 !J|7-Z:t\rVt7\r^5p]^KG\u000f[\"mK\u0006tW\u000f]*uCR,\u0007CA\u000b\u0019\u001b\u00051\"BA\f\u0005\u0003\u0015!\u0018\u0010]3t\u0013\tIbC\u0001\u0003D%><\bcA\u000e\u001fA5\tAD\u0003\u0002\u001e\r\u000591m\u001c3fO\u0016t\u0017BA\u0010\u001d\u0005!\u0019u.\u001c9jY\u0016\u0014\bCA\t\"\u0013\t\u0011#AA\u000bHK:,'/\u0019;fI\u0006;wM]3hCRLwN\\:\t\u0011\u0011\u0002!\u0011!Q\u0001\n\u0015\nqbZ3o\u0003\u001e<'/Z4bi&|gn\u001d\t\u00037\u0019J!a\n\u000f\u0003;\u001d+g.\u001a:bi\u0016$\u0017iZ4sK\u001e\fG/[8og\u001a+hn\u0019;j_:D\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006IAK\u0001\u0010aJ,7-\u001a3j]\u001e|eMZ:fiB\u00111FL\u0007\u0002Y)\tQ&A\u0003tG\u0006d\u0017-\u0003\u00020Y\t!Aj\u001c8h\u0011!\t\u0004A!A!\u0002\u0013\u0011\u0014AE1hOJ,w-\u0019;fgRK\b/Z%oM>\u0004\"a\r\u001e\u000e\u0003QR!!\u000e\u001c\u0002\u0013QL\b/Z;uS2\u001c(BA\u001c9\u0003\u0011Q\u0017M^1\u000b\u0005eB\u0011aA1qS&\u00111\b\u000e\u0002\f%><H+\u001f9f\u0013:4w\u000e\u0003\u0005>\u0001\t\u0005\t\u0015!\u0003?\u0003%Ig\u000e];u)f\u0004X\rE\u0002@\tRi\u0011\u0001\u0011\u0006\u0003\u0003\n\u000b\u0001\u0002^=qK&tgm\u001c\u0006\u0003\u0007b\naaY8n[>t\u0017BA#A\u0005=!\u0016\u0010]3J]\u001a|'/\\1uS>t\u0007\u0002C$\u0001\u0005\u0003\u0005\u000b\u0011\u0002%\u0002\u0017E,XM]=D_:4\u0017n\u001a\t\u0003\u0013.k\u0011A\u0013\u0006\u0003s\u0019I!\u0001\u0014&\u0003#M#(/Z1n#V,'/_\"p]\u001aLw\rC\u0003O\u0001\u0011\u0005q*\u0001\u0004=S:LGO\u0010\u000b\u0007!F\u00136\u000bV+\u0011\u0005E\u0001\u0001\"\u0002\u0013N\u0001\u0004)\u0003\"B\u0015N\u0001\u0004Q\u0003\"B\u0019N\u0001\u0004\u0011\u0004\"B\u001fN\u0001\u0004q\u0004\"B$N\u0001\u0004A\u0005\"C,\u0001\u0001\u0004\u0005\r\u0011\"\u0003Y\u0003A\t7mY;nk2\fGo\u001c:Ti\u0006$X-F\u0001Z!\rQVlX\u0007\u00027*\u0011ALQ\u0001\u0006gR\fG/Z\u0005\u0003=n\u0013!BV1mk\u0016\u001cF/\u0019;f!\t\u0001'-D\u0001b\u0015\t9\u0002\"\u0003\u0002dC\n\u0019!k\\<\t\u0013\u0015\u0004\u0001\u0019!a\u0001\n\u00131\u0017\u0001F1dGVlW\u000f\\1u_J\u001cF/\u0019;f?\u0012*\u0017\u000f\u0006\u0002hUB\u00111\u0006[\u0005\u0003S2\u0012A!\u00168ji\"91\u000eZA\u0001\u0002\u0004I\u0016a\u0001=%c!1Q\u000e\u0001Q!\ne\u000b\u0011#Y2dk6,H.\u0019;peN#\u0018\r^3!\u0011%y\u0007\u00011AA\u0002\u0013%\u0001/A\u0006s_^l\u0015\r]*uCR,W#A9\u0011\ti\u0013(\u0006^\u0005\u0003gn\u0013\u0001\"T1q'R\fG/\u001a\t\u0004kf|V\"\u0001<\u000b\u0005]D\u0018\u0001B;uS2T\u0011aN\u0005\u0003uZ\u0014A\u0001T5ti\"IA\u0010\u0001a\u0001\u0002\u0004%I!`\u0001\u0010e><X*\u00199Ti\u0006$Xm\u0018\u0013fcR\u0011qM \u0005\bWn\f\t\u00111\u0001r\u0011\u001d\t\t\u0001\u0001Q!\nE\fAB]8x\u001b\u0006\u00048\u000b^1uK\u0002B1\"!\u0002\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\b\u00051q.\u001e;qkR,\u0012\u0001\u0006\u0005\f\u0003\u0017\u0001\u0001\u0019!a\u0001\n\u0013\ti!\u0001\u0006pkR\u0004X\u000f^0%KF$2aZA\b\u0011!Y\u0017\u0011BA\u0001\u0002\u0004!\u0002bBA\n\u0001\u0001\u0006K\u0001F\u0001\b_V$\b/\u001e;!\u0011-\t9\u0002\u0001a\u0001\u0002\u0004%I!!\u0007\u0002\u0019\r|WO\u001c;feN#\u0018\r^3\u0016\u0005\u0005m\u0001c\u0001.^U!Y\u0011q\u0004\u0001A\u0002\u0003\u0007I\u0011BA\u0011\u0003A\u0019w.\u001e8uKJ\u001cF/\u0019;f?\u0012*\u0017\u000fF\u0002h\u0003GA\u0011b[A\u000f\u0003\u0003\u0005\r!a\u0007\t\u0011\u0005\u001d\u0002\u0001)Q\u0005\u00037\tQbY8v]R,'o\u0015;bi\u0016\u0004\u0003bCA\u0016\u0001\u0001\u0007\t\u0019!C\u0005\u00033\tqb]7bY2,7\u000f\u001e+t'R\fG/\u001a\u0005\f\u0003_\u0001\u0001\u0019!a\u0001\n\u0013\t\t$A\nt[\u0006dG.Z:u)N\u001cF/\u0019;f?\u0012*\u0017\u000fF\u0002h\u0003gA\u0011b[A\u0017\u0003\u0003\u0005\r!a\u0007\t\u0011\u0005]\u0002\u0001)Q\u0005\u00037\t\u0001c]7bY2,7\u000f\u001e+t'R\fG/\u001a\u0011\t\u0013\u0005m\u0002A1A\u0005\u0002\u0005u\u0012a\u0001'P\u000fV\u0011\u0011q\b\t\u0005\u0003\u0003\n9%\u0004\u0002\u0002D)\u0019\u0011Q\t\u0007\u0002\u000bMdg\r\u000e6\n\t\u0005%\u00131\t\u0002\u0007\u0019><w-\u001a:\t\u0011\u00055\u0003\u0001)A\u0005\u0003\u007f\tA\u0001T(HA!Y\u0011\u0011\u000b\u0001A\u0002\u0003\u0007I\u0011BA*\u0003!1WO\\2uS>tW#\u0001\u0011\t\u0017\u0005]\u0003\u00011AA\u0002\u0013%\u0011\u0011L\u0001\rMVt7\r^5p]~#S-\u001d\u000b\u0004O\u0006m\u0003\u0002C6\u0002V\u0005\u0005\t\u0019\u0001\u0011\t\u000f\u0005}\u0003\u0001)Q\u0005A\u0005Ia-\u001e8di&|g\u000e\t\u0005\b\u0003G\u0002A\u0011IA3\u0003\u0011y\u0007/\u001a8\u0015\u0007\u001d\f9\u0007\u0003\u0005\u0002j\u0005\u0005\u0004\u0019AA6\u0003\u0019\u0019wN\u001c4jOB!\u0011QNA:\u001b\t\tyGC\u0002\u0002r!\tQbY8oM&<WO]1uS>t\u0017\u0002BA;\u0003_\u0012QbQ8oM&<WO]1uS>t\u0007bBA=\u0001\u0011\u0005\u00131P\u0001\u000faJ|7-Z:t\u000b2,W.\u001a8u)\u001d9\u0017QPAA\u0003;Cq!a \u0002x\u0001\u0007A#\u0001\u0004j]B,Ho\u0011\u0005\t\u0003\u0007\u000b9\b1\u0001\u0002\u0006\u0006\u00191\r\u001e=\u0011\t\u0005\u001d\u0015\u0011\u0014\t\u0007\u0003\u0013\u000b)\n\u0006\u000b\u000e\u0005\u0005-%\u0002BAG\u0003\u001f\u000b\u0011BZ;oGRLwN\\:\u000b\u0007e\n\tJC\u0002\u0002\u0014\"\t\u0011b\u001d;sK\u0006l\u0017N\\4\n\t\u0005]\u00151\u0012\u0002\u0010!J|7-Z:t\rVt7\r^5p]&!\u00111TAK\u0005\u001d\u0019uN\u001c;fqRD\u0001\"a(\u0002x\u0001\u0007\u0011\u0011U\u0001\u0004_V$\b#BAR\u0003O#RBAAS\u0015\t9\b\"\u0003\u0003\u0002*\u0006\u0015&!C\"pY2,7\r^8s\u0011\u001d\ti\u000b\u0001C!\u0003_\u000bqa\u001c8US6,'\u000fF\u0004h\u0003c\u000b),!0\t\u000f\u0005M\u00161\u0016a\u0001U\u0005IA/[7fgR\fW\u000e\u001d\u0005\t\u0003\u0007\u000bY\u000b1\u0001\u00028B!\u0011qQA]\u0013\u0011\tY,!&\u0003\u001d=sG+[7fe\u000e{g\u000e^3yi\"A\u0011qTAV\u0001\u0004\t\t\u000b")
public class ProcTimeBoundedRowsOver
extends ProcessFunctionWithCleanupState<CRow, CRow>
implements Compiler<GeneratedAggregations> {
    private final GeneratedAggregationsFunction genAggregations;
    private final long precedingOffset;
    private final RowTypeInfo aggregatesTypeInfo;
    private final TypeInformation<CRow> inputType;
    private ValueState<Row> accumulatorState;
    private MapState<Object, List<Row>> rowMapState;
    private CRow output;
    private ValueState<Object> counterState;
    private ValueState<Object> smallestTsState;
    private final Logger LOG;
    private GeneratedAggregations function;

    @Override
    public Class<GeneratedAggregations> compile(ClassLoader cl, String name, String code) throws CompileException {
        return Compiler$class.compile(this, cl, name, code);
    }

    private ValueState<Row> accumulatorState() {
        return this.accumulatorState;
    }

    private void accumulatorState_$eq(ValueState<Row> x$1) {
        this.accumulatorState = x$1;
    }

    private MapState<Object, List<Row>> rowMapState() {
        return this.rowMapState;
    }

    private void rowMapState_$eq(MapState<Object, List<Row>> x$1) {
        this.rowMapState = x$1;
    }

    private CRow output() {
        return this.output;
    }

    private void output_$eq(CRow x$1) {
        this.output = x$1;
    }

    private ValueState<Object> counterState() {
        return this.counterState;
    }

    private void counterState_$eq(ValueState<Object> x$1) {
        this.counterState = x$1;
    }

    private ValueState<Object> smallestTsState() {
        return this.smallestTsState;
    }

    private void smallestTsState_$eq(ValueState<Object> x$1) {
        this.smallestTsState = x$1;
    }

    public Logger LOG() {
        return this.LOG;
    }

    private GeneratedAggregations function() {
        return this.function;
    }

    private void function_$eq(GeneratedAggregations x$1) {
        this.function = x$1;
    }

    public void open(Configuration config) {
        this.LOG().debug(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Compiling AggregateHelper: ", " \\n\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.genAggregations.name()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Code:\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.genAggregations.code()}))).toString());
        Class<GeneratedAggregations> clazz = this.compile(this.getRuntimeContext().getUserCodeClassLoader(), this.genAggregations.name(), this.genAggregations.code());
        this.LOG().debug("Instantiating AggregateHelper.");
        this.function_$eq(clazz.newInstance());
        this.output_$eq(new CRow(this.function().createOutputRow(), true));
        ListTypeInfo rowListTypeInfo = new ListTypeInfo((TypeInformation)((CRowTypeInfo)this.inputType).rowType());
        MapStateDescriptor mapStateDescriptor = new MapStateDescriptor("windowBufferMapState", (TypeInformation)BasicTypeInfo.LONG_TYPE_INFO, (TypeInformation)rowListTypeInfo);
        this.rowMapState_$eq((MapState<Object, List<Row>>)this.getRuntimeContext().getMapState(mapStateDescriptor));
        ValueStateDescriptor aggregationStateDescriptor = new ValueStateDescriptor("aggregationState", (TypeInformation)this.aggregatesTypeInfo);
        this.accumulatorState_$eq((ValueState<Row>)this.getRuntimeContext().getState(aggregationStateDescriptor));
        ValueStateDescriptor processedCountDescriptor = new ValueStateDescriptor("processedCountState", Long.TYPE);
        this.counterState_$eq((ValueState<Object>)this.getRuntimeContext().getState(processedCountDescriptor));
        ValueStateDescriptor smallestTimestampDescriptor = new ValueStateDescriptor("smallestTSState", Long.TYPE);
        this.smallestTsState_$eq((ValueState<Object>)this.getRuntimeContext().getState(smallestTimestampDescriptor));
        this.initCleanupTimeState("ProcTimeBoundedRowsOverCleanupTime");
    }

    public void processElement(CRow inputC, ProcessFunction.Context ctx, Collector<CRow> out) {
        long counter;
        long smallestTs;
        Row input = inputC.row();
        long currentTime2 = ctx.timerService().currentProcessingTime();
        this.registerProcessingCleanupTimer(ctx, currentTime2);
        Row accumulators = (Row)this.accumulatorState().value();
        if (accumulators == null) {
            accumulators = this.function().createAccumulators();
        }
        if ((smallestTs = BoxesRunTime.unboxToLong((Object)this.smallestTsState().value())) == 0L) {
            smallestTs = currentTime2;
            this.smallestTsState().update((Object)BoxesRunTime.boxToLong((long)smallestTs));
        }
        if ((counter = BoxesRunTime.unboxToLong((Object)this.counterState().value())) == this.precedingOffset) {
            List retractList = (List)this.rowMapState().get((Object)BoxesRunTime.boxToLong((long)smallestTs));
            Row retractRow = (Row)retractList.get(0);
            this.function().retract(accumulators, retractRow);
            retractList.remove(0);
            if (retractList.isEmpty()) {
                this.rowMapState().remove((Object)BoxesRunTime.boxToLong((long)smallestTs));
                Iterator iter = this.rowMapState().keys().iterator();
                long currentTs = 0L;
                long newSmallestTs = Long.MAX_VALUE;
                while (iter.hasNext()) {
                    currentTs = BoxesRunTime.unboxToLong(iter.next());
                    if (currentTs >= newSmallestTs) continue;
                    newSmallestTs = currentTs;
                }
                this.smallestTsState().update((Object)BoxesRunTime.boxToLong((long)newSmallestTs));
            } else {
                this.rowMapState().put((Object)BoxesRunTime.boxToLong((long)smallestTs), (Object)retractList);
            }
        } else {
            this.counterState().update((Object)BoxesRunTime.boxToLong((long)(++counter)));
        }
        this.function().setForwardedFields(input, this.output().row());
        this.function().accumulate(accumulators, input);
        this.function().setAggregationResults(accumulators, this.output().row());
        List currentTimeState = (List)this.rowMapState().get((Object)BoxesRunTime.boxToLong((long)currentTime2));
        if (currentTimeState == null) {
            ArrayList<Row> newList = new ArrayList<Row>();
            newList.add(input);
            this.rowMapState().put((Object)BoxesRunTime.boxToLong((long)currentTime2), newList);
        } else {
            currentTimeState.add(input);
            this.rowMapState().put((Object)BoxesRunTime.boxToLong((long)currentTime2), (Object)currentTimeState);
        }
        this.accumulatorState().update((Object)accumulators);
        out.collect((Object)this.output());
    }

    public void onTimer(long timestamp, ProcessFunction.OnTimerContext ctx, Collector<CRow> out) {
        if (this.needToCleanupState(timestamp)) {
            this.cleanupState((Seq<State>)Predef$.MODULE$.wrapRefArray((Object[])new State[]{this.rowMapState(), this.accumulatorState(), this.counterState(), this.smallestTsState()}));
        }
    }

    public ProcTimeBoundedRowsOver(GeneratedAggregationsFunction genAggregations, long precedingOffset, RowTypeInfo aggregatesTypeInfo, TypeInformation<CRow> inputType, StreamQueryConfig queryConfig) {
        this.genAggregations = genAggregations;
        this.precedingOffset = precedingOffset;
        this.aggregatesTypeInfo = aggregatesTypeInfo;
        this.inputType = inputType;
        super(queryConfig);
        Compiler$class.$init$(this);
        Preconditions.checkArgument((precedingOffset > 0L ? 1 : 0) != 0);
        this.LOG = LoggerFactory.getLogger(this.getClass());
    }
}

