/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.aggregate;

import java.util.Iterator;
import org.apache.flink.api.common.functions.RichGroupReduceFunction;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.codegen.Compiler;
import org.apache.flink.table.codegen.Compiler$class;
import org.apache.flink.table.codegen.GeneratedAggregationsFunction;
import org.apache.flink.table.runtime.aggregate.GeneratedAggregations;
import org.apache.flink.types.Row;
import org.apache.flink.util.Collector;
import org.codehaus.commons.compiler.CompileException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005ea\u0001B\u0001\u0003\u0001=\u0011a\u0006R1uCN+G\u000fV;nE2,7i\\;oi^Kg\u000eZ8x\u0003\u001e<'+\u001a3vG\u0016<%o\\;q\rVt7\r^5p]*\u00111\u0001B\u0001\nC\u001e<'/Z4bi\u0016T!!\u0002\u0004\u0002\u000fI,h\u000e^5nK*\u0011q\u0001C\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003\u0013)\tQA\u001a7j].T!a\u0003\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0011aA8sO\u000e\u00011c\u0001\u0001\u0011AA!\u0011\u0003\u0007\u000e\u001b\u001b\u0005\u0011\"BA\n\u0015\u0003%1WO\\2uS>t7O\u0003\u0002\u0016-\u000511m\\7n_:T!a\u0006\u0005\u0002\u0007\u0005\u0004\u0018.\u0003\u0002\u001a%\t9\"+[2i\u000fJ|W\u000f\u001d*fIV\u001cWMR;oGRLwN\u001c\t\u00037yi\u0011\u0001\b\u0006\u0003;!\tQ\u0001^=qKNL!a\b\u000f\u0003\u0007I{w\u000fE\u0002\"I\u0019j\u0011A\t\u0006\u0003G\u0019\tqaY8eK\u001e,g.\u0003\u0002&E\tA1i\\7qS2,'\u000f\u0005\u0002(Q5\t!!\u0003\u0002*\u0005\t)r)\u001a8fe\u0006$X\rZ!hOJ,w-\u0019;j_:\u001c\b\u0002C\u0016\u0001\u0005\u000b\u0007I\u0011\u0002\u0017\u0002\u001f\u001d,g.Q4he\u0016<\u0017\r^5p]N,\u0012!\f\t\u0003C9J!a\f\u0012\u0003;\u001d+g.\u001a:bi\u0016$\u0017iZ4sK\u001e\fG/[8og\u001a+hn\u0019;j_:D\u0001\"\r\u0001\u0003\u0002\u0003\u0006I!L\u0001\u0011O\u0016t\u0017iZ4sK\u001e\fG/[8og\u0002B\u0001b\r\u0001\u0003\u0006\u0004%I\u0001N\u0001\u000bo&tGm\\<TSj,W#A\u001b\u0011\u0005YJT\"A\u001c\u000b\u0003a\nQa]2bY\u0006L!AO\u001c\u0003\t1{gn\u001a\u0005\ty\u0001\u0011\t\u0011)A\u0005k\u0005Yq/\u001b8e_^\u001c\u0016N_3!\u0011\u0015q\u0004\u0001\"\u0001@\u0003\u0019a\u0014N\\5u}Q\u0019\u0001)\u0011\"\u0011\u0005\u001d\u0002\u0001\"B\u0016>\u0001\u0004i\u0003\"B\u001a>\u0001\u0004)\u0004\"\u0003#\u0001\u0001\u0004\u0005\r\u0011\"\u0003F\u0003\u0019yW\u000f\u001e9viV\t!\u0004C\u0005H\u0001\u0001\u0007\t\u0019!C\u0005\u0011\u0006Qq.\u001e;qkR|F%Z9\u0015\u0005%c\u0005C\u0001\u001cK\u0013\tYuG\u0001\u0003V]&$\bbB'G\u0003\u0003\u0005\rAG\u0001\u0004q\u0012\n\u0004BB(\u0001A\u0003&!$A\u0004pkR\u0004X\u000f\u001e\u0011\t\u0013E\u0003\u0001\u0019!a\u0001\n\u0013)\u0015\u0001D1dGVlW\u000f\\1u_J\u001c\b\"C*\u0001\u0001\u0004\u0005\r\u0011\"\u0003U\u0003A\t7mY;nk2\fGo\u001c:t?\u0012*\u0017\u000f\u0006\u0002J+\"9QJUA\u0001\u0002\u0004Q\u0002BB,\u0001A\u0003&!$A\u0007bG\u000e,X.\u001e7bi>\u00148\u000f\t\u0005\b3\u0002\u0011\r\u0011\"\u0001[\u0003\raujR\u000b\u00027B\u0011AlX\u0007\u0002;*\u0011a\fD\u0001\u0006g24GG[\u0005\u0003Av\u0013a\u0001T8hO\u0016\u0014\bB\u00022\u0001A\u0003%1,\u0001\u0003M\u001f\u001e\u0003\u0003\"\u00033\u0001\u0001\u0004\u0005\r\u0011\"\u0003f\u0003!1WO\\2uS>tW#\u0001\u0014\t\u0013\u001d\u0004\u0001\u0019!a\u0001\n\u0013A\u0017\u0001\u00044v]\u000e$\u0018n\u001c8`I\u0015\fHCA%j\u0011\u001die-!AA\u0002\u0019Baa\u001b\u0001!B\u00131\u0013!\u00034v]\u000e$\u0018n\u001c8!\u0011\u0015i\u0007\u0001\"\u0011o\u0003\u0011y\u0007/\u001a8\u0015\u0005%{\u0007\"\u00029m\u0001\u0004\t\u0018AB2p]\u001aLw\r\u0005\u0002sk6\t1O\u0003\u0002u\u0011\u0005i1m\u001c8gS\u001e,(/\u0019;j_:L!A^:\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0011\u0015A\b\u0001\"\u0011z\u0003\u0019\u0011X\rZ;dKR!\u0011J_A\u0005\u0011\u0015Yx\u000f1\u0001}\u0003\u001d\u0011XmY8sIN\u0004B!`A\u000355\taPC\u0002\u0000\u0003\u0003\tA\u0001\\1oO*\u0011\u00111A\u0001\u0005U\u00064\u0018-C\u0002\u0002\by\u0014\u0001\"\u0013;fe\u0006\u0014G.\u001a\u0005\b\u0003\u00179\b\u0019AA\u0007\u0003\ryW\u000f\u001e\t\u0006\u0003\u001f\t)BG\u0007\u0003\u0003#Q1!a\u0005\t\u0003\u0011)H/\u001b7\n\t\u0005]\u0011\u0011\u0003\u0002\n\u0007>dG.Z2u_J\u0004")
public class DataSetTumbleCountWindowAggReduceGroupFunction
extends RichGroupReduceFunction<Row, Row>
implements Compiler<GeneratedAggregations> {
    private final GeneratedAggregationsFunction genAggregations;
    private final long windowSize;
    private Row output;
    private Row accumulators;
    private final Logger LOG;
    private GeneratedAggregations function;

    @Override
    public Class<GeneratedAggregations> compile(ClassLoader cl, String name, String code) throws CompileException {
        return Compiler$class.compile(this, cl, name, code);
    }

    private GeneratedAggregationsFunction genAggregations() {
        return this.genAggregations;
    }

    private long windowSize() {
        return this.windowSize;
    }

    private Row output() {
        return this.output;
    }

    private void output_$eq(Row x$1) {
        this.output = x$1;
    }

    private Row accumulators() {
        return this.accumulators;
    }

    private void accumulators_$eq(Row x$1) {
        this.accumulators = x$1;
    }

    public Logger LOG() {
        return this.LOG;
    }

    private GeneratedAggregations function() {
        return this.function;
    }

    private void function_$eq(GeneratedAggregations x$1) {
        this.function = x$1;
    }

    public void open(Configuration config) {
        this.LOG().debug(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Compiling AggregateHelper: ", ".name \\n\\n "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.genAggregations()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Code:\\n", ".code"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.genAggregations()}))).toString());
        Class<GeneratedAggregations> clazz = this.compile(this.getClass().getClassLoader(), this.genAggregations().name(), this.genAggregations().code());
        this.LOG().debug("Instantiating AggregateHelper.");
        this.function_$eq(clazz.newInstance());
        this.output_$eq(this.function().createOutputRow());
        this.accumulators_$eq(this.function().createAccumulators());
    }

    public void reduce(Iterable<Row> records, Collector<Row> out) {
        long count = 0L;
        Iterator<Row> iterator = records.iterator();
        while (iterator.hasNext()) {
            if (count == 0L) {
                this.function().resetAccumulator(this.accumulators());
            }
            Row record = iterator.next();
            this.accumulators_$eq(this.function().mergeAccumulatorsPair(this.accumulators(), record));
            if (this.windowSize() != ++count) continue;
            this.function().setForwardedFields(record, this.output());
            this.function().setAggregationResults(this.accumulators(), this.output());
            out.collect((Object)this.output());
            count = 0L;
        }
    }

    public DataSetTumbleCountWindowAggReduceGroupFunction(GeneratedAggregationsFunction genAggregations, long windowSize) {
        this.genAggregations = genAggregations;
        this.windowSize = windowSize;
        Compiler$class.$init$(this);
        this.LOG = LoggerFactory.getLogger(this.getClass());
    }
}

