/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.aggregate;

import org.apache.flink.api.common.functions.AbstractRichFunction;
import org.apache.flink.api.common.functions.GroupCombineFunction;
import org.apache.flink.api.common.functions.MapPartitionFunction;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.ResultTypeQueryable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.codegen.Compiler;
import org.apache.flink.table.codegen.Compiler$class;
import org.apache.flink.table.codegen.GeneratedAggregationsFunction;
import org.apache.flink.table.runtime.aggregate.GeneratedAggregations;
import org.apache.flink.types.Row;
import org.apache.flink.util.Collector;
import org.codehaus.commons.compiler.CompileException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015e\u0001B\u0001\u0003\u0001=\u0011\u0011\u0006R1uCN+GoU3tg&|gnV5oI><\u0018iZ4sK\u001e\fG/\u001a)sKB\u0013xnY3tg>\u0014(BA\u0002\u0005\u0003%\twm\u001a:fO\u0006$XM\u0003\u0002\u0006\r\u00059!/\u001e8uS6,'BA\u0004\t\u0003\u0015!\u0018M\u00197f\u0015\tI!\"A\u0003gY&t7N\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7\u0001A\n\u0007\u0001AQ2E\n\u0018\u0011\u0005EAR\"\u0001\n\u000b\u0005M!\u0012!\u00034v]\u000e$\u0018n\u001c8t\u0015\t)b#\u0001\u0004d_6lwN\u001c\u0006\u0003/!\t1!\u00199j\u0013\tI\"C\u0001\u000bBEN$(/Y2u%&\u001c\u0007NR;oGRLwN\u001c\t\u0005#miR$\u0003\u0002\u001d%\t!R*\u00199QCJ$\u0018\u000e^5p]\u001a+hn\u0019;j_:\u0004\"AH\u0011\u000e\u0003}Q!\u0001\t\u0005\u0002\u000bQL\b/Z:\n\u0005\tz\"a\u0001*poB!\u0011\u0003J\u000f\u001e\u0013\t)#C\u0001\u000bHe>,\boQ8nE&tWMR;oGRLwN\u001c\t\u0004O1jR\"\u0001\u0015\u000b\u0005%R\u0013!\u0003;za\u0016,H/\u001b7t\u0015\tYc#\u0001\u0003kCZ\f\u0017BA\u0017)\u0005M\u0011Vm];miRK\b/Z)vKJL\u0018M\u00197f!\ry#\u0007N\u0007\u0002a)\u0011\u0011GB\u0001\bG>$WmZ3o\u0013\t\u0019\u0004G\u0001\u0005D_6\u0004\u0018\u000e\\3s!\t)d'D\u0001\u0003\u0013\t9$AA\u000bHK:,'/\u0019;fI\u0006;wM]3hCRLwN\\:\t\u0011e\u0002!\u0011!Q\u0001\ni\nqbZ3o\u0003\u001e<'/Z4bi&|gn\u001d\t\u0003_mJ!\u0001\u0010\u0019\u0003;\u001d+g.\u001a:bi\u0016$\u0017iZ4sK\u001e\fG/[8og\u001a+hn\u0019;j_:D\u0001B\u0010\u0001\u0003\u0002\u0003\u0006IaP\u0001\u0017W\u0016L8/\u00118e\u0003\u001e<'/Z4bi\u0016\u001c\u0018I]5usB\u0011\u0001iQ\u0007\u0002\u0003*\t!)A\u0003tG\u0006d\u0017-\u0003\u0002E\u0003\n\u0019\u0011J\u001c;\t\u0011\u0019\u0003!\u0011!Q\u0001\n\u001d\u000b1aZ1q!\t\u0001\u0005*\u0003\u0002J\u0003\n!Aj\u001c8h\u0011!Y\u0005A!a\u0001\n\u0003a\u0015aE5oi\u0016\u0014X.\u001a3jCR,'k\\<UsB,W#A'\u0011\u00079\u000bV$D\u0001P\u0015\t\u0001F#\u0001\u0005usB,\u0017N\u001c4p\u0013\t\u0011vJA\bUsB,\u0017J\u001c4pe6\fG/[8o\u0011!!\u0006A!a\u0001\n\u0003)\u0016aF5oi\u0016\u0014X.\u001a3jCR,'k\\<UsB,w\fJ3r)\t1\u0016\f\u0005\u0002A/&\u0011\u0001,\u0011\u0002\u0005+:LG\u000fC\u0004['\u0006\u0005\t\u0019A'\u0002\u0007a$\u0013\u0007\u0003\u0005]\u0001\t\u0005\t\u0015)\u0003N\u0003QIg\u000e^3s[\u0016$\u0017.\u0019;f%><H+\u001f9fA!\u00121L\u0018\t\u0003\u0001~K!\u0001Y!\u0003\u0013Q\u0014\u0018M\\:jK:$\b\"\u00022\u0001\t\u0003\u0019\u0017A\u0002\u001fj]&$h\bF\u0003eK\u001a<\u0007\u000e\u0005\u00026\u0001!)\u0011(\u0019a\u0001u!)a(\u0019a\u0001\u007f!)a)\u0019a\u0001\u000f\")1*\u0019a\u0001\u001b\"I!\u000e\u0001a\u0001\u0002\u0004%Ia[\u0001\u0007_V$\b/\u001e;\u0016\u0003uA\u0011\"\u001c\u0001A\u0002\u0003\u0007I\u0011\u00028\u0002\u0015=,H\u000f];u?\u0012*\u0017\u000f\u0006\u0002W_\"9!\f\\A\u0001\u0002\u0004i\u0002BB9\u0001A\u0003&Q$A\u0004pkR\u0004X\u000f\u001e\u0011\t\u000fM\u0004!\u0019!C\u0005i\u0006y!o\\<US6,g)[3mIB{7/F\u0001@\u0011\u00191\b\u0001)A\u0005\u007f\u0005\u0001\"o\\<US6,g)[3mIB{7\u000f\t\u0005\nq\u0002\u0001\r\u00111A\u0005\n-\fA\"Y2dk6,H.\u0019;peND\u0011B\u001f\u0001A\u0002\u0003\u0007I\u0011B>\u0002!\u0005\u001c7-^7vY\u0006$xN]:`I\u0015\fHC\u0001,}\u0011\u001dQ\u00160!AA\u0002uAaA \u0001!B\u0013i\u0012!D1dGVlW\u000f\\1u_J\u001c\b\u0005C\u0005\u0002\u0002\u0001\u0011\r\u0011\"\u0001\u0002\u0004\u0005\u0019AjT$\u0016\u0005\u0005\u0015\u0001\u0003BA\u0004\u0003\u001bi!!!\u0003\u000b\u0007\u0005-A\"A\u0003tY\u001a$$.\u0003\u0003\u0002\u0010\u0005%!A\u0002'pO\u001e,'\u000f\u0003\u0005\u0002\u0014\u0001\u0001\u000b\u0011BA\u0003\u0003\u0011auj\u0012\u0011\t\u0017\u0005]\u0001\u00011AA\u0002\u0013%\u0011\u0011D\u0001\tMVt7\r^5p]V\tA\u0007C\u0006\u0002\u001e\u0001\u0001\r\u00111A\u0005\n\u0005}\u0011\u0001\u00044v]\u000e$\u0018n\u001c8`I\u0015\fHc\u0001,\u0002\"!A!,a\u0007\u0002\u0002\u0003\u0007A\u0007C\u0004\u0002&\u0001\u0001\u000b\u0015\u0002\u001b\u0002\u0013\u0019,hn\u0019;j_:\u0004\u0003bBA\u0015\u0001\u0011\u0005\u00131F\u0001\u0005_B,g\u000eF\u0002W\u0003[A\u0001\"a\f\u0002(\u0001\u0007\u0011\u0011G\u0001\u0007G>tg-[4\u0011\t\u0005M\u0012\u0011H\u0007\u0003\u0003kQ1!a\u000e\t\u00035\u0019wN\u001c4jOV\u0014\u0018\r^5p]&!\u00111HA\u001b\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\"9\u0011q\b\u0001\u0005B\u0005\u0005\u0013aB2p[\nLg.\u001a\u000b\u0006-\u0006\r\u0013Q\u000b\u0005\t\u0003\u000b\ni\u00041\u0001\u0002H\u00059!/Z2pe\u0012\u001c\b#BA%\u0003#jRBAA&\u0015\u0011\ti%a\u0014\u0002\t1\fgn\u001a\u0006\u0002W%!\u00111KA&\u0005!IE/\u001a:bE2,\u0007\u0002CA,\u0003{\u0001\r!!\u0017\u0002\u0007=,H\u000fE\u0003\u0002\\\u0005\u0005T$\u0004\u0002\u0002^)\u0019\u0011q\f\u0005\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003G\niFA\u0005D_2dWm\u0019;pe\"9\u0011q\r\u0001\u0005B\u0005%\u0014\u0001D7baB\u000b'\u000f^5uS>tG#\u0002,\u0002l\u00055\u0004\u0002CA#\u0003K\u0002\r!a\u0012\t\u0011\u0005]\u0013Q\ra\u0001\u00033Bq!!\u001d\u0001\t\u0003\t\u0019(A\u0005e_\u000e{G\u000e\\3diR9a+!\u001e\u0002x\u0005m\u0004\u0002CA,\u0003_\u0002\r!!\u0017\t\u000f\u0005e\u0014q\u000ea\u0001\u000f\u0006Yq/\u001b8e_^\u001cF/\u0019:u\u0011\u001d\ti(a\u001cA\u0002\u001d\u000b\u0011b^5oI><XI\u001c3\t\u000f\u0005\u0005\u0005\u0001\"\u0011\u0002\u0004\u0006yq-\u001a;Qe>$WoY3e)f\u0004X\rF\u0001N\u0001")
public class DataSetSessionWindowAggregatePreProcessor
extends AbstractRichFunction
implements MapPartitionFunction<Row, Row>,
GroupCombineFunction<Row, Row>,
ResultTypeQueryable<Row>,
Compiler<GeneratedAggregations> {
    private final GeneratedAggregationsFunction genAggregations;
    private final long gap;
    private transient TypeInformation<Row> intermediateRowType;
    private Row output;
    private final int rowTimeFieldPos;
    private Row accumulators;
    private final Logger LOG;
    private GeneratedAggregations function;

    @Override
    public Class<GeneratedAggregations> compile(ClassLoader cl, String name, String code) throws CompileException {
        return Compiler$class.compile(this, cl, name, code);
    }

    public TypeInformation<Row> intermediateRowType() {
        return this.intermediateRowType;
    }

    public void intermediateRowType_$eq(TypeInformation<Row> x$1) {
        this.intermediateRowType = x$1;
    }

    private Row output() {
        return this.output;
    }

    private void output_$eq(Row x$1) {
        this.output = x$1;
    }

    private int rowTimeFieldPos() {
        return this.rowTimeFieldPos;
    }

    private Row accumulators() {
        return this.accumulators;
    }

    private void accumulators_$eq(Row x$1) {
        this.accumulators = x$1;
    }

    public Logger LOG() {
        return this.LOG;
    }

    private GeneratedAggregations function() {
        return this.function;
    }

    private void function_$eq(GeneratedAggregations x$1) {
        this.function = x$1;
    }

    public void open(Configuration config) {
        this.LOG().debug(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Compiling AggregateHelper: ", ".name \\n\\n "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.genAggregations}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Code:\\n", ".code"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.genAggregations}))).toString());
        Class<GeneratedAggregations> clazz = this.compile(this.getClass().getClassLoader(), this.genAggregations.name(), this.genAggregations.code());
        this.LOG().debug("Instantiating AggregateHelper.");
        this.function_$eq(clazz.newInstance());
        this.accumulators_$eq(this.function().createAccumulators());
        this.output_$eq(this.function().createOutputRow());
    }

    public void combine(Iterable<Row> records, Collector<Row> out) {
        Long windowStart = null;
        Long windowEnd = null;
        Long currentRowTime = null;
        this.function().resetAccumulator(this.accumulators());
        for (Row record : records) {
            currentRowTime = Predef$.MODULE$.long2Long(BoxesRunTime.unboxToLong((Object)record.getField(this.rowTimeFieldPos())));
            if (windowEnd == null || windowEnd != null && Predef$.MODULE$.Long2long(currentRowTime) > Predef$.MODULE$.Long2long(windowEnd)) {
                if (windowEnd == null) {
                    this.function().setForwardedFields(record, this.output());
                } else {
                    this.doCollect(out, Predef$.MODULE$.Long2long(windowStart), Predef$.MODULE$.Long2long(windowEnd));
                    this.function().resetAccumulator(this.accumulators());
                }
                windowStart = Predef$.MODULE$.long2Long(BoxesRunTime.unboxToLong((Object)record.getField(this.rowTimeFieldPos())));
            }
            this.function().mergeAccumulatorsPair(this.accumulators(), record);
            windowEnd = Predef$.MODULE$.long2Long(Predef$.MODULE$.Long2long(currentRowTime) + this.gap);
        }
        this.doCollect(out, Predef$.MODULE$.Long2long(windowStart), Predef$.MODULE$.Long2long(windowEnd));
    }

    public void mapPartition(Iterable<Row> records, Collector<Row> out) {
        this.combine(records, out);
    }

    public void doCollect(Collector<Row> out, long windowStart, long windowEnd) {
        this.function().setAggregationResults(this.accumulators(), this.output());
        this.output().setField(this.rowTimeFieldPos(), (Object)BoxesRunTime.boxToLong((long)windowStart));
        this.output().setField(this.rowTimeFieldPos() + 1, (Object)BoxesRunTime.boxToLong((long)windowEnd));
        out.collect((Object)this.output());
    }

    public TypeInformation<Row> getProducedType() {
        return this.intermediateRowType();
    }

    public DataSetSessionWindowAggregatePreProcessor(GeneratedAggregationsFunction genAggregations, int keysAndAggregatesArity, long gap, TypeInformation<Row> intermediateRowType) {
        this.genAggregations = genAggregations;
        this.gap = gap;
        this.intermediateRowType = intermediateRowType;
        Compiler$class.$init$(this);
        this.rowTimeFieldPos = keysAndAggregatesArity;
        this.LOG = LoggerFactory.getLogger(this.getClass());
    }
}

