/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.validate;

import java.util.List;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.validate.SqlNameMatcher;
import org.apache.calcite.sql.validate.SqlValidatorNamespace;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.util.Util;
import org.apache.flink.shaded.calcite.com.google.common.collect.ImmutableList;

public class SqlQualified {
    private final SqlValidatorScope scope;
    public final int prefixLength;
    public final SqlValidatorNamespace namespace;
    public final SqlIdentifier identifier;

    private SqlQualified(SqlValidatorScope scope, int prefixLength, SqlValidatorNamespace namespace, SqlIdentifier identifier) {
        this.scope = scope;
        this.prefixLength = prefixLength;
        this.namespace = namespace;
        this.identifier = identifier;
    }

    public String toString() {
        return "{id: " + this.identifier.toString() + ", prefix: " + this.prefixLength + "}";
    }

    public static SqlQualified create(SqlValidatorScope scope, int prefixLength, SqlValidatorNamespace namespace, SqlIdentifier identifier) {
        return new SqlQualified(scope, prefixLength, namespace, identifier);
    }

    public List<String> translatedNames() {
        if (this.scope == null) {
            return this.identifier.names;
        }
        SqlNameMatcher nameMatcher = this.scope.getValidator().getCatalogReader().nameMatcher();
        ImmutableList.Builder builder = ImmutableList.builder();
        SqlValidatorScope.ResolvedImpl resolved = new SqlValidatorScope.ResolvedImpl();
        List<String> prefix = Util.skipLast(this.identifier.names);
        this.scope.resolve(prefix, nameMatcher, false, resolved);
        SqlValidatorNamespace namespace = resolved.count() == 1 ? resolved.only().namespace : null;
        builder.add(this.identifier.names.get(0));
        for (String name : Util.skip(this.identifier.names)) {
            if (namespace != null) {
                name = namespace.translate(name);
                namespace = null;
            }
            builder.add(name);
        }
        return builder.build();
    }

    public final List<String> prefix() {
        return this.identifier.names.subList(0, this.prefixLength);
    }

    public final List<String> suffix() {
        return Util.skip(this.identifier.names, this.prefixLength);
    }

    public final List<String> suffixTranslated() {
        return Util.skip(this.translatedNames(), this.prefixLength);
    }
}

