/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.type;

import java.util.List;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.type.SqlOperandCountRanges;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlSingleOperandTypeChecker;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.Static;
import org.apache.flink.shaded.calcite.com.google.common.base.Predicate;
import org.apache.flink.shaded.calcite.com.google.common.collect.ImmutableList;

public class FamilyOperandTypeChecker
implements SqlSingleOperandTypeChecker {
    protected final ImmutableList<SqlTypeFamily> families;
    protected final Predicate<Integer> optional;

    FamilyOperandTypeChecker(List<SqlTypeFamily> families, Predicate<Integer> optional) {
        this.families = ImmutableList.copyOf(families);
        this.optional = optional;
    }

    @Override
    public boolean isOptional(int i) {
        return this.optional.apply(i);
    }

    @Override
    public boolean checkSingleOperandType(SqlCallBinding callBinding, SqlNode node, int iFormalOperand, boolean throwOnFailure) {
        SqlTypeFamily family = (SqlTypeFamily)this.families.get(iFormalOperand);
        if (family == SqlTypeFamily.ANY) {
            return true;
        }
        if (SqlUtil.isNullLiteral(node, false)) {
            if (throwOnFailure) {
                throw callBinding.getValidator().newValidationError(node, Static.RESOURCE.nullIllegal());
            }
            return false;
        }
        RelDataType type = callBinding.getValidator().deriveType(callBinding.getScope(), node);
        SqlTypeName typeName = type.getSqlTypeName();
        if (typeName.getFamily() == SqlTypeFamily.ANY) {
            return true;
        }
        if (!family.getTypeNames().contains((Object)typeName)) {
            if (throwOnFailure) {
                throw callBinding.newValidationSignatureError();
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        if (this.families.size() != callBinding.getOperandCount()) {
            return false;
        }
        for (Ord<SqlNode> op : Ord.zip(callBinding.operands())) {
            if (this.checkSingleOperandType(callBinding, (SqlNode)op.e, op.i, throwOnFailure)) continue;
            return false;
        }
        return true;
    }

    @Override
    public SqlOperandCountRange getOperandCountRange() {
        int max;
        int min;
        for (min = max = this.families.size(); min > 0 && this.optional.apply(min - 1); --min) {
        }
        return SqlOperandCountRanges.between(min, max);
    }

    @Override
    public String getAllowedSignatures(SqlOperator op, String opName) {
        return SqlUtil.getAliasedSignature(op, opName, this.families);
    }

    @Override
    public SqlOperandTypeChecker.Consistency getConsistency() {
        return SqlOperandTypeChecker.Consistency.NONE;
    }
}

