/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.type;

import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFamily;
import org.apache.calcite.sql.type.AbstractSqlType;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.flink.shaded.calcite.com.google.common.base.Preconditions;

public class ArraySqlType
extends AbstractSqlType {
    private final RelDataType elementType;

    public ArraySqlType(RelDataType elementType, boolean isNullable) {
        super(SqlTypeName.ARRAY, isNullable, null);
        this.elementType = Preconditions.checkNotNull(elementType);
        this.computeDigest();
    }

    @Override
    protected void generateTypeString(StringBuilder sb, boolean withDetail) {
        if (withDetail) {
            sb.append(this.elementType.getFullTypeString());
        } else {
            sb.append(this.elementType.toString());
        }
        sb.append(" ARRAY");
    }

    @Override
    public RelDataType getComponentType() {
        return this.elementType;
    }

    @Override
    public RelDataTypeFamily getFamily() {
        return this;
    }
}

