/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.schema.impl;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelProtoDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.schema.ModifiableView;
import org.apache.calcite.schema.Path;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.Wrapper;
import org.apache.calcite.schema.impl.ViewTable;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql2rel.InitializerExpressionFactory;
import org.apache.calcite.sql2rel.NullInitializerExpressionFactory;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.flink.shaded.calcite.com.google.common.collect.ImmutableMap;
import org.apache.flink.shaded.calcite.com.google.common.collect.Maps;

public class ModifiableViewTable
extends ViewTable
implements ModifiableView,
Wrapper {
    private final Table table;
    private final Path tablePath;
    private final RexNode constraint;
    private final ImmutableIntList columnMapping;
    private final InitializerExpressionFactory initializerExpressionFactory;

    public ModifiableViewTable(Type elementType, RelProtoDataType rowType, String viewSql, List<String> schemaPath, List<String> viewPath, Table table, Path tablePath, RexNode constraint, ImmutableIntList columnMapping, RelDataTypeFactory typeFactory) {
        super(elementType, rowType, viewSql, schemaPath, viewPath);
        this.table = table;
        this.tablePath = tablePath;
        this.constraint = constraint;
        this.columnMapping = columnMapping;
        this.initializerExpressionFactory = new ModifiableViewTableInitializerExpressionFactory(typeFactory);
    }

    @Override
    public RexNode getConstraint(RexBuilder rexBuilder, RelDataType tableRowType) {
        return rexBuilder.copy(this.constraint);
    }

    @Override
    public ImmutableIntList getColumnMapping() {
        return this.columnMapping;
    }

    @Override
    public Table getTable() {
        return this.table;
    }

    @Override
    public Path getTablePath() {
        return this.tablePath;
    }

    @Override
    public <C> C unwrap(Class<C> aClass) {
        if (aClass.isInstance(this.initializerExpressionFactory)) {
            return aClass.cast(this.initializerExpressionFactory);
        }
        if (aClass.isInstance(this.table)) {
            return aClass.cast(this.table);
        }
        return null;
    }

    private class ModifiableViewTableInitializerExpressionFactory
    extends NullInitializerExpressionFactory {
        private final ImmutableMap<Integer, RexNode> projectMap;

        private ModifiableViewTableInitializerExpressionFactory(RelDataTypeFactory typeFactory) {
            super(typeFactory);
            HashMap<Integer, RexNode> projectMap = Maps.newHashMap();
            ArrayList<RexNode> filters = new ArrayList<RexNode>();
            RelOptUtil.inferViewPredicates(projectMap, filters, ModifiableViewTable.this.constraint);
            assert (filters.isEmpty());
            this.projectMap = ImmutableMap.copyOf(projectMap);
        }

        @Override
        public boolean isGeneratedAlways(RelOptTable table, int iColumn) {
            assert (table.unwrap(ModifiableViewTable.class) != null);
            return false;
        }

        @Override
        public RexNode newColumnDefaultValue(RelOptTable table, int iColumn) {
            InitializerExpressionFactory initializerExpressionFactory;
            ModifiableViewTable viewTable = table.unwrap(ModifiableViewTable.class);
            RelDataType viewType = viewTable.getRowType(this.rexBuilder.getTypeFactory());
            RelDataType iType = viewType.getFieldList().get(iColumn).getType();
            int mappedOrdinal = viewTable.columnMapping.get(iColumn);
            RexNode viewConstraint = this.projectMap.get(mappedOrdinal);
            if (viewConstraint != null) {
                return this.rexBuilder.ensureType(iType, viewConstraint, true);
            }
            Table schemaTable = viewTable.unwrap(Table.class);
            if (schemaTable instanceof Wrapper && (initializerExpressionFactory = ((Wrapper)((Object)schemaTable)).unwrap(InitializerExpressionFactory.class)) != null) {
                RexNode tableConstraint = initializerExpressionFactory.newColumnDefaultValue(table, iColumn);
                return this.rexBuilder.ensureType(iType, tableConstraint, true);
            }
            return super.newColumnDefaultValue(table, iColumn);
        }

        @Override
        public RexNode newAttributeInitializer(RelDataType type, SqlFunction constructor, int iAttribute, List<RexNode> constructorArgs) {
            throw new UnsupportedOperationException("Not implemented - unknown requirements");
        }
    }
}

