/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rex;

import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBiVisitor;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.rex.RexWindow;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.util.ControlFlowException;
import org.apache.calcite.util.Util;
import org.apache.flink.shaded.calcite.com.google.common.base.Preconditions;

public class RexOver
extends RexCall {
    private static final Finder FINDER = new Finder();
    private final RexWindow window;

    RexOver(RelDataType type, SqlAggFunction op, List<RexNode> operands, RexWindow window) {
        super(type, op, operands);
        Preconditions.checkArgument(op.isAggregator());
        this.window = Preconditions.checkNotNull(window);
    }

    public SqlAggFunction getAggOperator() {
        return (SqlAggFunction)this.getOperator();
    }

    public RexWindow getWindow() {
        return this.window;
    }

    @Override
    protected String computeDigest(boolean withType) {
        return super.computeDigest(withType) + " OVER (" + this.window + ")";
    }

    @Override
    public <R> R accept(RexVisitor<R> visitor) {
        return visitor.visitOver(this);
    }

    @Override
    public <R, P> R accept(RexBiVisitor<R, P> visitor, P arg) {
        return visitor.visitOver(this, arg);
    }

    public static boolean containsOver(RexNode expr) {
        try {
            expr.accept(FINDER);
            return false;
        }
        catch (OverFound e) {
            Util.swallow(e, null);
            return true;
        }
    }

    public static boolean containsOver(RexProgram program) {
        try {
            RexUtil.apply((RexVisitor<Void>)FINDER, program.getExprList(), null);
            return false;
        }
        catch (OverFound e) {
            Util.swallow(e, null);
            return true;
        }
    }

    public static boolean containsOver(List<RexNode> exprs, RexNode condition) {
        try {
            RexUtil.apply((RexVisitor<Void>)FINDER, exprs, condition);
            return false;
        }
        catch (OverFound e) {
            Util.swallow(e, null);
            return true;
        }
    }

    @Override
    public RexCall clone(RelDataType type, List<RexNode> operands) {
        throw new UnsupportedOperationException();
    }

    private static class Finder
    extends RexVisitorImpl<Void> {
        public Finder() {
            super(true);
        }

        @Override
        public Void visitOver(RexOver over2) {
            throw OverFound.INSTANCE;
        }
    }

    private static class OverFound
    extends ControlFlowException {
        public static final OverFound INSTANCE = new OverFound();

        private OverFound() {
        }
    }
}

